/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.metrics.TaskCounterUpdater;

public abstract class RuntimeTask {
    protected AtomicBoolean hasFatalError = new AtomicBoolean(false);
    protected AtomicReference<Throwable> fatalError = new AtomicReference();
    protected String fatalErrorMessage = null;
    protected float progress;
    protected final TezCounters tezCounters;
    private final Map<String, TezCounters> counterMap = Maps.newConcurrentMap();
    protected final TaskSpec taskSpec;
    protected final Configuration tezConf;
    protected final TezUmbilical tezUmbilical;
    protected final AtomicInteger eventCounter;
    protected final AtomicInteger nextFromEventId;
    protected final AtomicInteger nextPreRoutedEventId;
    private final AtomicBoolean taskDone;
    private final TaskCounterUpdater counterUpdater;
    private final TaskStatistics statistics;
    protected final AtomicReference<State> state = new AtomicReference();

    protected RuntimeTask(TaskSpec taskSpec, Configuration tezConf, TezUmbilical tezUmbilical, String pid, boolean setupSysCounterUpdater) {
        this.taskSpec = taskSpec;
        this.tezConf = tezConf;
        this.tezUmbilical = tezUmbilical;
        this.tezCounters = new TezCounters();
        this.eventCounter = new AtomicInteger(0);
        this.nextFromEventId = new AtomicInteger(0);
        this.nextPreRoutedEventId = new AtomicInteger(0);
        this.progress = 0.0f;
        this.taskDone = new AtomicBoolean(false);
        this.statistics = new TaskStatistics();
        this.counterUpdater = setupSysCounterUpdater ? new TaskCounterUpdater(this.tezCounters, tezConf, pid) : null;
    }

    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    public TezCounters addAndGetTezCounter(String name) {
        TezCounters counter = new TezCounters();
        this.counterMap.put(name, counter);
        return counter;
    }

    public boolean hasInitialized() {
        return EnumSet.of(State.RUNNING, State.CLOSED).contains((Object)this.state.get());
    }

    public String getVertexName() {
        return this.taskSpec.getVertexName();
    }

    public void setFatalError(Throwable t, String message) {
        this.hasFatalError.set(true);
        this.fatalError.set(t);
        this.fatalErrorMessage = message;
    }

    public Throwable getFatalError() {
        return this.fatalError.get();
    }

    public boolean hadFatalError() {
        return this.hasFatalError.get();
    }

    public synchronized void setProgress(float progress) {
        this.progress = progress;
    }

    public synchronized float getProgress() {
        return this.progress;
    }

    public TezCounters getCounters() {
        TezCounters fullCounters = new TezCounters();
        fullCounters.incrAllCounters((AbstractCounters)this.tezCounters);
        for (TezCounters counter : this.counterMap.values()) {
            fullCounters.incrAllCounters((AbstractCounters)counter);
        }
        return fullCounters;
    }

    public TaskStatistics getTaskStatistics() {
        return this.statistics;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskSpec.getTaskAttemptID();
    }

    public abstract void handleEvents(Collection<TezEvent> var1);

    public int getEventCounter() {
        return this.eventCounter.get();
    }

    public int getNextFromEventId() {
        return this.nextFromEventId.get();
    }

    public int getNextPreRoutedEventId() {
        return this.nextPreRoutedEventId.get();
    }

    public void setNextFromEventId(int nextFromEventId) {
        this.nextFromEventId.set(nextFromEventId);
    }

    public void setNextPreRoutedEventId(int nextPreRoutedEventId) {
        this.nextPreRoutedEventId.set(nextPreRoutedEventId);
    }

    public boolean isTaskDone() {
        return this.taskDone.get();
    }

    public void setFrameworkCounters() {
        if (this.counterUpdater != null) {
            this.counterUpdater.updateCounters();
        }
    }

    protected void setTaskDone() {
        this.taskDone.set(true);
    }

    public abstract void abortTask();

    protected static enum State {
        NEW,
        INITED,
        RUNNING,
        CLOSED;

    }
}

