/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.ErrorReporter;
import org.apache.tez.runtime.task.TaskRunner2Callable;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTaskRunner2 {
    private static final Logger LOG = LoggerFactory.getLogger(TezTaskRunner2.class);
    private final LogicalIOProcessorRuntimeTask task;
    private final UserGroupInformation ugi;
    private final TaskReporterInterface taskReporter;
    private final ListeningExecutorService executor;
    private final UmbilicalAndErrorHandler umbilicalAndErrorHandler;
    private final AtomicBoolean killTaskRequested = new AtomicBoolean(false);
    private final AtomicBoolean stopContainerRequested = new AtomicBoolean(false);
    private final AtomicBoolean taskComplete = new AtomicBoolean(false);
    private final AtomicBoolean errorSeen = new AtomicBoolean(false);
    private volatile EndReason firstEndReason = null;
    private volatile Throwable firstException;
    private volatile EventMetaData exceptionSourceInfo;
    private final AtomicBoolean errorReporterToAm = new AtomicBoolean(false);
    private boolean oobSignalErrorInProgress = false;
    private final Lock oobSignalLock = new ReentrantLock();
    private final Condition oobSignalCondition = this.oobSignalLock.newCondition();
    private volatile long taskKillStartTime = 0L;
    private volatile TaskRunner2Callable taskRunnerCallable;

    public TezTaskRunner2(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> serviceProviderEnvMap, Multimap<String, String> startedInputsMap, TaskReporterInterface taskReporter, ListeningExecutorService executor, ObjectRegistry objectRegistry, String pid, ExecutionContext executionContext, long memAvailable) throws IOException {
        this.ugi = ugi;
        this.taskReporter = taskReporter;
        this.executor = executor;
        this.umbilicalAndErrorHandler = new UmbilicalAndErrorHandler();
        this.task = new LogicalIOProcessorRuntimeTask(taskSpec, appAttemptNumber, tezConf, localDirs, this.umbilicalAndErrorHandler, serviceConsumerMetadata, serviceProviderEnvMap, startedInputsMap, objectRegistry, pid, executionContext, memAvailable);
    }

    /*
     * Exception decompiling
     */
    public TaskRunner2Result run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void processCallableResult(TaskRunner2Callable.TaskRunner2CallableResult executionResult) {
        if (executionResult != null) {
            TezTaskRunner2 tezTaskRunner2 = this;
            synchronized (tezTaskRunner2) {
                if (this.isRunningState()) {
                    if (executionResult.error != null) {
                        this.trySettingEndReason(EndReason.TASK_ERROR);
                        this.registerFirstException(executionResult.error, null);
                    } else {
                        this.trySettingEndReason(EndReason.SUCCESS);
                        this.taskComplete.set(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killTask() {
        boolean isFirstError = false;
        TezTaskRunner2 tezTaskRunner2 = this;
        synchronized (tezTaskRunner2) {
            if (this.isRunningState()) {
                if (this.trySettingEndReason(EndReason.KILL_REQUESTED)) {
                    isFirstError = true;
                    this.killTaskRequested.set(true);
                } else {
                    this.logErrorIgnored("killTask", null);
                }
            } else {
                this.logErrorIgnored("killTask", null);
            }
        }
        if (isFirstError) {
            this.logAborting("killTask");
            this.killTaskInternal();
            return true;
        }
        return false;
    }

    private void killTaskInternal() {
        if (this.taskRunnerCallable != null) {
            this.taskKillStartTime = System.currentTimeMillis();
            this.taskRunnerCallable.interruptTask();
        }
    }

    private boolean isRunningState() {
        return !this.taskComplete.get() && !this.killTaskRequested.get() && !this.stopContainerRequested.get() && !this.errorSeen.get();
    }

    private synchronized boolean trySettingEndReason(EndReason endReason) {
        if (this.isRunningState()) {
            this.firstEndReason = endReason;
            return true;
        }
        return false;
    }

    private void registerFirstException(Throwable t, EventMetaData sourceInfo) {
        Preconditions.checkState((boolean)this.isRunningState());
        this.errorSeen.set(true);
        this.firstException = t;
        this.exceptionSourceInfo = sourceInfo;
    }

    private String getTaskDiagnosticsString(Throwable t, String message) {
        String diagnostics = t != null && message != null ? "Failure while running task: " + ExceptionUtils.getStackTrace((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "Failure while running task: " + ExceptionUtils.getStackTrace((Throwable)t) : " errorMessage=" + message));
        return diagnostics;
    }

    private TaskRunner2Result logAndReturnEndResult(EndReason endReason, Throwable firstError, boolean stopContainerRequested) {
        TaskRunner2Result result = new TaskRunner2Result(endReason, firstError, stopContainerRequested);
        LOG.info("TaskRunnerResult for {} : {}  ", (Object)this.task.getTaskAttemptID(), (Object)result);
        return result;
    }

    private void handleFinalStatusUpdateFailure(Throwable t, boolean successReportAttempted) {
        LOG.warn("Failure while reporting state= {} to AM", (Object)(successReportAttempted ? "success" : "failure/killed"), (Object)t);
    }

    private void logErrorIgnored(String ignoredEndReason, String errorMessage) {
        Object[] objectArray = new Object[4];
        objectArray[0] = ignoredEndReason;
        objectArray[1] = this.task.getTaskAttemptID();
        objectArray[2] = this.firstEndReason;
        objectArray[3] = this.firstException == null ? (errorMessage == null ? "" : errorMessage) : this.firstException.getMessage();
        LOG.info("Ignoring {} request since the task with id {} has ended for reason: {}. IgnoredError: {} ", objectArray);
    }

    private void logAborting(String abortReason) {
        LOG.info("Attempting to abort {} due to an invocation of {}", (Object)this.task.getTaskAttemptID(), (Object)abortReason);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$tez$runtime$task$EndReason;

        static {
            $SwitchMap$org$apache$tez$runtime$task$EndReason = new int[EndReason.values().length];
            try {
                1.$SwitchMap$org$apache$tez$runtime$task$EndReason[EndReason.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tez$runtime$task$EndReason[EndReason.CONTAINER_STOP_REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tez$runtime$task$EndReason[EndReason.KILL_REQUESTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tez$runtime$task$EndReason[EndReason.COMMUNICATION_FAILURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tez$runtime$task$EndReason[EndReason.TASK_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class UmbilicalAndErrorHandler
    implements TezUmbilical,
    ErrorReporter {
        UmbilicalAndErrorHandler() {
        }

        @Override
        public void addEvents(Collection<TezEvent> events) {
            if (TezTaskRunner2.this.isRunningState()) {
                TezTaskRunner2.this.taskReporter.addEvents(TezTaskRunner2.this.task.getTaskAttemptID(), events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalFatalError(TezTaskAttemptID taskAttemptID, Throwable t, String message, EventMetaData sourceInfo) {
            boolean isFirstError = false;
            TezTaskRunner2 tezTaskRunner2 = TezTaskRunner2.this;
            synchronized (tezTaskRunner2) {
                if (TezTaskRunner2.this.isRunningState()) {
                    if (TezTaskRunner2.this.trySettingEndReason(EndReason.TASK_ERROR)) {
                        if (t == null) {
                            t = new RuntimeException(message == null ? "FatalError: No user message or exception specified" : message);
                        }
                        TezTaskRunner2.this.registerFirstException(t, sourceInfo);
                        LOG.info("Received notification of a fatal error which will cause the task to die", t);
                        isFirstError = true;
                        TezTaskRunner2.this.errorReporterToAm.set(true);
                        TezTaskRunner2.this.oobSignalErrorInProgress = true;
                    } else {
                        TezTaskRunner2.this.logErrorIgnored("signalFatalError", message);
                    }
                } else {
                    TezTaskRunner2.this.logErrorIgnored("signalFatalError", message);
                }
            }
            if (isFirstError) {
                TezTaskRunner2.this.logAborting("signalFatalError");
                TezTaskRunner2.this.killTaskInternal();
                try {
                    TezTaskRunner2.this.taskReporter.taskFailed(taskAttemptID, t, TezTaskRunner2.this.getTaskDiagnosticsString(t, message), sourceInfo);
                }
                catch (IOException e) {
                    TezTaskRunner2.this.handleFinalStatusUpdateFailure(e, true);
                }
                catch (TezException e) {
                    TezTaskRunner2.this.handleFinalStatusUpdateFailure(e, true);
                }
                finally {
                    TezTaskRunner2.this.oobSignalLock.lock();
                    try {
                        TezTaskRunner2.this.oobSignalErrorInProgress = false;
                        TezTaskRunner2.this.oobSignalCondition.signal();
                    }
                    finally {
                        TezTaskRunner2.this.oobSignalLock.unlock();
                    }
                }
            }
        }

        @Override
        public boolean canCommit(TezTaskAttemptID taskAttemptID) throws IOException {
            if (TezTaskRunner2.this.isRunningState()) {
                return TezTaskRunner2.this.taskReporter.canCommit(taskAttemptID);
            }
            LOG.info("returning canCommit=false since task is not in a running state");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportError(Throwable t) {
            boolean isFirstError = false;
            TezTaskRunner2 tezTaskRunner2 = TezTaskRunner2.this;
            synchronized (tezTaskRunner2) {
                if (TezTaskRunner2.this.isRunningState()) {
                    LOG.info("TaskReporter reporter error which will cause the task to fail", t);
                    if (TezTaskRunner2.this.trySettingEndReason(EndReason.COMMUNICATION_FAILURE)) {
                        TezTaskRunner2.this.registerFirstException(t, null);
                        isFirstError = true;
                    } else {
                        TezTaskRunner2.this.logErrorIgnored("umbilicalFatalError", null);
                    }
                } else {
                    TezTaskRunner2.this.logErrorIgnored("umbilicalFatalError", null);
                }
            }
            if (isFirstError) {
                TezTaskRunner2.this.logAborting("umbilicalFatalError");
                TezTaskRunner2.this.killTaskInternal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownRequested() {
            boolean isFirstTerminate = false;
            TezTaskRunner2 tezTaskRunner2 = TezTaskRunner2.this;
            synchronized (tezTaskRunner2) {
                isFirstTerminate = TezTaskRunner2.this.trySettingEndReason(EndReason.CONTAINER_STOP_REQUESTED);
                TezTaskRunner2.this.stopContainerRequested.set(true);
            }
            if (isFirstTerminate) {
                TezTaskRunner2.this.logAborting("shutdownRequested");
                TezTaskRunner2.this.killTaskInternal();
            } else {
                TezTaskRunner2.this.logErrorIgnored("shutdownRequested", null);
            }
        }
    }
}

