/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import java.util.concurrent.TimeUnit;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReporter
extends CallableWithNdc<ContainerTask> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReporter.class);
    private final TezTaskUmbilicalProtocol umbilical;
    private final ContainerContext containerContext;
    private final int getTaskMaxSleepTime;
    private final long LOG_INTERVAL = 30000L;
    private long nextGetTaskPrintTime;

    ContainerReporter(TezTaskUmbilicalProtocol umbilical, ContainerContext containerContext, int getTaskMaxSleepTime) {
        this.umbilical = umbilical;
        this.containerContext = containerContext;
        this.getTaskMaxSleepTime = getTaskMaxSleepTime;
    }

    protected ContainerTask callInternal() throws Exception {
        ContainerTask containerTask = null;
        LOG.info("Attempting to fetch new task for container {}", (Object)this.containerContext.getContainerIdentifier());
        containerTask = this.umbilical.getTask(this.containerContext);
        long getTaskPollStartTime = System.currentTimeMillis();
        this.nextGetTaskPrintTime = getTaskPollStartTime + 30000L;
        int idle = 1;
        while (containerTask == null) {
            long sleepTimeMilliSecs = Math.min(idle * 10, this.getTaskMaxSleepTime);
            this.maybeLogSleepMessage(sleepTimeMilliSecs);
            TimeUnit.MILLISECONDS.sleep(sleepTimeMilliSecs);
            containerTask = this.umbilical.getTask(this.containerContext);
            ++idle;
        }
        LOG.info("Got TaskUpdate for containerId= " + this.containerContext.getContainerIdentifier() + ": " + (System.currentTimeMillis() - getTaskPollStartTime) + " ms after starting to poll." + " TaskInfo: shouldDie: " + containerTask.shouldDie() + (containerTask.shouldDie() ? "" : ", currentTaskAttemptId: " + containerTask.getTaskSpec().getTaskAttemptID()));
        return containerTask;
    }

    private void maybeLogSleepMessage(long sleepTimeMilliSecs) {
        long currentTime = System.currentTimeMillis();
        if (sleepTimeMilliSecs + currentTime > this.nextGetTaskPrintTime) {
            LOG.info("Sleeping for " + sleepTimeMilliSecs + "ms before retrying getTask again. Got null now. " + "Next getTask sleep message after " + 30000L + "ms");
            this.nextGetTaskPrintTime = currentTime + sleepTimeMilliSecs + 30000L;
        }
    }
}

