/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.api.Event;

public class TaskStatusUpdateEvent
extends Event
implements Writable {
    private TezCounters tezCounters;
    private float progress;

    public TaskStatusUpdateEvent() {
    }

    public TaskStatusUpdateEvent(TezCounters tezCounters, float progress) {
        this.tezCounters = tezCounters;
        this.progress = progress;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public float getProgress() {
        return this.progress;
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.progress);
        if (this.tezCounters != null) {
            out.writeBoolean(true);
            this.tezCounters.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.progress = in.readFloat();
        if (in.readBoolean()) {
            this.tezCounters = new TezCounters();
            this.tezCounters.readFields(in);
        }
    }
}

