/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.metrics.FileSystemStatisticUpdater;
import org.apache.tez.runtime.metrics.GcTimeUpdater;

public class TaskCounterUpdater {
    private static final Log LOG = LogFactory.getLog(TaskCounterUpdater.class);
    private final TezCounters tezCounters;
    private final Configuration conf;
    private long initialCpuCumulativeTime;
    private Map<String, FileSystemStatisticUpdater> statisticUpdaters = new HashMap<String, FileSystemStatisticUpdater>();
    protected GcTimeUpdater gcUpdater;
    private ResourceCalculatorProcessTree pTree;
    private long initCpuCumulativeTime = 0L;

    public TaskCounterUpdater(TezCounters counters, Configuration conf) {
        this.tezCounters = counters;
        this.conf = conf;
        this.gcUpdater = new GcTimeUpdater(this.tezCounters);
        this.initResourceCalculatorPlugin();
        this.recordInitialCpuStats();
    }

    public void updateCounters() {
        HashMap map = new HashMap();
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            List<FileSystem.Statistics> list;
            String uriScheme = statistics.getScheme();
            if (map.containsKey(uriScheme)) {
                list = (List)map.get(uriScheme);
                list.add(statistics);
                continue;
            }
            list = new ArrayList();
            list.add(statistics);
            map.put(uriScheme, list);
        }
        for (Map.Entry entry : map.entrySet()) {
            FileSystemStatisticUpdater updater = this.statisticUpdaters.get(entry.getKey());
            if (updater == null) {
                updater = new FileSystemStatisticUpdater(this.tezCounters, (List)entry.getValue(), (String)entry.getKey());
                this.statisticUpdaters.put((String)entry.getKey(), updater);
            }
            updater.updateCounters();
        }
        this.gcUpdater.incrementGcCounter();
        this.updateResourceCounters();
    }

    private void recordInitialCpuStats() {
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }

    void updateResourceCounters() {
        this.updateHeapUsageCounter();
        if (this.pTree == null) {
            return;
        }
        this.pTree.updateProcessTree();
        long cpuTime = this.pTree.getCumulativeCpuTime();
        long pMem = this.pTree.getCumulativeRssmem();
        long vMem = this.pTree.getCumulativeVmem();
        this.tezCounters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS).setValue((cpuTime -= this.initCpuCumulativeTime) - this.initCpuCumulativeTime);
        this.tezCounters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES).setValue(pMem);
        this.tezCounters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES).setValue(vMem);
    }

    private void updateHeapUsageCounter() {
        long currentHeapUsage = Runtime.getRuntime().totalMemory();
        this.tezCounters.findCounter((Enum)TaskCounter.COMMITTED_HEAP_BYTES).setValue(currentHeapUsage);
    }

    private void initResourceCalculatorPlugin() {
        Class clazz = this.conf.getClass("tez.resource.calculator.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.pTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)System.getenv().get("JVM_PID"), (Class)clazz, (Configuration)this.conf);
        LOG.info((Object)(" Using ResourceCalculatorProcessTree : " + this.pTree));
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }
}

