/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class EventMetaData
implements Writable {
    private EventProducerConsumerType producerConsumerType;
    private String taskVertexName;
    private String edgeVertexName;
    private int index;
    private TezTaskAttemptID taskAttemptID;

    public EventMetaData() {
    }

    public EventMetaData(EventProducerConsumerType generator, String taskVertexName, String edgeVertexName, TezTaskAttemptID taskAttemptID) {
        this.producerConsumerType = generator;
        this.taskVertexName = taskVertexName;
        this.edgeVertexName = edgeVertexName;
        this.taskAttemptID = taskAttemptID;
    }

    public EventProducerConsumerType getEventGenerator() {
        return this.producerConsumerType;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptID;
    }

    public String getTaskVertexName() {
        return this.taskVertexName;
    }

    public String getEdgeVertexName() {
        return this.edgeVertexName;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.producerConsumerType.ordinal());
        if (this.taskVertexName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.taskVertexName);
        } else {
            out.writeBoolean(false);
        }
        if (this.edgeVertexName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.edgeVertexName);
        } else {
            out.writeBoolean(false);
        }
        if (this.taskAttemptID != null) {
            out.writeBoolean(true);
            this.taskAttemptID.write(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.index);
    }

    public void readFields(DataInput in) throws IOException {
        this.producerConsumerType = EventProducerConsumerType.values()[in.readInt()];
        if (in.readBoolean()) {
            this.taskVertexName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.edgeVertexName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.taskAttemptID = new TezTaskAttemptID();
            this.taskAttemptID.readFields(in);
        }
        this.index = in.readInt();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return "{ producerConsumerType=" + (Object)((Object)this.producerConsumerType) + ", taskVertexName=" + this.taskVertexName + ", edgeVertexName=" + this.edgeVertexName + ", taskAttemptId=" + this.taskAttemptID + ", index=" + this.index + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventProducerConsumerType {
        INPUT,
        PROCESSOR,
        OUTPUT,
        SYSTEM;

    }
}

