/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezOutputContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.internals.api.TezTrapEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTrapEventHandler
implements EventHandler<TezTrapEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TezOutputContextImpl.class);
    private final OutputContext outputContext;
    private final TezUmbilical tezUmbilical;

    TezTrapEventHandler(OutputContext output, TezUmbilical umbilical) {
        this.outputContext = output;
        this.tezUmbilical = umbilical;
    }

    public final void handle(TezTrapEvent tezTrapEvent) {
        Preconditions.checkArgument((tezTrapEvent.getTezEvents() != null ? 1 : 0) != 0);
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(tezTrapEvent.getTezEvents().size());
        block3: for (TezEvent tezEvent : tezTrapEvent.getTezEvents()) {
            switch (tezEvent.getEventType()) {
                case COMPOSITE_DATA_MOVEMENT_EVENT: 
                case DATA_MOVEMENT_EVENT: {
                    String errorMsg = "Some events won't be sent to the AM because all the events should have been sent at this point. Most likely this would result in a bug.  event:" + tezEvent.toString();
                    Throwable throwable = new Throwable(errorMsg);
                    LOG.error(errorMsg, throwable);
                    continue block3;
                }
            }
            LOG.info("Event of type " + (Object)((Object)tezEvent.getEventType()) + " will be sent to the AM after the task was closed ");
            tezEvents.add(tezEvent);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }
}

