/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner2Callable
extends CallableWithNdc<TaskRunner2CallableResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunner2Callable.class);
    private final LogicalIOProcessorRuntimeTask task;
    private final UserGroupInformation ugi;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final AtomicBoolean interruptAttempted = new AtomicBoolean(false);
    private volatile Thread ownThread;

    public TaskRunner2Callable(LogicalIOProcessorRuntimeTask task, UserGroupInformation ugi) {
        this.task = task;
        this.ugi = ugi;
    }

    public TaskRunner2CallableResult callInternal() throws Exception {
        this.ownThread = Thread.currentThread();
        if (this.stopRequested.get()) {
            return new TaskRunner2CallableResult(null);
        }
        try {
            TaskRunner2CallableResult taskRunner2CallableResult = (TaskRunner2CallableResult)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TaskRunner2CallableResult>(){

                @Override
                public TaskRunner2CallableResult run() throws Exception {
                    if (TaskRunner2Callable.this.stopRequested.get() || Thread.currentThread().isInterrupted()) {
                        return new TaskRunner2CallableResult(null);
                    }
                    LOG.info("Initializing task, taskAttemptId={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID());
                    TezUtilsInternal.setHadoopCallerContext((HadoopShim)TaskRunner2Callable.this.task.getHadoopShim(), (TezTaskAttemptID)TaskRunner2Callable.this.task.getTaskAttemptID());
                    TezCommonUtils.logCredentials((Logger)LOG, (Credentials)TaskRunner2Callable.this.ugi.getCredentials(), (String)"taskInit");
                    TaskRunner2Callable.this.task.initialize();
                    if (TaskRunner2Callable.this.stopRequested.get() || Thread.currentThread().isInterrupted()) {
                        LOG.info("Stopped before running the processor taskAttemptId={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID());
                        TaskRunner2Callable.this.task.setFrameworkCounters();
                        return new TaskRunner2CallableResult(null);
                    }
                    LOG.info("Running task, taskAttemptId={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID());
                    TaskRunner2Callable.this.task.run();
                    if (TaskRunner2Callable.this.stopRequested.get() || Thread.currentThread().isInterrupted()) {
                        LOG.info("Stopped before closing the processor, taskAttemptId={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID());
                        TaskRunner2Callable.this.task.setFrameworkCounters();
                        return new TaskRunner2CallableResult(null);
                    }
                    LOG.info("Closing task, taskAttemptId={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID());
                    TaskRunner2Callable.this.task.close();
                    TaskRunner2Callable.this.task.setFrameworkCounters();
                    LOG.info("Task completed, taskAttemptId={}, askedToStop={}", (Object)TaskRunner2Callable.this.task.getTaskAttemptID(), (Object)TaskRunner2Callable.this.stopRequested.get());
                    return new TaskRunner2CallableResult(null);
                }
            });
            return taskRunner2CallableResult;
        }
        catch (Throwable t) {
            if (t instanceof UndeclaredThrowableException) {
                t = t.getCause();
            }
            this.task.setFrameworkCounters();
            TaskRunner2CallableResult taskRunner2CallableResult = new TaskRunner2CallableResult(t);
            return taskRunner2CallableResult;
        }
        finally {
            this.maybeFixInterruptStatus();
            LOG.info("Cleaning up task {}, stopRequested={}", (Object)this.task.getTaskAttemptID(), (Object)this.stopRequested.get());
            this.task.cleanup();
        }
    }

    private void maybeFixInterruptStatus() {
        if (this.stopRequested.get() && !Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
        }
    }

    public void abortTask() {
        if (!this.stopRequested.getAndSet(true)) {
            this.task.abortTask();
        }
    }

    public void interruptTask() {
        if (!this.interruptAttempted.getAndSet(true)) {
            LogicalIOProcessorRuntimeTask localTask = this.task;
            if (this.ownThread != null && localTask != null && !localTask.isTaskDone()) {
                this.ownThread.interrupt();
            }
        }
    }

    public TezCounters addAndGetTezCounter(String name) {
        return this.task.addAndGetTezCounter(name);
    }

    public static class TaskRunner2CallableResult {
        final Throwable error;

        public TaskRunner2CallableResult(Throwable error) {
            this.error = error;
        }
    }
}

