/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class TezMxBeanResourceCalculator
extends ResourceCalculatorProcessTree {
    private final OperatingSystemMXBean osBean;
    private final Runtime runtime = Runtime.getRuntime();

    public TezMxBeanResourceCalculator(String root) {
        super(root);
        this.osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public void updateProcessTree() {
    }

    public String getProcessTreeDump() {
        return "";
    }

    public long getCumulativeVmem(int olderThanAge) {
        return this.osBean.getCommittedVirtualMemorySize();
    }

    public long getCumulativeRssmem(int olderThanAge) {
        return this.runtime.totalMemory();
    }

    public long getCumulativeCpuTime() {
        return TimeUnit.MILLISECONDS.convert(this.osBean.getProcessCpuTime(), TimeUnit.NANOSECONDS);
    }

    public boolean checkPidPgrpidForMatch() {
        return true;
    }
}

