/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.tez.common.TezTaskStatus;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class MRTaskStatus
implements TezTaskStatus {
    static final Log LOG = LogFactory.getLog((String)TaskStatus.class.getName());
    static final int MAX_STRING_SIZE = 1024;
    private TezTaskAttemptID taskAttemptId;
    private TezTaskStatus.State state = TezTaskStatus.State.UNASSIGNED;
    private float progress = 0.0f;
    private String diagnostics = "";
    private String userStatusInfo = "";
    private TezTaskStatus.Phase phase;
    private TezCounters counters;
    private long localOutputSize;
    List<TezTaskAttemptID> failedTaskDependencies = new ArrayList<TezTaskAttemptID>();
    private long startTime;
    private long finishTime;
    private long sortFinishTime;
    private long mapFinishTime;
    private long shuffleFinishTime;

    public MRTaskStatus() {
    }

    public MRTaskStatus(TezTaskAttemptID taskAttemptId, TezCounters counters, TezTaskStatus.Phase phase) {
        this.taskAttemptId = taskAttemptId;
        this.counters = counters;
        this.phase = phase;
    }

    @Override
    public TezTaskAttemptID getTaskAttemptId() {
        return this.taskAttemptId;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public TezTaskStatus.State getRunState() {
        return this.state;
    }

    @Override
    public void setRunState(TezTaskStatus.State state) {
        this.state = state;
    }

    @Override
    public String getDiagnosticInfo() {
        return this.diagnostics;
    }

    @Override
    public void setDiagnosticInfo(String info) {
        this.diagnostics = info;
    }

    @Override
    public String getStateString() {
        return this.userStatusInfo;
    }

    @Override
    public void setStateString(String userStatusInfo) {
        this.userStatusInfo = userStatusInfo;
    }

    @Override
    public long getFinishTime() {
        return this.finishTime;
    }

    @Override
    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    @Override
    public long getMapFinishTime() {
        return this.mapFinishTime;
    }

    @Override
    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public TezTaskStatus.Phase getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(TezTaskStatus.Phase phase) {
        TezTaskStatus.Phase oldPhase = this.getPhase();
        if (oldPhase != phase) {
            if (phase == TezTaskStatus.Phase.SORT) {
                if (oldPhase == TezTaskStatus.Phase.MAP) {
                    this.setMapFinishTime(System.currentTimeMillis());
                } else {
                    this.setShuffleFinishTime(System.currentTimeMillis());
                }
            } else if (phase == TezTaskStatus.Phase.REDUCE) {
                this.setSortFinishTime(System.currentTimeMillis());
            }
            this.phase = phase;
        }
    }

    @Override
    public TezCounters getCounters() {
        return this.counters;
    }

    @Override
    public void setCounters(TezCounters counters) {
        this.counters = counters;
    }

    @Override
    public long getLocalOutputSize() {
        return this.localOutputSize;
    }

    @Override
    public List<TezTaskAttemptID> getFailedDependencies() {
        return this.failedTaskDependencies;
    }

    @Override
    public void addFailedDependency(TezTaskAttemptID taskAttemptId) {
        this.failedTaskDependencies.add(taskAttemptId);
    }

    @Override
    public synchronized void clearStatus() {
        this.userStatusInfo = "";
        this.failedTaskDependencies.clear();
    }

    @Override
    public synchronized void statusUpdate(float progress, String userDiagnosticInfo, TezCounters counters) {
        this.setProgress(progress);
        this.setDiagnosticInfo(userDiagnosticInfo);
        this.setCounters(counters);
    }

    @Override
    public void setOutputSize(long localOutputSize) {
        this.localOutputSize = localOutputSize;
    }

    @Override
    public void setFinishTime(long finishTime) {
        if (this.getStartTime() > 0L && finishTime > 0L) {
            if (this.getShuffleFinishTime() == 0L) {
                this.setShuffleFinishTime(finishTime);
            }
            if (this.getSortFinishTime() == 0L) {
                this.setSortFinishTime(finishTime);
            }
            if (this.getMapFinishTime() == 0L) {
                this.setMapFinishTime(finishTime);
            }
            this.finishTime = finishTime;
        }
    }

    @Override
    public void setShuffleFinishTime(long shuffleFinishTime) {
        this.shuffleFinishTime = shuffleFinishTime;
    }

    @Override
    public void setMapFinishTime(long mapFinishTime) {
        this.mapFinishTime = mapFinishTime;
    }

    @Override
    public void setSortFinishTime(long sortFinishTime) {
        this.sortFinishTime = sortFinishTime;
        if (this.getShuffleFinishTime() == this.shuffleFinishTime) {
            this.setShuffleFinishTime(sortFinishTime);
        }
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void write(DataOutput out) throws IOException {
        this.taskAttemptId.write(out);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.state);
        out.writeFloat(this.progress);
        WritableUtils.writeString((DataOutput)out, (String)this.diagnostics);
        WritableUtils.writeString((DataOutput)out, (String)this.userStatusInfo);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.phase);
        this.counters.write(out);
        out.writeLong(this.localOutputSize);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        out.writeLong(this.sortFinishTime);
        out.writeLong(this.mapFinishTime);
        out.writeLong(this.shuffleFinishTime);
        out.writeInt(this.failedTaskDependencies.size());
        for (TezTaskAttemptID taskAttemptId : this.failedTaskDependencies) {
            taskAttemptId.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.taskAttemptId = TezTaskAttemptID.readTezTaskAttemptID((DataInput)in);
        this.state = (TezTaskStatus.State)WritableUtils.readEnum((DataInput)in, TezTaskStatus.State.class);
        this.progress = in.readFloat();
        this.diagnostics = WritableUtils.readString((DataInput)in);
        this.userStatusInfo = WritableUtils.readString((DataInput)in);
        this.phase = (TezTaskStatus.Phase)WritableUtils.readEnum((DataInput)in, TezTaskStatus.Phase.class);
        this.counters = new TezCounters();
        this.counters.readFields(in);
        this.localOutputSize = in.readLong();
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        this.sortFinishTime = in.readLong();
        this.mapFinishTime = in.readLong();
        this.shuffleFinishTime = in.readLong();
        int numFailedDependencies = in.readInt();
        for (int i = 0; i < numFailedDependencies; ++i) {
            TezTaskAttemptID taskAttemptId = TezTaskAttemptID.readTezTaskAttemptID((DataInput)in);
            this.failedTaskDependencies.add(taskAttemptId);
        }
    }
}

