/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.common.Utils;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class MROutput
implements LogicalOutput {
    private static final Log LOG = LogFactory.getLog(MROutput.class);
    private final NumberFormat taskNumberFormat = NumberFormat.getInstance();
    private final NumberFormat nonTaskNumberFormat = NumberFormat.getInstance();
    private TezOutputContext outputContext;
    private JobConf jobConf;
    boolean useNewApi;
    private AtomicBoolean closed = new AtomicBoolean(false);
    OutputFormat newOutputFormat;
    org.apache.hadoop.mapreduce.RecordWriter newRecordWriter;
    org.apache.hadoop.mapred.OutputFormat oldOutputFormat;
    RecordWriter oldRecordWriter;
    private TezCounter outputRecordCounter;
    private TezCounter fileOutputByteCounter;
    private List<FileSystem.Statistics> fsStats;
    private TaskAttemptContext newApiTaskAttemptContext;
    private org.apache.hadoop.mapred.TaskAttemptContext oldApiTaskAttemptContext;
    private boolean isMapperOutput;
    protected OutputCommitter committer;

    public List<Event> initialize(TezOutputContext outputContext) throws IOException, InterruptedException {
        LOG.info((Object)"Initializing Simple Output");
        outputContext.requestInitialMemory(0L, null);
        this.taskNumberFormat.setMinimumIntegerDigits(5);
        this.taskNumberFormat.setGroupingUsed(false);
        this.nonTaskNumberFormat.setMinimumIntegerDigits(3);
        this.nonTaskNumberFormat.setGroupingUsed(false);
        this.outputContext = outputContext;
        Configuration conf = TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload());
        this.jobConf = new JobConf(conf);
        this.useNewApi = this.jobConf.getUseNewMapper();
        this.isMapperOutput = this.jobConf.getBoolean("tez.mapreduce.is_map_processor", false);
        this.jobConf.setInt("mapreduce.job.application.attempt.id", outputContext.getDAGAttemptNumber());
        org.apache.hadoop.mapred.TaskAttemptID taskAttemptId = TaskAttemptContextImpl.createMockTaskAttemptID((TezTaskContext)outputContext, this.isMapperOutput);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        this.jobConf.setBoolean("mapreduce.task.ismap", this.isMapperOutput);
        this.jobConf.setInt("mapreduce.task.partition", taskAttemptId.getTaskID().getId());
        this.jobConf.set("mapreduce.job.id", taskAttemptId.getJobID().toString());
        if (this.useNewApi && this.jobConf.get("mapreduce.output.basename") == null) {
            this.jobConf.set("mapreduce.output.basename", this.getOutputFileNamePrefix());
        }
        this.outputRecordCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.fileOutputByteCounter = outputContext.getCounters().findCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN);
        if (this.useNewApi) {
            this.newApiTaskAttemptContext = this.createTaskAttemptContext(taskAttemptId);
            try {
                this.newOutputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)this.newApiTaskAttemptContext.getOutputFormatClass(), (Configuration)this.jobConf);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            List<FileSystem.Statistics> matchedStats = null;
            if (this.newOutputFormat instanceof FileOutputFormat) {
                matchedStats = Utils.getFsStatistics(FileOutputFormat.getOutputPath((JobContext)this.newApiTaskAttemptContext), (Configuration)this.jobConf);
            }
            this.fsStats = matchedStats;
            long bytesOutPrev = this.getOutputBytes();
            try {
                this.newRecordWriter = this.newOutputFormat.getRecordWriter(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while creating record writer", e);
            }
            long bytesOutCurr = this.getOutputBytes();
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        } else {
            this.oldApiTaskAttemptContext = new org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl(this.jobConf, taskAttemptId, new MRTaskReporter(outputContext));
            this.oldOutputFormat = this.jobConf.getOutputFormat();
            List<FileSystem.Statistics> matchedStats = null;
            if (this.oldOutputFormat instanceof org.apache.hadoop.mapred.FileOutputFormat) {
                matchedStats = Utils.getFsStatistics(org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)this.jobConf), (Configuration)this.jobConf);
            }
            this.fsStats = matchedStats;
            FileSystem fs = FileSystem.get((Configuration)this.jobConf);
            String finalName = this.getOutputName();
            long bytesOutPrev = this.getOutputBytes();
            this.oldRecordWriter = this.oldOutputFormat.getRecordWriter(fs, this.jobConf, finalName, (Progressable)new MRReporter((TezTaskContext)outputContext));
            long bytesOutCurr = this.getOutputBytes();
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }
        this.initCommitter(this.jobConf, this.useNewApi);
        LOG.info((Object)("Initialized Simple Output, using_new_api: " + this.useNewApi));
        return null;
    }

    public void start() {
    }

    public void initCommitter(JobConf job, boolean useNewApi) throws IOException, InterruptedException {
        if (useNewApi) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"using new api for output committer");
            }
            OutputFormat outputFormat = null;
            try {
                outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)this.newApiTaskAttemptContext.getOutputFormatClass(), (Configuration)job);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown OutputFormat", cnfe);
            }
            this.committer = outputFormat.getOutputCommitter(this.newApiTaskAttemptContext);
        } else {
            this.committer = job.getOutputCommitter();
        }
        Path outputPath = org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)job);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)((FileOutputCommitter)this.committer).getTaskAttemptPath(this.oldApiTaskAttemptContext));
            } else {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)outputPath);
            }
        }
        if (useNewApi) {
            this.committer.setupTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.setupTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public boolean isCommitRequired() throws IOException {
        if (this.useNewApi) {
            return this.committer.needsTaskCommit(this.newApiTaskAttemptContext);
        }
        return this.committer.needsTaskCommit((TaskAttemptContext)this.oldApiTaskAttemptContext);
    }

    private TaskAttemptContext createTaskAttemptContext(org.apache.hadoop.mapred.TaskAttemptID attemptId) {
        return new TaskAttemptContextImpl((Configuration)this.jobConf, (TaskAttemptID)attemptId, (TezTaskContext)this.outputContext, this.isMapperOutput, null);
    }

    private long getOutputBytes() {
        if (this.fsStats == null) {
            return 0L;
        }
        long bytesWritten = 0L;
        for (FileSystem.Statistics stat : this.fsStats) {
            bytesWritten += stat.getBytesWritten();
        }
        return bytesWritten;
    }

    private String getOutputFileNamePrefix() {
        String prefix = this.jobConf.get("mapreduce.tez.mroutput.file-name.prefix");
        if (prefix == null) {
            prefix = "part-v" + this.nonTaskNumberFormat.format(this.outputContext.getTaskVertexIndex()) + "-o" + this.nonTaskNumberFormat.format(this.outputContext.getOutputIndex());
        }
        return prefix;
    }

    private String getOutputName() {
        return this.getOutputFileNamePrefix() + "-" + this.taskNumberFormat.format(this.outputContext.getTaskIndex());
    }

    public KeyValueWriter getWriter() throws IOException {
        return new KeyValueWriter(){
            private final boolean useNewWriter;
            {
                this.useNewWriter = MROutput.this.useNewApi;
            }

            public void write(Object key, Object value) throws IOException {
                long bytesOutPrev = MROutput.this.getOutputBytes();
                if (this.useNewWriter) {
                    try {
                        MROutput.this.newRecordWriter.write(key, value);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Interrupted while writing next key-value", e);
                    }
                } else {
                    MROutput.this.oldRecordWriter.write(key, value);
                }
                long bytesOutCurr = MROutput.this.getOutputBytes();
                MROutput.this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
                MROutput.this.outputRecordCounter.increment(1L);
            }
        };
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return null;
        }
        LOG.info((Object)"Closing Simple Output");
        long bytesOutPrev = this.getOutputBytes();
        if (this.useNewApi) {
            try {
                this.newRecordWriter.close(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing record writer", e);
            }
        } else {
            this.oldRecordWriter.close(null);
        }
        long bytesOutCurr = this.getOutputBytes();
        this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        LOG.info((Object)"Closed Simple Output");
        return null;
    }

    public void setNumPhysicalOutputs(int numOutputs) {
    }

    public void commit() throws IOException {
        this.close();
        if (this.useNewApi) {
            this.committer.commitTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.commitTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public void abort() throws IOException {
        this.close();
        if (this.useNewApi) {
            this.committer.abortTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.abortTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }
}

