/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor.map;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.mapreduce.hadoop.mapreduce.MapContextImpl;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.MRTask;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.output.OnFileSortedOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProcessor
extends MRTask
implements LogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(MapProcessor.class);

    public MapProcessor() {
        super(true);
    }

    @Override
    public void initialize(TezProcessorContext processorContext) throws IOException {
        try {
            super.initialize(processorContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws IOException {
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        LOG.info((Object)("Running map: " + this.processorContext.getUniqueIdentifier()));
        this.initTask();
        if (inputs.size() != 1 || outputs.size() != 1) {
            throw new IOException("Cannot handle multiple inputs or outputs, inputCount=" + inputs.size() + ", outputCount=" + outputs.size());
        }
        LogicalInput in = inputs.values().iterator().next();
        LogicalOutput out = outputs.values().iterator().next();
        if (!(in instanceof MRInputLegacy)) {
            throw new IOException(new TezException("Only Simple Input supported. Input: " + in.getClass()));
        }
        MRInputLegacy input = (MRInputLegacy)in;
        input.init();
        Configuration incrementalConf = input.getConfigUpdates();
        if (incrementalConf != null) {
            for (Map.Entry entry : incrementalConf) {
                this.jobConf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        KeyValueWriter kvWriter = null;
        kvWriter = !(out instanceof OnFileSortedOutput) ? ((MROutput)out).getWriter() : ((OnFileSortedOutput)out).getWriter();
        if (this.useNewApi) {
            this.runNewMapper(this.jobConf, this.mrReporter, input, kvWriter);
        } else {
            this.runOldMapper(this.jobConf, this.mrReporter, input, kvWriter);
        }
        this.done(out);
    }

    void runOldMapper(JobConf job, MRTaskReporter reporter, MRInputLegacy input, KeyValueWriter output) throws IOException, InterruptedException {
        OldRecordReader in = new OldRecordReader(input);
        OldOutputCollector collector = new OldOutputCollector(output);
        MapRunnable runner = (MapRunnable)ReflectionUtils.newInstance((Class)job.getMapRunnerClass(), (Configuration)job);
        runner.run((org.apache.hadoop.mapred.RecordReader)in, (OutputCollector)collector, (Reporter)reporter);
        this.statusUpdate();
    }

    private void runNewMapper(JobConf job, MRTaskReporter reporter, MRInputLegacy in, KeyValueWriter out) throws IOException, InterruptedException {
        Mapper mapper;
        TaskAttemptContext taskContext = this.getTaskAttemptContext();
        try {
            mapper = (Mapper)ReflectionUtils.newInstance((Class)taskContext.getMapperClass(), (Configuration)job);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        NewRecordReader input = new NewRecordReader(in);
        NewOutputCollector output = new NewOutputCollector(out);
        InputSplit split = in.getNewInputSplit();
        MapContextImpl mapContext = new MapContextImpl((Configuration)job, (TaskAttemptID)this.taskAttemptId, input, output, this.getCommitter(), (TezTaskContext)this.processorContext, split);
        Mapper.Context mapperContext = new WrappedMapper().getMapContext(mapContext);
        input.initialize(split, (TaskAttemptContext)mapperContext);
        mapper.run(mapperContext);
        this.statusUpdate();
        input.close();
        output.close((TaskAttemptContext)mapperContext);
    }

    @Override
    public void localizeConfiguration(JobConf jobConf) throws IOException, InterruptedException {
        super.localizeConfiguration(jobConf);
        jobConf.setBoolean("mapreduce.task.ismap", true);
    }

    @Override
    public TezCounter getOutputRecordsCounter() {
        return this.processorContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
    }

    @Override
    public TezCounter getInputRecordsCounter() {
        return this.processorContext.getCounters().findCounter((Enum)TaskCounter.MAP_INPUT_RECORDS);
    }

    private class NewOutputCollector
    extends RecordWriter {
        private final KeyValueWriter out;

        NewOutputCollector(KeyValueWriter out) throws IOException {
            this.out = out;
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            this.out.write(key, value);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }
    }

    private static class OldOutputCollector
    implements OutputCollector {
        private final KeyValueWriter output;

        OldOutputCollector(KeyValueWriter output) {
            this.output = output;
        }

        public void collect(Object key, Object value) throws IOException {
            this.output.write(key, value);
        }
    }

    private static class OldRecordReader
    implements org.apache.hadoop.mapred.RecordReader {
        private final MRInputLegacy mrInput;

        private OldRecordReader(MRInputLegacy mrInput) {
            this.mrInput = mrInput;
        }

        public boolean next(Object key, Object value) throws IOException {
            return this.mrInput.getOldRecordReader().next(key, value);
        }

        public Object createKey() {
            return this.mrInput.getOldRecordReader().createKey();
        }

        public Object createValue() {
            return this.mrInput.getOldRecordReader().createValue();
        }

        public long getPos() throws IOException {
            return this.mrInput.getOldRecordReader().getPos();
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            try {
                return this.mrInput.getProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
    }

    private static class NewRecordReader
    extends RecordReader {
        private final MRInput in;
        private KeyValueReader reader;

        private NewRecordReader(MRInput in) throws IOException {
            this.in = in;
            this.reader = in.getReader();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.next();
        }

        public Object getCurrentKey() throws IOException, InterruptedException {
            return this.reader.getCurrentKey();
        }

        public Object getCurrentValue() throws IOException, InterruptedException {
            return this.reader.getCurrentValue();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.in.getProgress();
        }

        public void close() throws IOException {
        }
    }
}

