/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

class GcTimeUpdater {
    private long lastGcMillis = 0L;
    private List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    TezCounters counters;

    public GcTimeUpdater(TezCounters counters) {
        this.getElapsedGc();
        this.counters = counters;
    }

    protected long getElapsedGc() {
        long thisGcMillis = 0L;
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            thisGcMillis += gcBean.getCollectionTime();
        }
        long delta = thisGcMillis - this.lastGcMillis;
        this.lastGcMillis = thisGcMillis;
        return delta;
    }

    public void incrementGcCounter() {
        if (null == this.counters) {
            return;
        }
        TezCounter gcCounter = this.counters.findCounter((Enum)TaskCounter.GC_TIME_MILLIS);
        if (null != gcCounter) {
            gcCounter.increment(this.getElapsedGc());
        }
    }
}

