/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.common.Utils;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MROutput
implements LogicalOutput {
    private static final Log LOG = LogFactory.getLog(MROutput.class);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private TezOutputContext outputContext;
    private JobConf jobConf;
    boolean useNewApi;
    private AtomicBoolean closed = new AtomicBoolean(false);
    org.apache.hadoop.mapreduce.OutputFormat newOutputFormat;
    RecordWriter newRecordWriter;
    OutputFormat oldOutputFormat;
    org.apache.hadoop.mapred.RecordWriter oldRecordWriter;
    private TezCounter outputRecordCounter;
    private TezCounter fileOutputByteCounter;
    private List<FileSystem.Statistics> fsStats;
    private TaskAttemptContext newApiTaskAttemptContext;
    private org.apache.hadoop.mapred.TaskAttemptContext oldApiTaskAttemptContext;
    private boolean isMapperOutput;
    private OutputCommitter committer;

    public List<Event> initialize(TezOutputContext outputContext) throws IOException, InterruptedException {
        LOG.info((Object)"Initializing Simple Output");
        this.outputContext = outputContext;
        Configuration conf = TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload());
        this.jobConf = new JobConf(conf);
        this.useNewApi = this.jobConf.getUseNewMapper();
        this.isMapperOutput = this.jobConf.getBoolean("tez.mapreduce.is_map_processor", false);
        this.jobConf.setInt("mapreduce.job.application.attempt.id", outputContext.getDAGAttemptNumber());
        TaskAttemptID taskAttemptId = new TaskAttemptID(new TaskID(Long.toString(outputContext.getApplicationId().getClusterTimestamp()), outputContext.getApplicationId().getId(), this.isMapperOutput ? TaskType.MAP : TaskType.REDUCE, outputContext.getTaskIndex()), outputContext.getTaskAttemptNumber());
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        this.jobConf.setBoolean("mapreduce.task.ismap", this.isMapperOutput);
        this.jobConf.setInt("mapreduce.task.partition", taskAttemptId.getTaskID().getId());
        this.jobConf.set("mapreduce.job.id", taskAttemptId.getJobID().toString());
        this.outputRecordCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.fileOutputByteCounter = outputContext.getCounters().findCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN);
        if (this.useNewApi) {
            this.newApiTaskAttemptContext = this.createTaskAttemptContext();
            try {
                this.newOutputFormat = (org.apache.hadoop.mapreduce.OutputFormat)ReflectionUtils.newInstance((Class)this.newApiTaskAttemptContext.getOutputFormatClass(), (Configuration)this.jobConf);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            List<FileSystem.Statistics> matchedStats = null;
            if (this.newOutputFormat instanceof FileOutputFormat) {
                matchedStats = Utils.getFsStatistics(FileOutputFormat.getOutputPath((JobContext)this.newApiTaskAttemptContext), (Configuration)this.jobConf);
            }
            this.fsStats = matchedStats;
            long bytesOutPrev = this.getOutputBytes();
            try {
                this.newRecordWriter = this.newOutputFormat.getRecordWriter(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while creating record writer", e);
            }
            long bytesOutCurr = this.getOutputBytes();
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        } else {
            this.oldApiTaskAttemptContext = new org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl(this.jobConf, taskAttemptId, new MRTaskReporter(outputContext));
            this.oldOutputFormat = this.jobConf.getOutputFormat();
            List<FileSystem.Statistics> matchedStats = null;
            if (this.oldOutputFormat instanceof org.apache.hadoop.mapred.FileOutputFormat) {
                matchedStats = Utils.getFsStatistics(org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)this.jobConf), (Configuration)this.jobConf);
            }
            this.fsStats = matchedStats;
            FileSystem fs = FileSystem.get((Configuration)this.jobConf);
            String finalName = this.getOutputName();
            long bytesOutPrev = this.getOutputBytes();
            this.oldRecordWriter = this.oldOutputFormat.getRecordWriter(fs, this.jobConf, finalName, (Progressable)new MRReporter((TezTaskContext)outputContext));
            long bytesOutCurr = this.getOutputBytes();
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }
        this.initCommitter(this.jobConf, this.useNewApi);
        LOG.info((Object)("Initialized Simple Output, using_new_api: " + this.useNewApi));
        return null;
    }

    public void initCommitter(JobConf job, boolean useNewApi) throws IOException, InterruptedException {
        if (useNewApi) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"using new api for output committer");
            }
            org.apache.hadoop.mapreduce.OutputFormat outputFormat = null;
            try {
                outputFormat = (org.apache.hadoop.mapreduce.OutputFormat)ReflectionUtils.newInstance((Class)this.newApiTaskAttemptContext.getOutputFormatClass(), (Configuration)job);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown OutputFormat", cnfe);
            }
            this.committer = outputFormat.getOutputCommitter(this.newApiTaskAttemptContext);
        } else {
            this.committer = job.getOutputCommitter();
        }
        Path outputPath = org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)job);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)((FileOutputCommitter)this.committer).getTaskAttemptPath(this.oldApiTaskAttemptContext));
            } else {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)outputPath);
            }
        }
        if (useNewApi) {
            this.committer.setupTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.setupTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public boolean isCommitRequired() throws IOException {
        if (this.useNewApi) {
            return this.committer.needsTaskCommit(this.newApiTaskAttemptContext);
        }
        return this.committer.needsTaskCommit((TaskAttemptContext)this.oldApiTaskAttemptContext);
    }

    private TaskAttemptContext createTaskAttemptContext() {
        return new TaskAttemptContextImpl((Configuration)this.jobConf, (TezTaskContext)this.outputContext, this.isMapperOutput);
    }

    private long getOutputBytes() {
        if (this.fsStats == null) {
            return 0L;
        }
        long bytesWritten = 0L;
        for (FileSystem.Statistics stat : this.fsStats) {
            bytesWritten += stat.getBytesWritten();
        }
        return bytesWritten;
    }

    private String getOutputName() {
        return "part-" + NUMBER_FORMAT.format(this.outputContext.getTaskIndex());
    }

    public KeyValueWriter getWriter() throws IOException {
        return new KeyValueWriter(){
            private final boolean useNewWriter;
            {
                this.useNewWriter = MROutput.this.useNewApi;
            }

            public void write(Object key, Object value) throws IOException {
                long bytesOutPrev = MROutput.this.getOutputBytes();
                if (this.useNewWriter) {
                    try {
                        MROutput.this.newRecordWriter.write(key, value);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Interrupted while writing next key-value", e);
                    }
                } else {
                    MROutput.this.oldRecordWriter.write(key, value);
                }
                long bytesOutCurr = MROutput.this.getOutputBytes();
                MROutput.this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
                MROutput.this.outputRecordCounter.increment(1L);
            }
        };
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return null;
        }
        LOG.info((Object)"Closing Simple Output");
        long bytesOutPrev = this.getOutputBytes();
        if (this.useNewApi) {
            try {
                this.newRecordWriter.close(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing record writer", e);
            }
        } else {
            this.oldRecordWriter.close(null);
        }
        long bytesOutCurr = this.getOutputBytes();
        this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        LOG.info((Object)"Closed Simple Output");
        return null;
    }

    public void setNumPhysicalOutputs(int numOutputs) {
    }

    public void commit() throws IOException {
        this.close();
        if (this.useNewApi) {
            this.committer.commitTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.commitTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public void abort() throws IOException {
        this.close();
        if (this.useNewApi) {
            this.committer.abortTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.abortTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

