/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapreduce;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.tez.mapreduce.common.Utils;
import org.apache.tez.runtime.api.TezTaskContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptContextImpl
extends org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl {
    private TezTaskContext taskContext;

    public TaskAttemptContextImpl(Configuration conf, TezTaskContext taskContext, boolean isMap) {
        this(conf, new TaskAttemptID(new TaskID(String.valueOf(taskContext.getApplicationId().getClusterTimestamp()), taskContext.getApplicationId().getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskContext.getTaskIndex()), taskContext.getTaskAttemptNumber()), taskContext);
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taId, TezTaskContext context) {
        super(conf, taId);
        this.taskContext = context;
    }

    public float getProgress() {
        return 0.0f;
    }

    public Counter getCounter(Enum<?> counterName) {
        return Utils.getMRCounter(this.taskContext.getCounters().findCounter(counterName));
    }

    public Counter getCounter(String groupName, String counterName) {
        return Utils.getMRCounter(this.taskContext.getCounters().findCounter(groupName, counterName));
    }

    public void progress() {
    }

    public void setStatus(String status) {
        this.setStatusString(status);
    }
}

