/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

public class IDConverter {
    public static JobID toMRJobId(TezDAGID dagId) {
        return new JobID(Long.toString(dagId.getApplicationId().getClusterTimestamp()), dagId.getApplicationId().getId());
    }

    public static TaskID toMRTaskId(TezTaskID taskid) {
        return new TaskID((org.apache.hadoop.mapreduce.JobID)IDConverter.toMRJobId(taskid.getVertexID().getDAGId()), taskid.getVertexID().getId() == 0 ? TaskType.MAP : TaskType.REDUCE, taskid.getId());
    }

    public static org.apache.hadoop.mapred.TaskAttemptID toMRTaskAttemptId(TezTaskAttemptID taskAttemptId) {
        return new org.apache.hadoop.mapred.TaskAttemptID(IDConverter.toMRTaskId(taskAttemptId.getTaskID()), taskAttemptId.getId());
    }

    public static TezDAGID fromMRJobId(org.apache.hadoop.mapreduce.JobID jobId) {
        return new TezDAGID(ApplicationId.newInstance((long)Long.valueOf(jobId.getJtIdentifier()), (int)jobId.getId()), 1);
    }

    public static TezTaskID fromMRTaskId(org.apache.hadoop.mapreduce.TaskID taskid) {
        return new TezTaskID(new TezVertexID(IDConverter.fromMRJobId(taskid.getJobID()), taskid.getTaskType() == TaskType.MAP ? 0 : 1), taskid.getId());
    }

    public static TezTaskAttemptID fromMRTaskAttemptId(TaskAttemptID taskAttemptId) {
        return new TezTaskAttemptID(IDConverter.fromMRTaskId(taskAttemptId.getTaskID()), taskAttemptId.getId());
    }
}

