/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ResourceMgrDelegate {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private YarnConfiguration conf;
    private GetNewApplicationResponse application;
    private ApplicationId applicationId;
    private YarnClient client;
    private InetSocketAddress rmAddress;

    public ResourceMgrDelegate(YarnConfiguration conf) {
        this.conf = conf;
        this.client = YarnClient.createYarnClient();
        this.client.init((Configuration)conf);
        this.rmAddress = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        this.client.start();
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnNodes((List)this.client.getNodeReports(new NodeState[0]));
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        try {
            HashSet<String> appTypes = new HashSet<String>(1);
            appTypes.add("TEZ");
            return TypeConverter.fromYarnApps((List)this.client.getApplications(appTypes), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        YarnClusterMetrics metrics;
        try {
            metrics = this.client.getYarnClusterMetrics();
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
        return oldMetrics;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        try {
            return ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)this.client.getRMDelegationToken(renewer), (InetSocketAddress)this.rmAddress);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get((Configuration)this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        try {
            this.application = this.client.createApplication().getNewApplicationResponse();
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        this.applicationId = this.application.getApplicationId();
        return TypeConverter.fromYarn((ApplicationId)this.applicationId);
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarn((org.apache.hadoop.yarn.api.records.QueueInfo)this.client.getQueueInfo(queueName), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueUserAclsInfo((List)this.client.getQueueAclsInfo());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getAllQueues(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getRootQueueInfos(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getChildQueueInfos(parent), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public void killApplication(ApplicationId appId) throws YarnException, IOException {
        this.client.killApplication(appId);
    }
}

