/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.client;

import com.google.common.base.Joiner;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGJobStatus
extends JobStatus {
    private final String jobFile;
    private final DAGStatus dagStatus;
    private final ApplicationReport report;

    public DAGJobStatus(ApplicationReport report, DAGStatus dagStatus, String jobFile) {
        this.dagStatus = dagStatus;
        this.jobFile = jobFile;
        this.report = report;
    }

    protected synchronized void setMapProgress(float p) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setCleanupProgress(float p) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setSetupProgress(float p) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setReduceProgress(float p) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setPriority(JobPriority jp) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setFinishTime(long finishTime) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setHistoryFile(String historyFile) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setTrackingUrl(String trackingUrl) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setRetired() {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setState(JobStatus.State state) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setStartTime(long startTime) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setUsername(String userName) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setSchedulingInfo(String schedulingInfo) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setJobACLs(Map<JobACL, AccessControlList> acls) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setQueue(String queue) {
        throw new UnsupportedOperationException();
    }

    protected synchronized void setFailureInfo(String failureInfo) {
        throw new UnsupportedOperationException();
    }

    public synchronized String getQueue() {
        return this.report.getQueue();
    }

    public synchronized float getMapProgress() {
        if (this.dagStatus.getVertexProgress() != null) {
            return this.getProgress(MultiStageMRConfigUtil.getInitialMapVertexName());
        }
        if (this.dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
            return 1.0f;
        }
        return 0.0f;
    }

    public synchronized float getCleanupProgress() {
        if (this.dagStatus.getState() == DAGStatus.State.SUCCEEDED || this.dagStatus.getState() == DAGStatus.State.FAILED || this.dagStatus.getState() == DAGStatus.State.KILLED || this.dagStatus.getState() == DAGStatus.State.ERROR) {
            return 1.0f;
        }
        return 0.0f;
    }

    public synchronized float getSetupProgress() {
        if (this.dagStatus.getState() == DAGStatus.State.RUNNING) {
            return 1.0f;
        }
        return 0.0f;
    }

    public synchronized float getReduceProgress() {
        if (this.dagStatus.getVertexProgress() != null) {
            return this.getProgress(MultiStageMRConfigUtil.getFinalReduceVertexName());
        }
        if (this.dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
            return 1.0f;
        }
        return 0.0f;
    }

    public synchronized JobStatus.State getState() {
        switch (this.dagStatus.getState()) {
            case SUBMITTED: 
            case INITING: {
                return JobStatus.State.PREP;
            }
            case RUNNING: {
                return JobStatus.State.RUNNING;
            }
            case SUCCEEDED: {
                return JobStatus.State.SUCCEEDED;
            }
            case KILLED: {
                return JobStatus.State.KILLED;
            }
            case FAILED: 
            case ERROR: {
                return JobStatus.State.FAILED;
            }
        }
        throw new TezUncheckedException("Unknown value of DAGState.State:" + this.dagStatus.getState());
    }

    public synchronized long getStartTime() {
        return this.report.getStartTime();
    }

    public JobID getJobID() {
        return TypeConverter.fromYarn((ApplicationId)this.report.getApplicationId());
    }

    public synchronized String getUsername() {
        return this.report.getUser();
    }

    public synchronized String getSchedulingInfo() {
        return this.report.getTrackingUrl();
    }

    public synchronized Map<JobACL, AccessControlList> getJobACLs() {
        return super.getJobACLs();
    }

    public synchronized JobPriority getPriority() {
        return JobPriority.NORMAL;
    }

    public synchronized String getFailureInfo() {
        return Joiner.on((String)". ").join((Iterable)this.dagStatus.getDiagnostics());
    }

    public synchronized boolean isJobComplete() {
        return this.dagStatus.getState() == DAGStatus.State.SUCCEEDED || this.dagStatus.getState() == DAGStatus.State.FAILED || this.dagStatus.getState() == DAGStatus.State.KILLED || this.dagStatus.getState() == DAGStatus.State.ERROR;
    }

    public synchronized void write(DataOutput out) throws IOException {
    }

    public synchronized void readFields(DataInput in) throws IOException {
    }

    public String getJobName() {
        return this.report.getName();
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public synchronized String getTrackingUrl() {
        return this.report.getTrackingUrl();
    }

    public synchronized long getFinishTime() {
        return this.report.getFinishTime();
    }

    public synchronized boolean isRetired() {
        return false;
    }

    public synchronized String getHistoryFile() {
        return null;
    }

    public int getNumUsedSlots() {
        return this.report.getApplicationResourceUsageReport().getNumUsedContainers();
    }

    public void setNumUsedSlots(int n) {
        throw new UnsupportedOperationException();
    }

    public int getNumReservedSlots() {
        return this.report.getApplicationResourceUsageReport().getNumReservedContainers();
    }

    public void setNumReservedSlots(int n) {
        throw new UnsupportedOperationException();
    }

    public int getUsedMem() {
        return this.report.getApplicationResourceUsageReport().getUsedResources().getMemory();
    }

    public void setUsedMem(int m) {
        throw new UnsupportedOperationException();
    }

    public int getReservedMem() {
        return this.report.getApplicationResourceUsageReport().getReservedResources().getMemory();
    }

    public void setReservedMem(int r) {
        throw new UnsupportedOperationException();
    }

    public int getNeededMem() {
        return this.report.getApplicationResourceUsageReport().getNeededResources().getMemory();
    }

    public void setNeededMem(int n) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isUber() {
        return false;
    }

    public synchronized void setUber(boolean isUber) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("job-id : " + this.getJobID());
        buffer.append("uber-mode : " + this.isUber());
        buffer.append("map-progress : " + this.getMapProgress());
        buffer.append("reduce-progress : " + this.getReduceProgress());
        buffer.append("cleanup-progress : " + this.getCleanupProgress());
        buffer.append("setup-progress : " + this.getSetupProgress());
        buffer.append("runstate : " + this.getState());
        buffer.append("start-time : " + this.getStartTime());
        buffer.append("user-name : " + this.getUsername());
        buffer.append("priority : " + this.getPriority());
        buffer.append("scheduling-info : " + this.getSchedulingInfo());
        buffer.append("num-used-slots" + this.getNumUsedSlots());
        buffer.append("num-reserved-slots" + this.getNumReservedSlots());
        buffer.append("used-mem" + this.getUsedMem());
        buffer.append("reserved-mem" + this.getReservedMem());
        buffer.append("needed-mem" + this.getNeededMem());
        return buffer.toString();
    }

    private float getProgress(String vertexName) {
        Progress progress = (Progress)this.dagStatus.getVertexProgress().get(vertexName);
        if (progress == null) {
            return 0.0f;
        }
        float totalTasks = progress.getTotalTaskCount();
        if (totalTasks != 0.0f) {
            return (float)progress.getSucceededTaskCount() / totalTasks;
        }
        return 0.0f;
    }
}

