/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.IDConverter;
import org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.hadoop.mapreduce.JobContextImpl;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class MRTask
extends AbstractLogicalIOProcessor {
    static final Logger LOG = LoggerFactory.getLogger(MRTask.class);
    protected JobConf jobConf;
    protected JobContext jobContext;
    protected org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext;
    protected OutputCommitter committer;
    transient TezCounters counters;
    protected ProcessorContext processorContext;
    protected TaskAttemptID taskAttemptId;
    protected Progress progress = new Progress();
    protected SecretKey jobTokenSecret;
    LogicalInput input;
    LogicalOutput output;
    boolean isMap;
    AtomicBoolean taskDone = new AtomicBoolean(false);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    protected MRTaskReporter mrReporter;
    protected boolean useNewApi;

    public MRTask(ProcessorContext processorContext, boolean isMap) {
        super(processorContext);
        this.isMap = isMap;
    }

    public void initialize() throws IOException, InterruptedException {
        DeprecatedKeys.init();
        this.processorContext = this.getContext();
        this.counters = this.processorContext.getCounters();
        this.taskAttemptId = new TaskAttemptID(new TaskID(Long.toString(this.processorContext.getApplicationId().getClusterTimestamp()), this.processorContext.getApplicationId().getId(), this.isMap ? TaskType.MAP : TaskType.REDUCE, this.processorContext.getTaskIndex()), this.processorContext.getTaskAttemptNumber());
        UserPayload userPayload = this.processorContext.getUserPayload();
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)userPayload);
        this.jobConf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.jobConf.set("tez.runtime.task.attempt.id", this.taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.attempt.id", this.taskAttemptId.toString());
        this.jobConf.setInt("mapreduce.job.application.attempt.id", this.processorContext.getDAGAttemptNumber());
        LOG.info("MRTask.inited: taskAttemptId = " + this.taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.vertex.name", this.processorContext.getTaskVertexName());
        if (LOG.isDebugEnabled() && userPayload != null) {
            Iterator iter = this.jobConf.iterator();
            String taskIdStr = this.taskAttemptId.getTaskID().toString();
            while (iter.hasNext()) {
                Map.Entry confEntry = (Map.Entry)iter.next();
                LOG.debug("TaskConf Entry, taskId=" + taskIdStr + ", key=" + (String)confEntry.getKey() + ", value=" + (String)confEntry.getValue());
            }
        }
        this.configureMRTask();
    }

    private void configureMRTask() throws IOException, InterruptedException {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        this.jobConf.setCredentials(credentials);
        Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
        if (jobToken != null) {
            SecretKey sk;
            this.jobTokenSecret = sk = JobTokenSecretManager.createSecretKey((byte[])jobToken.getPassword());
        } else {
            LOG.warn("No job token set");
        }
        this.configureLocalDirs();
        MRTask.setupDistributedCacheConfig(this.jobConf);
    }

    private void configureLocalDirs() throws IOException {
        this.jobConf.setStrings("tez.runtime.framework.local.dirs", this.processorContext.getWorkDirs());
        if (this.jobConf.get("tez.mr.framework.task-local-resource.dir") == null) {
            this.jobConf.set("tez.mr.framework.task-local-resource.dir", System.getenv(ApplicationConstants.Environment.PWD.name()));
        }
        this.jobConf.setStrings("mapreduce.cluster.local.dir", this.processorContext.getWorkDirs());
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        Path workDir = null;
        try {
            workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)this.jobConf);
        }
        catch (DiskChecker.DiskErrorException diskErrorException) {
            // empty catch block
        }
        if (workDir == null) {
            workDir = lDirAlloc.getLocalPathForWrite("work", (Configuration)this.jobConf);
            FileSystem lfs = FileSystem.getLocal((Configuration)this.jobConf).getRaw();
            boolean madeDir = false;
            try {
                madeDir = lfs.mkdirs(workDir);
            }
            catch (FileAlreadyExistsException e) {
                madeDir = true;
                workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)this.jobConf);
            }
            if (!madeDir) {
                throw new IOException("Mkdirs failed to create " + workDir.toString());
            }
        }
        this.jobConf.set("tez.mr.framework.job.local.dir", workDir.toString());
        this.jobConf.set("mapreduce.job.local.dir", workDir.toString());
    }

    private static void setupDistributedCacheConfig(JobConf job) throws IOException {
        URI[] cacheFiles;
        String localWorkDir = job.get("tez.mr.framework.task-local-resource.dir");
        URI[] cacheArchives = DistributedCache.getCacheArchives((Configuration)job);
        if (cacheArchives != null) {
            ArrayList<String> localArchives = new ArrayList<String>();
            for (int i = 0; i < cacheArchives.length; ++i) {
                URI u = cacheArchives[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localArchives.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localArchives.isEmpty()) {
                job.set("mapreduce.job.cache.local.archives", StringUtils.join(localArchives, (char)','));
            }
        }
        if ((cacheFiles = DistributedCache.getCacheFiles((Configuration)job)) != null) {
            ArrayList<String> localFiles = new ArrayList<String>();
            for (int i = 0; i < cacheFiles.length; ++i) {
                URI u = cacheFiles[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localFiles.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localFiles.isEmpty()) {
                job.set("mapreduce.job.cache.local.files", StringUtils.join(localFiles, (char)','));
            }
        }
    }

    public ProcessorContext getUmbilical() {
        return this.processorContext;
    }

    public void initTask(LogicalOutput output) throws IOException, InterruptedException {
        this.output = output;
        if (output instanceof MROutputLegacy) {
            this.committer = ((MROutputLegacy)output).getOutputCommitter();
        }
        this.mrReporter = new MRTaskReporter(this.processorContext);
        this.useNewApi = this.jobConf.getUseNewMapper();
        TezDAGID dagId = IDConverter.fromMRTaskAttemptId((org.apache.hadoop.mapreduce.TaskAttemptID)this.taskAttemptId).getDAGID();
        this.jobContext = new JobContextImpl((Configuration)this.jobConf, dagId, (Progressable)this.mrReporter);
        this.taskAttemptContext = new TaskAttemptContextImpl(this.jobConf, this.taskAttemptId, this.mrReporter);
        this.localizeConfiguration(this.jobConf);
    }

    public MRTaskReporter getMRReporter() {
        return this.mrReporter;
    }

    public TezCounters getCounters() {
        return this.counters;
    }

    public void setConf(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public JobConf getConf() {
        return this.jobConf;
    }

    @InterfaceAudience.Private
    public synchronized String getOutputName() {
        return "part-" + NUMBER_FORMAT.format(this.taskAttemptId.getTaskID().getId());
    }

    public void waitBeforeCompletion(MRTaskReporter reporter) throws IOException, InterruptedException {
    }

    public void done() throws IOException, InterruptedException {
        MROutputLegacy sOut;
        LOG.info("Task:" + this.taskAttemptId + " is done. And is in the process of committing");
        if (this.output instanceof MROutputLegacy && (sOut = (MROutputLegacy)this.output).isCommitRequired()) {
            this.commit(sOut);
        }
        this.taskDone.set(true);
        this.sendLastUpdate();
    }

    public void statusUpdate() throws IOException, InterruptedException {
    }

    private void sendLastUpdate() throws IOException, InterruptedException {
        this.statusUpdate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(MROutputLegacy output) throws IOException {
        int retries = 3;
        while (true) {
            try {
                while (!this.processorContext.canCommit()) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException ie) {
                LOG.warn("Failure sending canCommit: " + ExceptionUtils.getStackTrace((Throwable)ie));
                if (--retries == 0) throw ie;
                continue;
            }
            break;
        }
        try {
            LOG.info("Task " + this.taskAttemptId + " is allowed to commit now");
            output.flush();
            if (!output.isCommitRequired()) return;
            output.commit();
            return;
        }
        catch (IOException iee) {
            LOG.warn("Failure committing: " + ExceptionUtils.getStackTrace((Throwable)iee));
            this.discardOutput(output);
            throw iee;
        }
    }

    private void discardOutput(MROutputLegacy output) {
        try {
            output.abort();
        }
        catch (IOException ioe) {
            LOG.warn("Failure cleaning up: " + ExceptionUtils.getStackTrace((Throwable)ioe));
        }
    }

    public static String normalizeStatus(String status, Configuration conf) {
        int progressStatusLength = conf.getInt("mapreduce.task.max.status.length", 512);
        if (status.length() > progressStatusLength) {
            LOG.warn("Task status: \"" + status + "\" truncated to max limit (" + progressStatusLength + " characters)");
            status = status.substring(0, progressStatusLength);
        }
        return status;
    }

    protected static <INKEY, INVALUE, OUTKEY, OUTVALUE> Reducer.Context createReduceContext(Reducer<INKEY, INVALUE, OUTKEY, OUTVALUE> reducer, Configuration job, TaskAttemptID taskId, final TezRawKeyValueIterator rIter, Counter inputKeyCounter, Counter inputValueCounter, RecordWriter<OUTKEY, OUTVALUE> output, OutputCommitter committer, StatusReporter reporter, RawComparator<INKEY> comparator, Class<INKEY> keyClass, Class<INVALUE> valueClass) throws IOException, InterruptedException {
        RawKeyValueIterator r = new RawKeyValueIterator(){

            public boolean next() throws IOException {
                return rIter.next();
            }

            public DataInputBuffer getValue() throws IOException {
                return rIter.getValue();
            }

            public Progress getProgress() {
                return rIter.getProgress();
            }

            public DataInputBuffer getKey() throws IOException {
                return rIter.getKey();
            }

            public void close() throws IOException {
                rIter.close();
            }
        };
        ReduceContextImpl reduceContext = new ReduceContextImpl(job, (org.apache.hadoop.mapreduce.TaskAttemptID)taskId, r, inputKeyCounter, inputValueCounter, output, committer, reporter, comparator, keyClass, valueClass);
        LOG.debug("Using key class: {}, valueClass: {}", keyClass, valueClass);
        Reducer.Context reducerContext = new WrappedReducer().getReducerContext((ReduceContext)reduceContext);
        return reducerContext;
    }

    public void taskCleanup() throws IOException, InterruptedException {
        this.statusUpdate();
        LOG.info("Runnning cleanup for the task");
        if (this.output instanceof MROutputLegacy) {
            ((MROutputLegacy)this.output).abort();
        }
    }

    public void localizeConfiguration(JobConf jobConf) throws IOException, InterruptedException {
        jobConf.set("mapreduce.task.id", this.taskAttemptId.getTaskID().toString());
        jobConf.set("mapreduce.task.attempt.id", this.taskAttemptId.toString());
        jobConf.setInt("mapreduce.task.partition", this.taskAttemptId.getTaskID().getId());
        jobConf.set("mapreduce.job.id", this.taskAttemptId.getJobID().toString());
        jobConf.setBoolean("mapreduce.task.ismap", this.isMap);
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)jobConf);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                FileOutputFormat.setWorkOutputPath((JobConf)jobConf, (Path)((FileOutputCommitter)this.committer).getTaskAttemptPath(this.taskAttemptContext));
            } else {
                FileOutputFormat.setWorkOutputPath((JobConf)jobConf, (Path)outputPath);
            }
        }
    }

    public TaskAttemptContext getTaskAttemptContext() {
        return this.taskAttemptContext;
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.taskAttemptId;
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

