/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.mapred.split.SplitSizeEstimator;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.tez.common.Preconditions;
import org.apache.tez.mapreduce.grouper.GroupedSplitContainer;
import org.apache.tez.mapreduce.grouper.MapredSplitContainer;
import org.apache.tez.mapreduce.grouper.SplitContainer;
import org.apache.tez.mapreduce.grouper.SplitLocationProviderWrapperMapred;
import org.apache.tez.mapreduce.grouper.SplitSizeEstimatorWrapperMapred;
import org.apache.tez.mapreduce.grouper.TezSplitGrouper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezMapredSplitsGrouper
extends TezSplitGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(TezMapredSplitsGrouper.class);

    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName) throws IOException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, null);
    }

    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator) throws IOException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, estimator, null);
    }

    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator, SplitLocationProvider locationProvider) throws IOException {
        Preconditions.checkArgument((originalSplits != null ? 1 : 0) != 0, (Object)"Splits must be specified");
        List originalSplitContainers = Lists.transform(Arrays.asList(originalSplits), (Function)new Function<InputSplit, SplitContainer>(){

            public SplitContainer apply(InputSplit input) {
                return new MapredSplitContainer(input);
            }
        });
        try {
            List resultList = Lists.transform(super.getGroupedSplits(conf, originalSplitContainers, desiredNumSplits, wrappedInputFormatName, estimator == null ? null : new SplitSizeEstimatorWrapperMapred(estimator), locationProvider == null ? null : new SplitLocationProviderWrapperMapred(locationProvider)), (Function)new Function<GroupedSplitContainer, InputSplit>(){

                public InputSplit apply(GroupedSplitContainer input) {
                    List underlyingSplits = Lists.transform(input.getWrappedSplitContainers(), (Function)new Function<SplitContainer, InputSplit>(){

                        public InputSplit apply(SplitContainer input) {
                            return ((MapredSplitContainer)input).getRawSplit();
                        }
                    });
                    return new TezGroupedSplit(underlyingSplits, input.getWrappedInputFormatName(), input.getLocations(), input.getRack(), input.getLength());
                }
            });
            InputSplit[] resultArr = resultList.toArray(new InputSplit[resultList.size()]);
            return resultArr;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

