/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import org.apache.hadoop.util.ProgramDriver;
import org.apache.tez.analyzer.plugins.ContainerReuseAnalyzer;
import org.apache.tez.analyzer.plugins.CriticalPathAnalyzer;
import org.apache.tez.analyzer.plugins.LocalityAnalyzer;
import org.apache.tez.analyzer.plugins.ShuffleTimeAnalyzer;
import org.apache.tez.analyzer.plugins.SkewAnalyzer;
import org.apache.tez.analyzer.plugins.SlowNodeAnalyzer;
import org.apache.tez.analyzer.plugins.SlowTaskIdentifier;
import org.apache.tez.analyzer.plugins.SlowestVertexAnalyzer;
import org.apache.tez.analyzer.plugins.SpillAnalyzerImpl;
import org.apache.tez.analyzer.plugins.TaskConcurrencyAnalyzer;
import org.apache.tez.analyzer.plugins.VertexLevelCriticalPathAnalyzer;

public class AnalyzerDriver {
    public static void main(String[] argv) {
        int exitCode = -1;
        ProgramDriver pgd = new ProgramDriver();
        try {
            pgd.addClass("CriticalPath", CriticalPathAnalyzer.class, "Find the critical path of a DAG");
            pgd.addClass("ContainerReuseAnalyzer", ContainerReuseAnalyzer.class, "Print container reuse details in a DAG");
            pgd.addClass("LocalityAnalyzer", LocalityAnalyzer.class, "Print locality details in a DAG");
            pgd.addClass("ShuffleTimeAnalyzer", ShuffleTimeAnalyzer.class, "Analyze the shuffle time details in a DAG");
            pgd.addClass("SkewAnalyzer", SkewAnalyzer.class, "Analyze the skew details in a DAG");
            pgd.addClass("SlowestVertexAnalyzer", SlowestVertexAnalyzer.class, "Print slowest vertex details in a DAG");
            pgd.addClass("SlowNodeAnalyzer", SlowNodeAnalyzer.class, "Print node details in a DAG");
            pgd.addClass("SlowTaskIdentifier", SlowTaskIdentifier.class, "Print slow task details in a DAG");
            pgd.addClass("SpillAnalyzer", SpillAnalyzerImpl.class, "Print spill details in a DAG");
            pgd.addClass("TaskConcurrencyAnalyzer", TaskConcurrencyAnalyzer.class, "Print the task concurrency details in a DAG");
            pgd.addClass("VertexLevelCriticalPathAnalyzer", VertexLevelCriticalPathAnalyzer.class, "Find critical path at vertex level in a DAG");
            exitCode = pgd.run(argv);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(exitCode);
    }
}

