/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateStartVertexManager
extends VertexManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ImmediateStartVertexManager.class);
    private final Map<String, Boolean> srcVertexConfigured = Maps.newConcurrentMap();
    private int managedTasks;
    private boolean tasksScheduled = false;
    private AtomicBoolean onVertexStartedDone = new AtomicBoolean(false);

    public ImmediateStartVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        this.managedTasks = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        Map edges = this.getContext().getInputVertexEdgeProperties();
        for (Map.Entry entry : edges.entrySet()) {
            String srcVertex = (String)entry.getKey();
            if (this.getContext().getVertexNumTasks(srcVertex) > 0) {
                LOG.info("Task count in " + srcVertex + ": " + this.getContext().getVertexNumTasks(srcVertex));
                this.srcVertexConfigured.put(srcVertex, false);
                this.getContext().registerForVertexStateUpdates(srcVertex, EnumSet.of(VertexState.CONFIGURED));
                continue;
            }
            LOG.info("Vertex: " + this.getContext().getVertexName() + "; Ignoring " + srcVertex + " as it has got 0 tasks");
        }
        this.onVertexStartedDone.set(true);
        this.scheduleTasks();
    }

    private void scheduleTasks() {
        if (!this.onVertexStartedDone.get()) {
            return;
        }
        if (this.tasksScheduled) {
            return;
        }
        if (!this.canScheduleTasks()) {
            return;
        }
        this.tasksScheduled = true;
        ArrayList tasksToStart = Lists.newArrayListWithCapacity((int)this.managedTasks);
        for (int i = 0; i < this.managedTasks; ++i) {
            tasksToStart.add(new VertexManagerPluginContext.TaskWithLocationHint(Integer.valueOf(i), null));
        }
        if (!tasksToStart.isEmpty()) {
            LOG.info("Starting " + tasksToStart.size() + " in " + this.getContext().getVertexName());
            this.getContext().scheduleVertexTasks((List)tasksToStart);
        }
    }

    private boolean canScheduleTasks() {
        for (Map.Entry<String, Boolean> entry : this.srcVertexConfigured.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for vertex: " + entry.getKey() + " in vertex: " + this.getContext().getVertexName());
            }
            return false;
        }
        return true;
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        Preconditions.checkArgument((stateUpdate.getVertexState() == VertexState.CONFIGURED ? 1 : 0) != 0, (Object)("Received incorrect state notification : " + stateUpdate.getVertexState() + " for vertex: " + stateUpdate.getVertexName() + " in vertex: " + this.getContext().getVertexName()));
        Preconditions.checkArgument((boolean)this.srcVertexConfigured.containsKey(stateUpdate.getVertexName()), (Object)("Received incorrect vertex notification : " + stateUpdate.getVertexState() + " for vertex: " + stateUpdate.getVertexName() + " in vertex: " + this.getContext().getVertexName()));
        Preconditions.checkState((this.srcVertexConfigured.put(stateUpdate.getVertexName(), true) == false ? 1 : 0) != 0);
        LOG.info("Received configured notification: " + stateUpdate.getVertexState() + " for vertex: " + stateUpdate.getVertexName() + " in vertex: " + this.getContext().getVertexName());
        this.scheduleTasks();
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
    }

    public void initialize() {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }
}

