/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.rm.TaskSchedulerAppCallbackWrapper;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;

public class YarnTaskSchedulerService
extends TaskSchedulerService
implements AMRMClientAsync.CallbackHandler {
    private static final Log LOG = LogFactory.getLog(YarnTaskSchedulerService.class);
    final TezAMRMClientAsync<CookieContainerRequest> amRmClient;
    final TaskSchedulerService.TaskSchedulerAppCallback realAppClient;
    final TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate;
    final ContainerSignatureMatcher containerSignatureMatcher;
    ExecutorService appCallbackExecutor;
    private boolean shouldReuseContainers;
    private boolean reuseRackLocal;
    private boolean reuseNonLocal;
    Map<Object, CookieContainerRequest> taskRequests = new HashMap<Object, CookieContainerRequest>();
    LinkedHashMap<Object, Container> taskAllocations = new LinkedHashMap();
    Map<ContainerId, Object> containerAssignments = new HashMap<ContainerId, Object>();
    Set<ContainerId> inUseContainers = Sets.newHashSet();
    HashMap<ContainerId, Object> releasedContainers = new HashMap();
    Map<ContainerId, HeldContainer> heldContainers = new HashMap<ContainerId, HeldContainer>();
    Set<Priority> priorityHasAffinity = Sets.newHashSet();
    Set<NodeId> blacklistedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    Resource totalResources = Resource.newInstance((int)0, (int)0);
    Resource allocatedResources = Resource.newInstance((int)0, (int)0);
    long numHeartbeats = 0L;
    long heartbeatAtLastPreemption = 0L;
    int numHeartbeatsBetweenPreemptions = 0;
    final String appHostName;
    final int appHostPort;
    final String appTrackingUrl;
    final AppContext appContext;
    private AtomicBoolean hasUnregistered = new AtomicBoolean(false);
    AtomicBoolean isStopped = new AtomicBoolean(false);
    private ContainerAssigner NODE_LOCAL_ASSIGNER = new NodeLocalContainerAssigner();
    private ContainerAssigner RACK_LOCAL_ASSIGNER = new RackLocalContainerAssigner();
    private ContainerAssigner NON_LOCAL_ASSIGNER = new NonLocalContainerAssigner();
    DelayedContainerManager delayedContainerManager;
    long localitySchedulingDelay;
    long idleContainerTimeoutMin;
    long idleContainerTimeoutMax = 0L;
    int sessionNumMinHeldContainers = 0;
    int preemptionPercentage = 0;
    Set<ContainerId> sessionMinHeldContainers = Sets.newHashSet();
    RandomDataGenerator random = new RandomDataGenerator();
    @VisibleForTesting
    protected AtomicBoolean shouldUnregister = new AtomicBoolean(false);

    public YarnTaskSchedulerService(TaskSchedulerService.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, AppContext appContext) {
        super(YarnTaskSchedulerService.class.getName());
        this.realAppClient = appClient;
        this.appCallbackExecutor = this.createAppCallbackExecutorService();
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.appClientDelegate = this.createAppCallbackDelegate(appClient);
        this.amRmClient = TezAMRMClientAsync.createAMRMClientAsync(1000, this);
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        this.appContext = appContext;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    YarnTaskSchedulerService(TaskSchedulerService.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, TezAMRMClientAsync<CookieContainerRequest> client, AppContext appContext) {
        super(YarnTaskSchedulerService.class.getName());
        this.realAppClient = appClient;
        this.appCallbackExecutor = this.createAppCallbackExecutorService();
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.appClientDelegate = this.createAppCallbackDelegate(appClient);
        this.amRmClient = client;
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        this.appContext = appContext;
    }

    @VisibleForTesting
    ExecutorService createAppCallbackExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TaskSchedulerAppCaller #%d").setDaemon(true).build());
    }

    @Override
    public Resource getAvailableResources() {
        return this.amRmClient.getAvailableResources();
    }

    @Override
    public int getClusterNodeCount() {
        return this.amRmClient.getClusterNodeCount();
    }

    TaskSchedulerService.TaskSchedulerAppCallback createAppCallbackDelegate(TaskSchedulerService.TaskSchedulerAppCallback realAppClient) {
        return new TaskSchedulerAppCallbackWrapper(realAppClient, this.appCallbackExecutor);
    }

    @Override
    public void setShouldUnregister() {
        this.shouldUnregister.set(true);
    }

    @Override
    public boolean hasUnregistered() {
        return this.hasUnregistered.get();
    }

    public synchronized void serviceInit(Configuration conf) {
        this.amRmClient.init(conf);
        int heartbeatIntervalMax = conf.getInt("tez.am.am-rm.heartbeat.interval-ms.max", 1000);
        this.amRmClient.setHeartbeatInterval(heartbeatIntervalMax);
        this.shouldReuseContainers = conf.getBoolean("tez.am.container.reuse.enabled", true);
        this.reuseRackLocal = conf.getBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        this.reuseNonLocal = conf.getBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        Preconditions.checkArgument((!this.reuseRackLocal && !this.reuseNonLocal || this.reuseRackLocal ? 1 : 0) != 0, (Object)"Re-use Rack-Local cannot be disabled if Re-use Non-Local has been enabled");
        this.localitySchedulingDelay = conf.getLong("tez.am.container.reuse.locality.delay-allocation-millis", 250L);
        Preconditions.checkArgument((this.localitySchedulingDelay >= 0L ? 1 : 0) != 0, (Object)"Locality Scheduling delay should be >=0");
        this.idleContainerTimeoutMin = conf.getLong("tez.am.container.idle.release-timeout-min.millis", 5000L);
        Preconditions.checkArgument((this.idleContainerTimeoutMin >= 0L || this.idleContainerTimeoutMin == -1L ? 1 : 0) != 0, (Object)"Idle container release min timeout should be either -1 or >=0");
        this.idleContainerTimeoutMax = conf.getLong("tez.am.container.idle.release-timeout-max.millis", 10000L);
        Preconditions.checkArgument((this.idleContainerTimeoutMax >= 0L && this.idleContainerTimeoutMax >= this.idleContainerTimeoutMin ? 1 : 0) != 0, (Object)"Idle container release max timeout should be >=0 and >= tez.am.container.idle.release-timeout-min.millis");
        this.sessionNumMinHeldContainers = conf.getInt("tez.am.session.min.held-containers", 0);
        Preconditions.checkArgument((this.sessionNumMinHeldContainers >= 0 ? 1 : 0) != 0, (Object)"Session minimum held containers should be >=0");
        this.preemptionPercentage = conf.getInt("tez.am.preemption.percentage", 10);
        Preconditions.checkArgument((this.preemptionPercentage >= 0 && this.preemptionPercentage <= 100 ? 1 : 0) != 0, (Object)"Preemption percentage should be between 0-100");
        this.numHeartbeatsBetweenPreemptions = conf.getInt("tez.am.preemption.heartbeats-between-preemptions", 3);
        Preconditions.checkArgument((this.numHeartbeatsBetweenPreemptions >= 1 ? 1 : 0) != 0, (Object)"Heartbeats between preemptions should be >=1");
        this.delayedContainerManager = new DelayedContainerManager();
        LOG.info((Object)("TaskScheduler initialized with configuration: maxRMHeartbeatInterval: " + heartbeatIntervalMax + ", containerReuseEnabled: " + this.shouldReuseContainers + ", reuseRackLocal: " + this.reuseRackLocal + ", reuseNonLocal: " + this.reuseNonLocal + ", localitySchedulingDelay: " + this.localitySchedulingDelay + ", preemptionPercentage: " + this.preemptionPercentage + ", numHeartbeatsBetweenPreemptions: " + this.numHeartbeatsBetweenPreemptions + ", idleContainerMinTimeout: " + this.idleContainerTimeoutMin + ", idleContainerMaxTimeout: " + this.idleContainerTimeoutMax + ", sessionMinHeldContainers: " + this.sessionNumMinHeldContainers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStart() {
        try {
            RegisterApplicationMasterResponse response;
            YarnTaskSchedulerService yarnTaskSchedulerService = this;
            synchronized (yarnTaskSchedulerService) {
                this.amRmClient.start();
                response = this.amRmClient.registerApplicationMaster(this.appHostName, this.appHostPort, this.appTrackingUrl);
            }
            this.appClientDelegate.setApplicationRegistrationData(response.getMaximumResourceCapability(), response.getApplicationACLs(), response.getClientToAMTokenMasterKey());
            this.delayedContainerManager.start();
        }
        catch (YarnException e) {
            LOG.error((Object)"Yarn Exception while registering", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO Exception while registering", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws InterruptedException {
        try {
            this.delayedContainerManager.shutdown();
            this.delayedContainerManager.join(2000L);
            YarnTaskSchedulerService yarnTaskSchedulerService = this;
            synchronized (yarnTaskSchedulerService) {
                this.isStopped.set(true);
                if (this.shouldUnregister.get()) {
                    TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus status = this.appClientDelegate.getFinalAppStatus();
                    LOG.info((Object)("Unregistering application from RM, exitStatus=" + status.exitStatus + ", exitMessage=" + status.exitMessage + ", trackingURL=" + status.postCompletionTrackingUrl));
                    this.amRmClient.unregisterApplicationMaster(status.exitStatus, status.exitMessage, status.postCompletionTrackingUrl);
                    LOG.info((Object)"Successfully unregistered application from RM");
                    this.hasUnregistered.set(true);
                }
            }
            this.amRmClient.stop();
            this.appCallbackExecutor.shutdown();
            this.appCallbackExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (YarnException e) {
            LOG.error((Object)"Yarn Exception while unregistering ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException while unregistering ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersCompleted(List<ContainerStatus> statuses) {
        if (this.isStopped.get()) {
            return;
        }
        HashMap<Object, ContainerStatus> appContainerStatus = new HashMap<Object, ContainerStatus>(statuses.size());
        YarnTaskSchedulerService yarnTaskSchedulerService = this;
        synchronized (yarnTaskSchedulerService) {
            for (ContainerStatus containerStatus : statuses) {
                ContainerId completedId = containerStatus.getContainerId();
                HeldContainer delayedContainer = this.heldContainers.get(completedId);
                Object task = this.releasedContainers.remove(completedId);
                if (task != null) {
                    if (delayedContainer != null) {
                        LOG.warn((Object)"Held container should be null since releasedContainer is not");
                    }
                    LOG.info((Object)("Released container completed:" + completedId + " last allocated to task: " + task));
                    appContainerStatus.put(task, containerStatus);
                    continue;
                }
                task = this.unAssignContainer(completedId, false);
                if (delayedContainer != null) {
                    this.heldContainers.remove(completedId);
                    Resources.subtract((Resource)this.allocatedResources, (Resource)delayedContainer.getContainer().getResource());
                } else {
                    LOG.warn((Object)"Held container expected to be not null for a non-AM-released container");
                }
                if (task != null) {
                    LOG.info((Object)("Allocated container completed:" + completedId + " last allocated to task: " + task));
                    appContainerStatus.put(task, containerStatus);
                    continue;
                }
                LOG.info((Object)("Ignoring unknown container: " + containerStatus.getContainerId()));
            }
        }
        for (Map.Entry entry : appContainerStatus.entrySet()) {
            this.appClientDelegate.containerCompleted(entry.getKey(), (ContainerStatus)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersAllocated(List<Container> containers) {
        Map<CookieContainerRequest, Container> assignedContainers;
        if (this.isStopped.get()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Container container : containers) {
                sb.append(container.getId()).append(", ");
            }
            LOG.debug((Object)("Assigned New Containers: " + sb.toString()));
        }
        YarnTaskSchedulerService yarnTaskSchedulerService = this;
        synchronized (yarnTaskSchedulerService) {
            if (this.shouldReuseContainers) {
                this.pushNewContainerToDelayed(containers);
                return;
            }
            LinkedList modifiableContainerList = Lists.newLinkedList(containers);
            assignedContainers = this.assignNewlyAllocatedContainers(modifiableContainerList);
        }
        this.informAppAboutAssignments(assignedContainers);
    }

    private synchronized Map<CookieContainerRequest, Container> assignNewlyAllocatedContainers(Iterable<Container> containers) {
        HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
        this.assignNewContainersWithLocation(containers, this.NODE_LOCAL_ASSIGNER, assignedContainers);
        this.assignNewContainersWithLocation(containers, this.RACK_LOCAL_ASSIGNER, assignedContainers);
        this.assignNewContainersWithLocation(containers, this.NON_LOCAL_ASSIGNER, assignedContainers);
        this.releaseUnassignedContainers(containers);
        return assignedContainers;
    }

    private synchronized Map<CookieContainerRequest, Container> tryAssignReUsedContainers(Iterable<Container> containers) {
        HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
        this.assignReUsedContainersWithLocation(containers, this.NODE_LOCAL_ASSIGNER, assignedContainers, true);
        this.assignReUsedContainersWithLocation(containers, this.RACK_LOCAL_ASSIGNER, assignedContainers, true);
        this.assignReUsedContainersWithLocation(containers, this.NON_LOCAL_ASSIGNER, assignedContainers, true);
        return assignedContainers;
    }

    @VisibleForTesting
    long getHeldContainerExpireTime(long startTime) {
        long expireTime = startTime + this.idleContainerTimeoutMin;
        if (this.idleContainerTimeoutMin != -1L && this.idleContainerTimeoutMin < this.idleContainerTimeoutMax) {
            long expireTimeMax = startTime + this.idleContainerTimeoutMax;
            expireTime = this.random.nextLong(expireTime, expireTimeMax);
        }
        return expireTime;
    }

    private synchronized Map<CookieContainerRequest, Container> assignDelayedContainer(HeldContainer heldContainer) {
        DAGAppMasterState state = this.appContext.getAMState();
        boolean isNew = heldContainer.isNew();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to assign a delayed container, containerId=" + heldContainer.getContainer().getId() + ", nextScheduleTime=" + heldContainer.getNextScheduleTime() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", AMState=" + (Object)((Object)state) + ", matchLevel=" + (Object)((Object)heldContainer.getLocalityMatchLevel()) + ", taskRequestsCount=" + this.taskRequests.size() + ", heldContainers=" + this.heldContainers.size() + ", delayedContainers=" + this.delayedContainerManager.delayedContainers.size() + ", isNew=" + isNew));
        }
        if (state.equals((Object)DAGAppMasterState.IDLE) || this.taskRequests.isEmpty()) {
            if (this.appContext.isSession() && this.sessionNumMinHeldContainers > 0 && this.sessionMinHeldContainers.isEmpty()) {
                this.determineMinHeldContainers();
            }
            heldContainer.resetLocalityMatchLevel();
            long currentTime = System.currentTimeMillis();
            boolean releaseContainer = false;
            if (isNew || heldContainer.getContainerExpiryTime() <= currentTime && this.idleContainerTimeoutMin != -1L) {
                if (this.appContext.isSession() && this.sessionMinHeldContainers.contains(heldContainer.getContainer().getId())) {
                    heldContainer.setContainerExpiryTime(this.getHeldContainerExpireTime(currentTime));
                } else {
                    releaseContainer = true;
                }
            }
            if (releaseContainer) {
                LOG.info((Object)("No taskRequests. Container's idle timeout delay expired or is new. Releasing container, containerId=" + heldContainer.getContainer().getId() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", idleTimeout=" + this.idleContainerTimeoutMin + ", taskRequestsCount=" + this.taskRequests.size() + ", heldContainers=" + this.heldContainers.size() + ", delayedContainers=" + this.delayedContainerManager.delayedContainers.size() + ", isNew=" + isNew));
                this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.getContainer()}));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Holding onto idle container with no work. CId: " + heldContainer.getContainer().getId() + " with expiry: " + heldContainer.getContainerExpiryTime() + " currentTime: " + currentTime + " next look: " + (currentTime + this.localitySchedulingDelay)));
                }
                heldContainer.resetLocalityMatchLevel();
                this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
            }
        } else {
            if (state.equals((Object)DAGAppMasterState.RUNNING)) {
                if (!this.sessionMinHeldContainers.isEmpty()) {
                    long currentTime = System.currentTimeMillis();
                    for (ContainerId minHeldCId : this.sessionMinHeldContainers) {
                        HeldContainer minHeldContainer = this.heldContainers.get(minHeldCId);
                        if (minHeldContainer == null) continue;
                        minHeldContainer.setContainerExpiryTime(this.getHeldContainerExpireTime(currentTime));
                    }
                    this.sessionMinHeldContainers.clear();
                }
                HeldContainer.LocalityMatchLevel localityMatchLevel = heldContainer.getLocalityMatchLevel();
                HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
                Container containerToAssign = heldContainer.container;
                heldContainer.incrementAssignmentAttempts();
                if (isNew || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NEW) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NODE) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.RACK) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL)) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.NODE_LOCAL_ASSIGNER, assignedContainers, true);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using node, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty() && (this.reuseRackLocal || isNew) && (this.localitySchedulingDelay == 0L || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.RACK) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL))) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.RACK_LOCAL_ASSIGNER, assignedContainers, false);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using rack, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty() && (this.reuseNonLocal || isNew) && (this.localitySchedulingDelay == 0L || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL))) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.NON_LOCAL_ASSIGNER, assignedContainers, false);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using non-local, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty()) {
                    long currentTime = System.currentTimeMillis();
                    if (!isNew && heldContainer.getContainerExpiryTime() <= currentTime && this.idleContainerTimeoutMin != -1L) {
                        LOG.info((Object)("Container's idle timeout expired. Releasing container, containerId=" + heldContainer.container.getId() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", idleTimeoutMin=" + this.idleContainerTimeoutMin));
                        this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
                    } else {
                        boolean hitFinalMatchLevel = localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL);
                        if (!hitFinalMatchLevel) {
                            heldContainer.incrementLocalityMatchLevel();
                            if (this.localitySchedulingDelay == 0L || !this.reuseRackLocal || !this.reuseNonLocal && heldContainer.getLocalityMatchLevel().equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL)) {
                                hitFinalMatchLevel = true;
                            }
                            if (this.localitySchedulingDelay > 0L && isNew) {
                                hitFinalMatchLevel = false;
                            }
                        }
                        if (hitFinalMatchLevel) {
                            boolean safeToRelease = true;
                            Priority topPendingPriority = this.amRmClient.getTopPriority();
                            Priority containerPriority = heldContainer.container.getPriority();
                            if (isNew && topPendingPriority != null && containerPriority.compareTo(topPendingPriority) < 0) {
                                safeToRelease = false;
                            }
                            if (!(!safeToRelease || this.taskRequests.isEmpty() && this.appContext.isSession())) {
                                LOG.info((Object)("Releasing held container as either there are pending but  unmatched requests or this is not a session, containerId=" + heldContainer.container.getId() + ", pendingTasks=" + this.taskRequests.size() + ", isSession=" + this.appContext.isSession() + ". isNew=" + isNew));
                                this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
                            } else {
                                heldContainer.resetLocalityMatchLevel();
                                this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
                            }
                        } else {
                            this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Delayed container assignment successful, containerId=" + heldContainer.getContainer().getId()));
                }
                return assignedContainers;
            }
            LOG.warn((Object)("Received a request to assign re-used containers when AM was  in state: " + (Object)((Object)state) + ". Ignoring request and releasing container" + ": " + heldContainer.getContainer().getId()));
            this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resetMatchLocalityForAllHeldContainers() {
        for (HeldContainer heldContainer : this.heldContainers.values()) {
            heldContainer.resetLocalityMatchLevel();
        }
        DelayedContainerManager delayedContainerManager = this.delayedContainerManager;
        synchronized (delayedContainerManager) {
            this.delayedContainerManager.notify();
        }
    }

    public void onShutdownRequest() {
        if (this.isStopped.get()) {
            return;
        }
        this.appClientDelegate.appShutdownRequested();
    }

    public void onNodesUpdated(List<NodeReport> updatedNodes) {
        if (this.isStopped.get()) {
            return;
        }
        this.appClientDelegate.nodesUpdated(updatedNodes);
    }

    public float getProgress() {
        if (this.isStopped.get()) {
            return 1.0f;
        }
        if (this.totalResources.getMemory() == 0) {
            this.totalResources = Resources.clone((Resource)this.getAvailableResources());
            LOG.info((Object)("App total resource memory: " + this.totalResources.getMemory() + " cpu: " + this.totalResources.getVirtualCores() + " taskAllocations: " + this.taskAllocations.size()));
        }
        ++this.numHeartbeats;
        this.preemptIfNeeded();
        return this.appClientDelegate.getProgress();
    }

    public void onError(Throwable t) {
        if (this.isStopped.get()) {
            return;
        }
        this.appClientDelegate.onError(t);
    }

    @Override
    public Resource getTotalResources() {
        return this.totalResources;
    }

    @Override
    public synchronized void blacklistNode(NodeId nodeId) {
        LOG.info((Object)("Blacklisting node: " + nodeId));
        this.amRmClient.addNodeToBlacklist(nodeId);
        this.blacklistedNodes.add(nodeId);
    }

    @Override
    public synchronized void unblacklistNode(NodeId nodeId) {
        if (this.blacklistedNodes.remove(nodeId)) {
            LOG.info((Object)("UnBlacklisting node: " + nodeId));
            this.amRmClient.removeNodeFromBlacklist(nodeId);
        }
    }

    @Override
    public synchronized void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        CRCookie cookie = new CRCookie(task, clientCookie, containerSignature);
        CookieContainerRequest request = new CookieContainerRequest(capability, hosts, racks, priority, cookie);
        this.addRequestAndTrigger(task, request, hosts, racks);
    }

    @Override
    public synchronized void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        HeldContainer heldContainer = this.heldContainers.get(containerId);
        String[] hosts = null;
        String[] racks = null;
        if (heldContainer != null) {
            Container container = heldContainer.getContainer();
            if (this.canFit(capability, container.getResource())) {
                hosts = new String[]{container.getNodeId().getHost()};
                this.priorityHasAffinity.add(priority);
            } else {
                LOG.warn((Object)("Matching requested to container: " + containerId + " but requested capability: " + capability + " does not fit in container resource: " + container.getResource()));
            }
        } else {
            LOG.warn((Object)("Matching requested to unknown container: " + containerId));
        }
        CRCookie cookie = new CRCookie(task, clientCookie, containerSignature);
        CookieContainerRequest request = new CookieContainerRequest(capability, containerId, hosts, racks, priority, cookie);
        this.addRequestAndTrigger(task, request, hosts, racks);
    }

    private void addRequestAndTrigger(Object task, CookieContainerRequest request, String[] hosts, String[] racks) {
        this.addTaskRequest(task, request);
        this.delayedContainerManager.triggerScheduling(true);
        LOG.info((Object)("Allocation request for task: " + task + " with request: " + (Object)((Object)request) + " host: " + (hosts != null && hosts.length > 0 ? hosts[0] : "null") + " rack: " + (racks != null && racks.length > 0 ? racks[0] : "null")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deallocateTask(Object task, boolean taskSucceeded) {
        Map<CookieContainerRequest, Container> assignedContainers = null;
        YarnTaskSchedulerService yarnTaskSchedulerService = this;
        synchronized (yarnTaskSchedulerService) {
            CookieContainerRequest request = this.removeTaskRequest(task);
            if (request != null) {
                LOG.info((Object)("Deallocating task: " + task + " before allocation"));
                return false;
            }
            Container container = this.doBookKeepingForTaskDeallocate(task);
            if (container == null) {
                LOG.info((Object)("Ignoring removal of unknown task: " + task));
                return false;
            }
            LOG.info((Object)("Deallocated task: " + task + " from container: " + container.getId()));
            if (!taskSucceeded || !this.shouldReuseContainers) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Releasing container, containerId=" + container.getId() + ", taskSucceeded=" + taskSucceeded + ", reuseContainersFlag=" + this.shouldReuseContainers));
                }
                this.releaseContainer(container.getId());
            } else {
                HeldContainer heldContainer = this.heldContainers.get(container.getId());
                if (heldContainer != null) {
                    heldContainer.resetLocalityMatchLevel();
                    long currentTime = System.currentTimeMillis();
                    if (this.idleContainerTimeoutMin > 0L) {
                        heldContainer.setContainerExpiryTime(this.getHeldContainerExpireTime(currentTime));
                    }
                    assignedContainers = this.assignDelayedContainer(heldContainer);
                } else {
                    LOG.info((Object)("Skipping container after task deallocate as container is no longer running, containerId=" + container.getId()));
                }
            }
        }
        if (assignedContainers != null && assignedContainers.size() == 1) {
            this.informAppAboutAssignments(assignedContainers);
        }
        return true;
    }

    @Override
    public synchronized Object deallocateContainer(ContainerId containerId) {
        Object task = this.unAssignContainer(containerId, true);
        if (task != null) {
            LOG.info((Object)("Deallocated container: " + containerId + " from task: " + task));
            return task;
        }
        LOG.info((Object)("Ignoring dealloction of unknown container: " + containerId));
        return null;
    }

    boolean canFit(Resource arg0, Resource arg1) {
        int mem0 = arg0.getMemory();
        int mem1 = arg1.getMemory();
        int cpu0 = arg0.getVirtualCores();
        int cpu1 = arg1.getVirtualCores();
        return mem0 <= mem1 && cpu0 <= cpu1;
    }

    static int scaleDownByPreemptionPercentage(int original, int percent) {
        return (int)Math.ceil((float)(original * percent) / 100.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preemptIfNeeded() {
        if (this.preemptionPercentage == 0) {
            return;
        }
        ContainerId[] preemptedContainers = null;
        int numPendingRequestsToService = 0;
        YarnTaskSchedulerService yarnTaskSchedulerService = this;
        synchronized (yarnTaskSchedulerService) {
            Resource freeResources = this.amRmClient.getAvailableResources();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Allocated resource memory: " + this.allocatedResources.getMemory() + " cpu:" + this.allocatedResources.getVirtualCores() + " delayedContainers: " + this.delayedContainerManager.delayedContainers.size() + " heartbeats: " + this.numHeartbeats + " lastPreemptionHeartbeat: " + this.heartbeatAtLastPreemption));
            }
            assert (freeResources.getMemory() >= 0);
            CookieContainerRequest highestPriRequest = null;
            int numHighestPriRequests = 0;
            for (CookieContainerRequest request : this.taskRequests.values()) {
                if (highestPriRequest == null) {
                    highestPriRequest = request;
                    numHighestPriRequests = 1;
                    continue;
                }
                if (this.isHigherPriority(request.getPriority(), highestPriRequest.getPriority())) {
                    highestPriRequest = request;
                    numHighestPriRequests = 1;
                    continue;
                }
                if (!request.getPriority().equals((Object)highestPriRequest.getPriority())) continue;
                ++numHighestPriRequests;
            }
            if (highestPriRequest == null) {
                return;
            }
            if (this.fitsIn(highestPriRequest.getCapability(), freeResources)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Highest pri request: " + (Object)((Object)highestPriRequest) + " fits in available resources " + freeResources));
                }
                return;
            }
            numPendingRequestsToService = YarnTaskSchedulerService.scaleDownByPreemptionPercentage(numHighestPriRequests, this.preemptionPercentage);
            if (numPendingRequestsToService < 1) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to service " + numPendingRequestsToService + " out of total " + numHighestPriRequests + " pending requests at pri: " + highestPriRequest.getPriority()));
            }
            block4: for (int i = 0; i < numPendingRequestsToService; ++i) {
                Container lowestPriNewContainer = null;
                for (HeldContainer heldContainer : this.delayedContainerManager.delayedContainers) {
                    if (!heldContainer.isNew()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Reused container exists. Wait for assignment loop to release it. " + heldContainer.getContainer().getId()));
                        }
                        return;
                    }
                    if (heldContainer.geNumAssignmentAttempts() < 3) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Brand new container. Wait for assignment loop to match it. " + heldContainer.getContainer().getId()));
                        }
                        return;
                    }
                    Container container = heldContainer.getContainer();
                    if (lowestPriNewContainer != null && !this.isHigherPriority(lowestPriNewContainer.getPriority(), container.getPriority())) continue;
                    lowestPriNewContainer = container;
                }
                if (lowestPriNewContainer == null) continue;
                LOG.info((Object)("Preempting new container: " + lowestPriNewContainer.getId() + " with priority: " + lowestPriNewContainer.getPriority() + " to free resource for request: " + (Object)((Object)highestPriRequest) + " . Current free resources: " + freeResources));
                --numPendingRequestsToService;
                this.releaseUnassignedContainers(Collections.singletonList(lowestPriNewContainer));
                for (Map.Entry entry : this.taskRequests.entrySet()) {
                    Object task = entry.getKey();
                    CookieContainerRequest request = (CookieContainerRequest)((Object)entry.getValue());
                    if (!request.getPriority().equals((Object)lowestPriNewContainer.getPriority())) continue;
                    LOG.info((Object)("Resending request for task again: " + task));
                    this.deallocateTask(task, true);
                    this.allocateTask(task, request.getCapability(), request.getNodes() == null ? null : request.getNodes().toArray(new String[request.getNodes().size()]), request.getRacks() == null ? null : request.getRacks().toArray(new String[request.getRacks().size()]), request.getPriority(), request.getCookie().getContainerSignature(), request.getCookie().getAppCookie());
                    continue block4;
                }
            }
            if (numPendingRequestsToService < 1) {
                return;
            }
            assert (this.delayedContainerManager.delayedContainers.isEmpty());
            if (this.numHeartbeats - this.heartbeatAtLastPreemption <= (long)this.numHeartbeatsBetweenPreemptions) {
                return;
            }
            Priority preemptedTaskPriority = null;
            int numEntriesAtPreemptedPriority = 0;
            for (Map.Entry entry : this.taskAllocations.entrySet()) {
                HeldContainer heldContainer = this.heldContainers.get(((Container)entry.getValue()).getId());
                CookieContainerRequest lastTaskInfo = heldContainer.getLastTaskInfo();
                Priority taskPriority = lastTaskInfo.getPriority();
                Object signature = lastTaskInfo.getCookie().getContainerSignature();
                if (!this.isHigherPriority(highestPriRequest.getPriority(), taskPriority) || this.containerSignatureMatcher.isExactMatch(highestPriRequest.getCookie().getContainerSignature(), signature) || preemptedTaskPriority != null && this.isHigherPriority(taskPriority, preemptedTaskPriority)) continue;
                preemptedTaskPriority = taskPriority;
                if (taskPriority.equals((Object)preemptedTaskPriority)) {
                    ++numEntriesAtPreemptedPriority;
                    continue;
                }
                numEntriesAtPreemptedPriority = 1;
            }
            if (preemptedTaskPriority != null) {
                int newNumPendingRequestsToService = YarnTaskSchedulerService.scaleDownByPreemptionPercentage(Math.min(numEntriesAtPreemptedPriority, numHighestPriRequests), this.preemptionPercentage);
                numPendingRequestsToService = Math.min(newNumPendingRequestsToService, numPendingRequestsToService);
                if (numPendingRequestsToService < 1) {
                    return;
                }
                LOG.info((Object)("Trying to service " + numPendingRequestsToService + " out of total " + numHighestPriRequests + " pending requests at pri: " + highestPriRequest.getPriority() + " by preempting from " + numEntriesAtPreemptedPriority + " running tasks at priority: " + preemptedTaskPriority));
                preemptedContainers = new ContainerId[numPendingRequestsToService];
                boolean bl = false;
                for (Map.Entry<Object, Container> entry : this.taskAllocations.entrySet()) {
                    HeldContainer heldContainer = this.heldContainers.get(entry.getValue().getId());
                    CookieContainerRequest lastTaskInfo = heldContainer.getLastTaskInfo();
                    Priority taskPriority = lastTaskInfo.getPriority();
                    Container container = entry.getValue();
                    if (!preemptedTaskPriority.equals((Object)taskPriority)) continue;
                    preemptedContainers[++var10_22 % numPendingRequestsToService] = container.getId();
                }
            }
        }
        if (preemptedContainers != null) {
            this.heartbeatAtLastPreemption = this.numHeartbeats;
            for (int i = 0; i < numPendingRequestsToService; ++i) {
                void cId = preemptedContainers[i];
                if (cId == null) continue;
                LOG.info((Object)("Preempting container: " + cId + " currently allocated to a task."));
                this.appClientDelegate.preemptContainer((ContainerId)cId);
            }
        }
    }

    private boolean fitsIn(Resource toFit, Resource resource) {
        return resource.getMemory() >= toFit.getMemory();
    }

    private CookieContainerRequest getMatchingRequestWithPriority(Container container, String location) {
        Resource capability;
        Priority priority = container.getPriority();
        List requestsList = this.amRmClient.getMatchingRequests(priority, location, capability = container.getResource());
        if (!requestsList.isEmpty()) {
            for (Collection requests : requestsList) {
                for (CookieContainerRequest cookieContainerRequest : requests) {
                    if (!this.canAssignTaskToContainer(cookieContainerRequest, container)) continue;
                    return cookieContainerRequest;
                }
            }
        }
        return null;
    }

    private CookieContainerRequest getMatchingRequestWithoutPriority(Container container, String location, boolean considerContainerAffinity) {
        Resource capability = container.getResource();
        List<Collection<CookieContainerRequest>> pRequestsList = this.amRmClient.getMatchingRequestsForTopPriority(location, capability);
        if (considerContainerAffinity && !this.priorityHasAffinity.contains(this.amRmClient.getTopPriority())) {
            considerContainerAffinity = false;
        }
        if (pRequestsList == null || pRequestsList.isEmpty()) {
            return null;
        }
        CookieContainerRequest firstMatch = null;
        for (Collection<CookieContainerRequest> requests : pRequestsList) {
            for (CookieContainerRequest cookieContainerRequest : requests) {
                if (firstMatch != null && !container.getId().equals((Object)cookieContainerRequest.getAffinitizedContainer()) || !this.canAssignTaskToContainer(cookieContainerRequest, container)) continue;
                if (!considerContainerAffinity) {
                    return cookieContainerRequest;
                }
                ContainerId affCId = cookieContainerRequest.getAffinitizedContainer();
                boolean canMatchTaskWithAffinity = true;
                if (affCId == null || !this.heldContainers.containsKey(affCId) || this.inUseContainers.contains(affCId)) {
                    canMatchTaskWithAffinity = false;
                }
                if (canMatchTaskWithAffinity) {
                    if (container.getId().equals((Object)cookieContainerRequest.getAffinitizedContainer())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Matching with affinity for request: " + (Object)((Object)cookieContainerRequest) + " container: " + affCId));
                        }
                        return cookieContainerRequest;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Skipping request for container " + container.getId() + " due to affinity. Request: " + (Object)((Object)cookieContainerRequest) + " affContainer: " + affCId));
                    continue;
                }
                firstMatch = cookieContainerRequest;
            }
        }
        return firstMatch;
    }

    private boolean canAssignTaskToContainer(CookieContainerRequest cookieContainerRequest, Container container) {
        HeldContainer heldContainer = this.heldContainers.get(container.getId());
        if (heldContainer == null || heldContainer.isNew()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to match task to a held container,  containerId=" + heldContainer.container.getId()));
        }
        if (this.containerSignatureMatcher.isSuperSet(heldContainer.getLastAssignedContainerSignature(), cookieContainerRequest.getCookie().getContainerSignature())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Matched delayed container to task containerId=" + heldContainer.container.getId()));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Failed to match delayed container to task containerId=" + heldContainer.container.getId()));
        }
        return false;
    }

    private Object getTask(CookieContainerRequest request) {
        return request.getCookie().getTask();
    }

    private void releaseContainer(ContainerId containerId) {
        HeldContainer delayedContainer;
        Object assignedTask = this.containerAssignments.remove(containerId);
        if (assignedTask != null) {
            this.appClientDelegate.containerBeingReleased(containerId);
        }
        if ((delayedContainer = this.heldContainers.remove(containerId)) != null) {
            Resources.subtractFrom((Resource)this.allocatedResources, (Resource)delayedContainer.getContainer().getResource());
        }
        if (delayedContainer != null || !this.shouldReuseContainers) {
            this.amRmClient.releaseAssignedContainer(containerId);
        }
        if (assignedTask != null) {
            this.releasedContainers.put(containerId, assignedTask);
        }
    }

    private void assignContainer(Object task, Container container, CookieContainerRequest assigned) {
        CookieContainerRequest request = this.removeTaskRequest(task);
        assert (request != null);
        Container result = this.taskAllocations.put(task, container);
        assert (result == null);
        this.inUseContainers.add(container.getId());
        this.containerAssignments.put(container.getId(), task);
        HeldContainer heldContainer = this.heldContainers.get(container.getId());
        if (!this.shouldReuseContainers && heldContainer == null) {
            this.heldContainers.put(container.getId(), new HeldContainer(container, -1L, -1L, assigned, this.containerSignatureMatcher));
            Resources.addTo((Resource)this.allocatedResources, (Resource)container.getResource());
        } else {
            if (heldContainer.isNew()) {
                this.heldContainers.put(container.getId(), new HeldContainer(container, heldContainer.getNextScheduleTime(), heldContainer.getContainerExpiryTime(), assigned, this.containerSignatureMatcher));
            }
            heldContainer.setLastTaskInfo(assigned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushNewContainerToDelayed(List<Container> containers) {
        long expireTime = this.getHeldContainerExpireTime(System.currentTimeMillis());
        DelayedContainerManager delayedContainerManager = this.delayedContainerManager;
        synchronized (delayedContainerManager) {
            for (Container container : containers) {
                if (this.heldContainers.put(container.getId(), new HeldContainer(container, -1L, expireTime, null, this.containerSignatureMatcher)) != null) {
                    throw new TezUncheckedException("New container " + container.getId() + " is already held.");
                }
                long nextScheduleTime = this.delayedContainerManager.maxScheduleTimeSeen;
                if (this.delayedContainerManager.maxScheduleTimeSeen == -1L) {
                    nextScheduleTime = System.currentTimeMillis();
                }
                Resources.addTo((Resource)this.allocatedResources, (Resource)container.getResource());
                this.delayedContainerManager.addDelayedContainer(container, nextScheduleTime + 1L);
            }
        }
        this.delayedContainerManager.triggerScheduling(false);
    }

    private CookieContainerRequest removeTaskRequest(Object task) {
        CookieContainerRequest request = this.taskRequests.remove(task);
        if (request != null) {
            this.amRmClient.removeContainerRequest(request);
        }
        return request;
    }

    private void addTaskRequest(Object task, CookieContainerRequest request) {
        CookieContainerRequest oldRequest = this.taskRequests.put(task, request);
        if (oldRequest != null) {
            this.amRmClient.removeContainerRequest(oldRequest);
        }
        this.amRmClient.addContainerRequest(request);
    }

    private Container doBookKeepingForTaskDeallocate(Object task) {
        Container container = (Container)this.taskAllocations.remove(task);
        if (container == null) {
            return null;
        }
        this.inUseContainers.remove(container.getId());
        return container;
    }

    private Object unAssignContainer(ContainerId containerId, boolean releaseIfFound) {
        Object task = this.containerAssignments.get(containerId);
        if (task == null) {
            return null;
        }
        Container container = (Container)this.taskAllocations.remove(task);
        assert (container != null);
        this.inUseContainers.remove(containerId);
        if (releaseIfFound) {
            this.releaseContainer(containerId);
        }
        return task;
    }

    private boolean isHigherPriority(Priority lhs, Priority rhs) {
        return lhs.getPriority() < rhs.getPriority();
    }

    private synchronized void assignNewContainersWithLocation(Iterable<Container> containers, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers) {
        Iterator<Container> containerIterator = containers.iterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            CookieContainerRequest assigned = assigner.assignNewContainer(container);
            if (assigned == null) continue;
            assignedContainers.put(assigned, container);
            containerIterator.remove();
        }
    }

    private synchronized void assignReUsedContainersWithLocation(Iterable<Container> containers, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers, boolean honorLocality) {
        Iterator<Container> containerIterator = containers.iterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            if (!this.assignReUsedContainerWithLocation(container, assigner, assignedContainers, honorLocality)) continue;
            containerIterator.remove();
        }
    }

    private synchronized boolean assignReUsedContainerWithLocation(Container container, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers, boolean honorLocality) {
        Priority containerPriority = container.getPriority();
        Priority topPendingTaskPriority = this.amRmClient.getTopPriority();
        if (topPendingTaskPriority == null) {
            return false;
        }
        if (topPendingTaskPriority.compareTo(containerPriority) > 0 && this.heldContainers.get(container.getId()).isNew()) {
            return false;
        }
        CookieContainerRequest assigned = assigner.assignReUsedContainer(container, honorLocality);
        if (assigned != null) {
            assignedContainers.put(assigned, container);
            return true;
        }
        return false;
    }

    private void releaseUnassignedContainers(Iterable<Container> containers) {
        for (Container container : containers) {
            LOG.info((Object)("Releasing unused container: " + container.getId()));
            this.releaseContainer(container.getId());
        }
    }

    private void informAppAboutAssignment(CookieContainerRequest assigned, Container container) {
        this.appClientDelegate.taskAllocated(this.getTask(assigned), assigned.getCookie().getAppCookie(), container);
    }

    private void informAppAboutAssignments(Map<CookieContainerRequest, Container> assignedContainers) {
        if (assignedContainers == null || assignedContainers.isEmpty()) {
            return;
        }
        for (Map.Entry<CookieContainerRequest, Container> entry : assignedContainers.entrySet()) {
            Container container = entry.getValue();
            if (this.blacklistedNodes.contains(container.getNodeId())) {
                CookieContainerRequest request = entry.getKey();
                Object task = this.getTask(request);
                LOG.info((Object)("Container: " + container.getId() + " allocated on blacklisted node: " + container.getNodeId() + " for task: " + task));
                Object deAllocTask = this.deallocateContainer(container.getId());
                assert (deAllocTask.equals(task));
                this.allocateTask(task, request.getCapability(), request.getNodes() == null ? null : request.getNodes().toArray(new String[request.getNodes().size()]), request.getRacks() == null ? null : request.getRacks().toArray(new String[request.getRacks().size()]), request.getPriority(), request.getCookie().getContainerSignature(), request.getCookie().getAppCookie());
                continue;
            }
            this.informAppAboutAssignment(entry.getKey(), container);
        }
    }

    synchronized void determineMinHeldContainers() {
        Iterator iter;
        List nodeContainers;
        this.sessionMinHeldContainers.clear();
        if (this.sessionNumMinHeldContainers <= 0) {
            return;
        }
        if (this.heldContainers.size() <= this.sessionNumMinHeldContainers) {
            this.sessionMinHeldContainers.addAll(this.heldContainers.keySet());
        }
        HashMap rackHeldNumber = Maps.newHashMap();
        HashMap nodeHeldContainers = Maps.newHashMap();
        for (HeldContainer heldContainer : this.heldContainers.values()) {
            AtomicInteger count = (AtomicInteger)rackHeldNumber.get(heldContainer.getRack());
            if (count == null) {
                count = new AtomicInteger(0);
                rackHeldNumber.put(heldContainer.getRack(), count);
            }
            count.incrementAndGet();
            nodeContainers = (List)nodeHeldContainers.get(heldContainer.getNode());
            if (nodeContainers == null) {
                nodeContainers = Lists.newLinkedList();
                nodeHeldContainers.put(heldContainer.getNode(), nodeContainers);
            }
            nodeContainers.add(heldContainer);
        }
        HashMap rackToHoldNumber = Maps.newHashMap();
        for (String rack : rackHeldNumber.keySet()) {
            rackToHoldNumber.put(rack, new AtomicInteger(0));
        }
        int containerCount = 0;
        while (containerCount < this.sessionNumMinHeldContainers && !rackHeldNumber.isEmpty()) {
            iter = rackHeldNumber.entrySet().iterator();
            while (containerCount < this.sessionNumMinHeldContainers && iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (((AtomicInteger)entry.getValue()).decrementAndGet() >= 0) {
                    ++containerCount;
                    ((AtomicInteger)rackToHoldNumber.get(entry.getKey())).incrementAndGet();
                    continue;
                }
                iter.remove();
            }
        }
        containerCount = 0;
        while (containerCount < this.sessionNumMinHeldContainers && !nodeHeldContainers.isEmpty()) {
            iter = nodeHeldContainers.entrySet().iterator();
            while (containerCount < this.sessionNumMinHeldContainers && iter.hasNext()) {
                nodeContainers = (List)iter.next().getValue();
                if (nodeContainers.isEmpty()) {
                    iter.remove();
                    continue;
                }
                HeldContainer heldContainer = (HeldContainer)nodeContainers.remove(nodeContainers.size() - 1);
                if (((AtomicInteger)rackToHoldNumber.get(heldContainer.getRack())).decrementAndGet() >= 0) {
                    ++containerCount;
                    this.sessionMinHeldContainers.add(heldContainer.getContainer().getId());
                    continue;
                }
                iter.remove();
            }
        }
        LOG.info((Object)("Holding on to " + this.sessionMinHeldContainers.size() + " containers" + " out of total held containers: " + this.heldContainers.size()));
    }

    static class HeldContainer {
        final Container container;
        private final String rack;
        private long nextScheduleTime;
        private LocalityMatchLevel localityMatchLevel;
        private long containerExpiryTime;
        private CookieContainerRequest lastTaskInfo;
        private int numAssignmentAttempts = 0;
        private Object lastAssignedContainerSignature;
        final ContainerSignatureMatcher signatureMatcher;

        HeldContainer(Container container, long nextScheduleTime, long containerExpiryTime, CookieContainerRequest firstTaskInfo, ContainerSignatureMatcher signatureMatcher) {
            this.container = container;
            this.nextScheduleTime = nextScheduleTime;
            if (firstTaskInfo != null) {
                this.lastTaskInfo = firstTaskInfo;
                this.lastAssignedContainerSignature = firstTaskInfo.getCookie().getContainerSignature();
            }
            this.localityMatchLevel = LocalityMatchLevel.NODE;
            this.containerExpiryTime = containerExpiryTime;
            this.rack = RackResolver.resolve((String)container.getNodeId().getHost()).getNetworkLocation();
            this.signatureMatcher = signatureMatcher;
        }

        boolean isNew() {
            return this.lastTaskInfo == null;
        }

        String getRack() {
            return this.rack;
        }

        String getNode() {
            return this.container.getNodeId().getHost();
        }

        int geNumAssignmentAttempts() {
            return this.numAssignmentAttempts;
        }

        void incrementAssignmentAttempts() {
            ++this.numAssignmentAttempts;
        }

        public Container getContainer() {
            return this.container;
        }

        public long getNextScheduleTime() {
            return this.nextScheduleTime;
        }

        public void setNextScheduleTime(long nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        public long getContainerExpiryTime() {
            return this.containerExpiryTime;
        }

        public void setContainerExpiryTime(long containerExpiryTime) {
            this.containerExpiryTime = containerExpiryTime;
        }

        public Object getLastAssignedContainerSignature() {
            return this.lastAssignedContainerSignature;
        }

        public CookieContainerRequest getLastTaskInfo() {
            return this.lastTaskInfo;
        }

        public void setLastTaskInfo(CookieContainerRequest taskInfo) {
            this.lastAssignedContainerSignature = taskInfo.getCookie().getContainerSignature();
            if (this.lastTaskInfo != null && this.lastTaskInfo.getCookie().getContainerSignature() != null) {
                this.lastAssignedContainerSignature = this.signatureMatcher.union(this.lastTaskInfo.getCookie().getContainerSignature(), taskInfo.getCookie().getContainerSignature());
            }
            this.lastTaskInfo = taskInfo;
        }

        public synchronized void resetLocalityMatchLevel() {
            this.localityMatchLevel = LocalityMatchLevel.NEW;
        }

        public synchronized void incrementLocalityMatchLevel() {
            if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NEW)) {
                this.localityMatchLevel = LocalityMatchLevel.NODE;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NODE)) {
                this.localityMatchLevel = LocalityMatchLevel.RACK;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.RACK)) {
                this.localityMatchLevel = LocalityMatchLevel.NON_LOCAL;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NON_LOCAL)) {
                throw new TezUncheckedException("Cannot increment locality level  from current NON_LOCAL for container: " + this.container.getId());
            }
        }

        public LocalityMatchLevel getLocalityMatchLevel() {
            return this.localityMatchLevel;
        }

        public String toString() {
            return "HeldContainer: id: " + this.container.getId() + ", nextScheduleTime: " + this.nextScheduleTime + ", localityMatchLevel=" + (Object)((Object)this.localityMatchLevel) + ", signature: " + (this.lastAssignedContainerSignature != null ? this.lastAssignedContainerSignature.toString() : "null");
        }

        static enum LocalityMatchLevel {
            NEW,
            NODE,
            RACK,
            NON_LOCAL;

        }
    }

    private class ContainerIterable
    implements Iterable<Container> {
        private final Iterable<HeldContainer> delayedContainers;

        ContainerIterable(Iterable<HeldContainer> delayedContainers) {
            this.delayedContainers = delayedContainers;
        }

        @Override
        public Iterator<Container> iterator() {
            final Iterator<HeldContainer> delayedContainerIterator = this.delayedContainers.iterator();
            return new Iterator<Container>(){

                @Override
                public boolean hasNext() {
                    return delayedContainerIterator.hasNext();
                }

                @Override
                public Container next() {
                    return ((HeldContainer)delayedContainerIterator.next()).getContainer();
                }

                @Override
                public void remove() {
                    delayedContainerIterator.remove();
                }
            };
        }
    }

    @VisibleForTesting
    class DelayedContainerManager
    extends Thread {
        PriorityBlockingQueue<HeldContainer> delayedContainers = new PriorityBlockingQueue<HeldContainer>(20, new HeldContainerTimerComparator());
        private volatile boolean tryAssigningAll = false;
        private volatile boolean running = true;
        private long maxScheduleTimeSeen = -1L;
        @VisibleForTesting
        volatile AtomicBoolean drainedDelayedContainersForTest = null;

        DelayedContainerManager() {
            super.setName("DelayedContainerManager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                long nextScheduleTs;
                long currentTs;
                HeldContainer delayedContainer;
                if (this.tryAssigningAll) {
                    this.doAssignAll();
                    this.tryAssigningAll = false;
                }
                DelayedContainerManager delayedContainerManager = this;
                synchronized (delayedContainerManager) {
                    if (this.delayedContainers.peek() == null) {
                        try {
                            if (this.drainedDelayedContainersForTest != null) {
                                AtomicBoolean atomicBoolean = this.drainedDelayedContainersForTest;
                                synchronized (atomicBoolean) {
                                    this.drainedDelayedContainersForTest.set(true);
                                    this.drainedDelayedContainersForTest.notifyAll();
                                }
                            }
                            this.wait();
                            continue;
                        }
                        catch (InterruptedException e) {
                            LOG.info((Object)"AllocatedContainerManager Thread interrupted");
                        }
                    }
                }
                if (this.drainedDelayedContainersForTest != null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if ((delayedContainer = this.delayedContainers.peek()) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Considering HeldContainer: " + delayedContainer + " for assignment"));
                }
                if ((currentTs = System.currentTimeMillis()) >= (nextScheduleTs = delayedContainer.getNextScheduleTime())) {
                    delayedContainer = this.delayedContainers.poll();
                    if (delayedContainer == null) continue;
                    Map assignedContainers = null;
                    YarnTaskSchedulerService yarnTaskSchedulerService = YarnTaskSchedulerService.this;
                    synchronized (yarnTaskSchedulerService) {
                        if (null != YarnTaskSchedulerService.this.heldContainers.get(delayedContainer.getContainer().getId())) {
                            assignedContainers = YarnTaskSchedulerService.this.assignDelayedContainer(delayedContainer);
                        } else {
                            LOG.info((Object)("Skipping delayed container as container is no longer running, containerId=" + delayedContainer.getContainer().getId()));
                        }
                    }
                    YarnTaskSchedulerService.this.informAppAboutAssignments(assignedContainers);
                    continue;
                }
                DelayedContainerManager delayedContainerManager2 = this;
                synchronized (delayedContainerManager2) {
                    try {
                        delayedContainer = this.delayedContainers.peek();
                        long diff = YarnTaskSchedulerService.this.localitySchedulingDelay;
                        if (delayedContainer != null) {
                            diff = delayedContainer.getNextScheduleTime() - currentTs;
                        }
                        if (diff > 0L) {
                            this.wait(diff);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"AllocatedContainerManager Thread interrupted");
                    }
                }
            }
            this.releasePendingContainers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAssignAll() {
            Map assignedContainers;
            if (this.delayedContainers.isEmpty()) {
                return;
            }
            YarnTaskSchedulerService yarnTaskSchedulerService = YarnTaskSchedulerService.this;
            synchronized (yarnTaskSchedulerService) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Trying to assign all delayed containers to newly received tasks");
                }
                Iterator<HeldContainer> iter = this.delayedContainers.iterator();
                while (iter.hasNext()) {
                    HeldContainer delayedContainer = iter.next();
                    if (YarnTaskSchedulerService.this.heldContainers.containsKey(delayedContainer.getContainer().getId())) continue;
                    LOG.info((Object)("AssignAll - Skipping delayed container as container is no longer running, containerId=" + delayedContainer.getContainer().getId()));
                    iter.remove();
                }
                assignedContainers = YarnTaskSchedulerService.this.tryAssignReUsedContainers(new ContainerIterable(this.delayedContainers));
            }
            YarnTaskSchedulerService.this.informAppAboutAssignments(assignedContainers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerScheduling(boolean scheduleAll) {
            this.tryAssigningAll = scheduleAll;
            DelayedContainerManager delayedContainerManager = this;
            synchronized (delayedContainerManager) {
                this.notify();
            }
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }

        private void releasePendingContainers() {
            ArrayList pendingContainers = Lists.newArrayListWithCapacity((int)this.delayedContainers.size());
            this.delayedContainers.drainTo(pendingContainers);
            YarnTaskSchedulerService.this.releaseUnassignedContainers(new ContainerIterable(pendingContainers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void addDelayedContainer(Container container, long nextScheduleTime) {
            HeldContainer delayedContainer = YarnTaskSchedulerService.this.heldContainers.get(container.getId());
            if (delayedContainer == null) {
                LOG.warn((Object)("Attempting to add a non-running container to the delayed container list, containerId=" + container.getId()));
                return;
            }
            delayedContainer.setNextScheduleTime(nextScheduleTime);
            if (this.maxScheduleTimeSeen < nextScheduleTime) {
                this.maxScheduleTimeSeen = nextScheduleTime;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding container to delayed queue, containerId=" + delayedContainer.getContainer().getId() + ", nextScheduleTime=" + delayedContainer.getNextScheduleTime() + ", containerExpiry=" + delayedContainer.getContainerExpiryTime()));
            }
            boolean added = false;
            DelayedContainerManager delayedContainerManager = this;
            synchronized (delayedContainerManager) {
                added = this.delayedContainers.offer(delayedContainer);
                this.notify();
            }
            if (!added) {
                YarnTaskSchedulerService.this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{container}));
            }
        }

        class HeldContainerTimerComparator
        implements Comparator<HeldContainer> {
            HeldContainerTimerComparator() {
            }

            @Override
            public int compare(HeldContainer c1, HeldContainer c2) {
                return (int)(c1.getNextScheduleTime() - c2.getNextScheduleTime());
            }
        }
    }

    private class NonLocalContainerAssigner
    extends ContainerAssigner {
        NonLocalContainerAssigner() {
            super("NonLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = "*";
            CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            if (!honorLocality) {
                String location = "*";
                CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithoutPriority(container, location, false);
                this.doBookKeepingForAssignedContainer(assigned, container, location, honorLocality);
                return assigned;
            }
            return null;
        }
    }

    private class RackLocalContainerAssigner
    extends ContainerAssigner {
        RackLocalContainerAssigner() {
            super("RackLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = RackResolver.resolve((String)container.getNodeId().getHost()).getNetworkLocation();
            CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            if (!honorLocality) {
                String location = YarnTaskSchedulerService.this.heldContainers.get(container.getId()).getRack();
                CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithoutPriority(container, location, false);
                this.doBookKeepingForAssignedContainer(assigned, container, location, honorLocality);
                return assigned;
            }
            return null;
        }
    }

    private class NodeLocalContainerAssigner
    extends ContainerAssigner {
        NodeLocalContainerAssigner() {
            super("NodeLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = container.getNodeId().getHost();
            CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            String location = container.getNodeId().getHost();
            CookieContainerRequest assigned = YarnTaskSchedulerService.this.getMatchingRequestWithoutPriority(container, location, true);
            this.doBookKeepingForAssignedContainer(assigned, container, location, true);
            return assigned;
        }
    }

    private abstract class ContainerAssigner {
        protected final String locality;

        protected ContainerAssigner(String locality) {
            this.locality = locality;
        }

        public abstract CookieContainerRequest assignNewContainer(Container var1);

        public abstract CookieContainerRequest assignReUsedContainer(Container var1, boolean var2);

        public void doBookKeepingForAssignedContainer(CookieContainerRequest assigned, Container container, String matchedLocation, boolean honorLocalityFlags) {
            if (assigned == null) {
                return;
            }
            Object task = YarnTaskSchedulerService.this.getTask(assigned);
            assert (task != null);
            LOG.info((Object)("Assigning container to task, container=" + container + ", task=" + task + ", containerHost=" + container.getNodeId().getHost() + ", localityMatchType=" + this.locality + ", matchedLocation=" + matchedLocation + ", honorLocalityFlags=" + honorLocalityFlags + ", reusedContainer=" + YarnTaskSchedulerService.this.containerAssignments.containsKey(container.getId()) + ", delayedContainers=" + YarnTaskSchedulerService.this.delayedContainerManager.delayedContainers.size() + ", containerResourceMemory=" + container.getResource().getMemory() + ", containerResourceVCores=" + container.getResource().getVirtualCores()));
            YarnTaskSchedulerService.this.assignContainer(task, container, assigned);
        }
    }

    class CookieContainerRequest
    extends AMRMClient.ContainerRequest {
        CRCookie cookie;
        ContainerId affinitizedContainerId;

        public CookieContainerRequest(Resource capability, String[] hosts, String[] racks, Priority priority, CRCookie cookie) {
            super(capability, hosts, racks, priority);
            this.cookie = cookie;
        }

        public CookieContainerRequest(Resource capability, ContainerId containerId, String[] hosts, String[] racks, Priority priority, CRCookie cookie) {
            this(capability, hosts, racks, priority, cookie);
            this.affinitizedContainerId = containerId;
        }

        CRCookie getCookie() {
            return this.cookie;
        }

        ContainerId getAffinitizedContainer() {
            return this.affinitizedContainerId;
        }
    }

    class CRCookie {
        private Object task;
        private Object appCookie;
        private Object containerSignature;

        CRCookie(Object task, Object appCookie, Object containerSignature) {
            this.task = task;
            this.appCookie = appCookie;
            this.containerSignature = containerSignature;
        }

        Object getTask() {
            return this.task;
        }

        Object getAppCookie() {
            return this.appCookie;
        }

        Object getContainerSignature() {
            return this.containerSignature;
        }
    }
}

