/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Simple2LevelVersionComparator {
    private static final Log LOG = LogFactory.getLog(Simple2LevelVersionComparator.class);

    public int compare(String versionStr1, String versionStr2) {
        Version v1 = new Version(versionStr1);
        Version v2 = new Version(versionStr2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Comparing versions version1=" + v1.majorVersion + "." + v1.minorVersion + ", version2=" + v2.majorVersion + "." + v2.minorVersion));
        }
        if (v1.majorVersion == -1 || v2.majorVersion == -1) {
            return -1;
        }
        if (v1.majorVersion == v2.majorVersion) {
            if (v1.minorVersion == -1 && v2.minorVersion != -1 || v1.minorVersion != -1 && v2.minorVersion == -1) {
                return -1;
            }
            if (v1.minorVersion > v2.minorVersion) {
                return 1;
            }
            if (v1.minorVersion < v2.minorVersion) {
                return -1;
            }
            return 0;
        }
        if (v1.majorVersion > v2.majorVersion) {
            return 1;
        }
        return -1;
    }

    public static class Version {
        int majorVersion = -1;
        int minorVersion = -1;

        public Version(String versionString) {
            String token;
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".-", true);
            while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals("-")) {
                if (token.equals(".")) continue;
                try {
                    int i = Integer.valueOf(token);
                    if (index == 0) {
                        this.majorVersion = i;
                    } else if (index == 1) {
                        this.minorVersion = i;
                        break;
                    }
                    ++index;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
        }
    }
}

