/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.EdgeManagerPlugin;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;

public class ScatterGatherEdgeManager
extends EdgeManagerPlugin {
    public ScatterGatherEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public int getNumDestinationTaskPhysicalInputs(int destinationTaskIndex) {
        return this.getContext().getSourceVertexNumTasks();
    }

    public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
        int physicalOutputs = this.getContext().getDestinationVertexNumTasks();
        Preconditions.checkArgument((physicalOutputs >= 0 ? 1 : 0) != 0, (Object)"ScatteGather edge manager must have destination vertex task parallelism specified");
        return physicalOutputs;
    }

    public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int sourceOutputIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        destinationTaskAndInputIndices.put(sourceOutputIndex, Collections.singletonList(sourceTaskIndex));
    }

    public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        for (int i = 0; i < this.getContext().getDestinationVertexNumTasks(); ++i) {
            destinationTaskAndInputIndices.put(i, Collections.singletonList(sourceTaskIndex));
        }
    }

    public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex, int destinationFailedInputIndex) {
        return destinationFailedInputIndex;
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return this.getContext().getDestinationVertexNumTasks();
    }
}

