/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.launcher.ContainerLauncher;
import org.apache.tez.dag.app.rm.NMCommunicatorEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorLaunchRequestEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    private ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    private AppContext context;
    protected ThreadPoolExecutor launcherPool;
    protected static final int INITIAL_POOL_SIZE = 10;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    protected BlockingQueue<NMCommunicatorEvent> eventQueue = new LinkedBlockingQueue<NMCommunicatorEvent>();
    private Clock clock;
    private ContainerManagementProtocolProxy cmProxy;
    private AtomicBoolean serviceStopped = new AtomicBoolean(false);

    private Container getContainer(NMCommunicatorEvent event) {
        Container old;
        ContainerId id = event.getContainerId();
        Container c = this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container(event.getContainerId(), event.getNodeId().toString(), event.getContainerToken()))) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
        this.clock = context.getClock();
    }

    public synchronized void serviceInit(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = conf.getInt("tez.am.containerlauncher.thread-count-limit", 500);
        LOG.info((Object)("Upper limit on the thread pool size is " + this.limitOnPoolSize));
    }

    public void serviceStart() {
        this.cmProxy = new ContainerManagementProtocolProxy(this.getConfig());
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf, new CustomizedRejectedExecutionHandler());
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                NMCommunicatorEvent event = null;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        event = ContainerLauncherImpl.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!ContainerLauncherImpl.this.serviceStopped.get()) {
                            LOG.error((Object)("Returning, interrupted : " + e));
                        }
                        return;
                    }
                    int poolSize = ContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != ContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = ContainerLauncherImpl.this.context.getNodeTracker().getNumNodes();
                        int idealPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize < idealPoolSize) {
                            int newPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, idealPoolSize + 10);
                            LOG.info((Object)("Setting ContainerLauncher pool size to " + newPoolSize + " as number-of-nodes to talk to is " + numNodes));
                            ContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    ContainerLauncherImpl.this.launcherPool.execute(ContainerLauncherImpl.this.createEventProcessor(event));
                }
            }
        };
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
    }

    private void shutdownAllContainers() {
        for (Container ct : this.containers.values()) {
            if (ct == null) continue;
            ct.kill();
        }
    }

    public void serviceStop() {
        if (!this.serviceStopped.compareAndSet(false, true)) {
            LOG.info((Object)"Ignoring multiple stops");
            return;
        }
        this.shutdownAllContainers();
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        if (this.launcherPool != null) {
            this.launcherPool.shutdownNow();
        }
    }

    protected EventProcessor createEventProcessor(NMCommunicatorEvent event) {
        return new EventProcessor(event);
    }

    protected ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData getCMProxy(ContainerId containerID, String containerManagerBindAddr, Token containerToken) throws IOException {
        return this.cmProxy.getProxy(containerManagerBindAddr, containerID);
    }

    void sendContainerLaunchFailedMsg(ContainerId containerId, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunchFailed(containerId, message));
    }

    public void handle(NMCommunicatorEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private static class CustomizedRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private CustomizedRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOG.warn((Object)("Can't submit task to ThreadPoolExecutor:" + executor));
        }
    }

    class EventProcessor
    implements Runnable {
        private NMCommunicatorEvent event;

        EventProcessor(NMCommunicatorEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            ContainerId containerID = this.event.getContainerId();
            Container c = ContainerLauncherImpl.this.getContainer(this.event);
            switch ((NMCommunicatorEventType)this.event.getType()) {
                case CONTAINER_LAUNCH_REQUEST: {
                    NMCommunicatorLaunchRequestEvent launchEvent = (NMCommunicatorLaunchRequestEvent)this.event;
                    c.launch(launchEvent);
                    break;
                }
                case CONTAINER_STOP_REQUEST: {
                    c.kill();
                }
            }
            ContainerLauncherImpl.this.removeContainerIfDone(containerID);
        }
    }

    private class Container {
        private ContainerState state = ContainerState.PREP;
        private ContainerId containerID;
        private final String containerMgrAddress;
        private Token containerToken;

        public Container(ContainerId containerID, String containerMgrAddress, Token containerToken) {
            this.containerMgrAddress = containerMgrAddress;
            this.containerID = containerID;
            this.containerToken = containerToken;
        }

        public synchronized boolean isCompletelyDone() {
            return this.state == ContainerState.DONE || this.state == ContainerState.FAILED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void launch(NMCommunicatorLaunchRequestEvent event) {
            LOG.info((Object)("Launching Container with Id: " + event.getContainerId()));
            if (this.state == ContainerState.KILLED_BEFORE_LAUNCH) {
                this.state = ContainerState.DONE;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(event.getContainerId(), "Container was killed before it was launched");
                return;
            }
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = ContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                ContainerLaunchContext containerLaunchContext = event.getContainerLaunchContext();
                StartContainerRequest startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                startRequest.setContainerToken(event.getContainerToken());
                startRequest.setContainerLaunchContext(containerLaunchContext);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(StartContainersRequest.newInstance(Collections.singletonList(startRequest)));
                if (response.getFailedRequests() != null && !response.getFailedRequests().isEmpty()) {
                    throw ((SerializedException)response.getFailedRequests().get(this.containerID)).deSerialize();
                }
                ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new AMContainerEventLaunched(this.containerID));
                ContainerLaunchedEvent lEvt = new ContainerLaunchedEvent(this.containerID, ContainerLauncherImpl.this.clock.getTime(), ContainerLauncherImpl.this.context.getApplicationAttemptId());
                ContainerLauncherImpl.this.context.getHistoryHandler().handle(new DAGHistoryEvent(null, lEvt));
                this.state = ContainerState.RUNNING;
                if (proxy == null) return;
            }
            catch (Throwable t) {
                try {
                    String message = "Container launch failed for " + this.containerID + " : " + ExceptionUtils.getStackTrace((Throwable)t);
                    this.state = ContainerState.FAILED;
                    ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.containerID, message);
                    if (proxy == null) return;
                }
                catch (Throwable throwable) {
                    if (proxy == null) throw throwable;
                    ContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                    throw throwable;
                }
                ContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                return;
            }
            ContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public synchronized void kill() {
            if (this.isCompletelyDone()) {
                return;
            }
            if (this.state == ContainerState.PREP) {
                this.state = ContainerState.KILLED_BEFORE_LAUNCH;
            } else {
                ContainerLauncherImpl.LOG.info((Object)("Sending a stop request to the NM for ContainerId: " + this.containerID));
                proxy = null;
                try {
                    proxy = ContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                    stopRequest = (StopContainersRequest)Records.newRecord(StopContainersRequest.class);
                    stopRequest.setContainerIds(Collections.singletonList(this.containerID));
                    proxy.getContainerManagementProtocol().stopContainers(stopRequest);
                    ContainerLauncherImpl.access$000(ContainerLauncherImpl.this).getEventHandler().handle((Event)new AMContainerEvent(this.containerID, AMContainerEventType.C_NM_STOP_SENT));
                    ** if (proxy == null) goto lbl-1000
                }
                catch (Throwable t) {
                    block9: {
                        try {
                            message = "cleanup failed for container " + this.containerID + " : " + ExceptionUtils.getStackTrace((Throwable)t);
                            ContainerLauncherImpl.access$000(ContainerLauncherImpl.this).getEventHandler().handle((Event)new AMContainerEventStopFailed(this.containerID, message));
                            ContainerLauncherImpl.LOG.warn((Object)message);
                            this.state = ContainerState.DONE;
                            if (proxy == null) break block9;
                        }
                        catch (Throwable var4_5) {
                            if (proxy != null) {
                                ContainerLauncherImpl.access$200(ContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                            }
                            throw var4_5;
                        }
                        ContainerLauncherImpl.access$200(ContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                    }
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    ContainerLauncherImpl.access$200(ContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                }
lbl-1000:
                // 2 sources

                {
                }
                this.state = ContainerState.DONE;
            }
        }
    }

    private static enum ContainerState {
        PREP,
        FAILED,
        RUNNING,
        DONE,
        KILLED_BEFORE_LAUNCH;

    }
}

