/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.records.TezTaskID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGUtils {
    static final String DAG_NAME_KEY = "dagName";
    static final String VERTICES_KEY = "vertices";
    static final String EDGES_KEY = "edges";
    static final String VERTEX_GROUPS_KEY = "vertexGroups";
    static final String VERTEX_NAME_KEY = "vertexName";
    static final String PROCESSOR_CLASS_KEY = "processorClass";
    static final String IN_EDGE_IDS_KEY = "inEdgeIds";
    static final String OUT_EDGE_IDS_KEY = "outEdgeIds";
    static final String ADDITIONAL_INPUTS_KEY = "additionalInputs";
    static final String ADDITIONAL_OUTPUTS_KEY = "additionalOutputs";
    static final String VERTEX_MANAGER_PLUGIN_CLASS_KEY = "vertexManagerPluginClass";
    static final String USER_PAYLOAD_AS_TEXT = "userPayloadAsText";
    static final String OUTPUT_USER_PAYLOAD_AS_TEXT = "outputUserPayloadAsText";
    static final String INPUT_USER_PAYLOAD_AS_TEXT = "inputUserPayloadAsText";
    static final String EDGE_ID_KEY = "edgeId";
    static final String INPUT_VERTEX_NAME_KEY = "inputVertexName";
    static final String OUTPUT_VERTEX_NAME_KEY = "outputVertexName";
    static final String DATA_MOVEMENT_TYPE_KEY = "dataMovementType";
    static final String DATA_SOURCE_TYPE_KEY = "dataSourceType";
    static final String SCHEDULING_TYPE_KEY = "schedulingType";
    static final String EDGE_SOURCE_CLASS_KEY = "edgeSourceClass";
    static final String EDGE_DESTINATION_CLASS_KEY = "edgeDestinationClass";
    static final String NAME_KEY = "name";
    static final String CLASS_KEY = "class";
    static final String INITIALIZER_KEY = "initializer";
    static final String VERTEX_GROUP_NAME_KEY = "groupName";
    static final String VERTEX_GROUP_MEMBERS_KEY = "groupMembers";
    static final String VERTEX_GROUP_OUTPUTS_KEY = "outputs";
    static final String VERTEX_GROUP_EDGE_MERGED_INPUTS_KEY = "edgeMergedInputs";
    static final String VERTEX_GROUP_DESTINATION_VERTEX_NAME_KEY = "destinationVertexName";

    public static JSONObject generateSimpleJSONPlan(DAGProtos.DAGPlan dagPlan) throws JSONException {
        JSONObject dagJson;
        try {
            dagJson = new JSONObject(DAGUtils.convertDAGPlanToATSMap(dagPlan));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        return dagJson;
    }

    public static JSONObject convertCountersToJSON(TezCounters counters) throws JSONException {
        JSONObject jsonObject = new JSONObject(DAGUtils.convertCountersToATSMap(counters));
        return jsonObject;
    }

    public static Map<String, Object> convertCountersToATSMap(TezCounters counters) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        if (counters == null) {
            return object;
        }
        ArrayList<Object> counterGroupsList = new ArrayList<Object>();
        for (CounterGroup group : counters) {
            LinkedHashMap<String, Object> counterGroupMap = new LinkedHashMap<String, Object>();
            counterGroupMap.put("counterGroupName", group.getName());
            counterGroupMap.put("counterGroupDisplayName", group.getDisplayName());
            ArrayList<Object> counterList = new ArrayList<Object>();
            for (TezCounter counter : group) {
                LinkedHashMap<String, Object> counterMap = new LinkedHashMap<String, Object>();
                counterMap.put("counterName", counter.getName());
                counterMap.put("counterDisplayName", counter.getDisplayName());
                counterMap.put("counterValue", counter.getValue());
                counterList.add(counterMap);
            }
            DAGUtils.putInto(counterGroupMap, "counters", counterList);
            counterGroupsList.add(counterGroupMap);
        }
        DAGUtils.putInto(object, "counterGroups", counterGroupsList);
        return object;
    }

    public static Map<String, Object> convertDAGPlanToATSMap(DAGProtos.DAGPlan dagPlan) throws IOException {
        String VERSION_KEY = "version";
        boolean version = true;
        LinkedHashMap<String, Object> dagMap = new LinkedHashMap<String, Object>();
        dagMap.put(DAG_NAME_KEY, dagPlan.getName());
        dagMap.put("version", 1);
        ArrayList<Object> verticesList = new ArrayList<Object>();
        for (DAGProtos.VertexPlan vertexPlan : dagPlan.getVertexList()) {
            LinkedHashMap<String, Object> vertexMap = new LinkedHashMap<String, Object>();
            vertexMap.put(VERTEX_NAME_KEY, vertexPlan.getName());
            if (vertexPlan.hasProcessorDescriptor()) {
                vertexMap.put(PROCESSOR_CLASS_KEY, vertexPlan.getProcessorDescriptor().getClassName());
                if (vertexPlan.getProcessorDescriptor().hasHistoryText()) {
                    vertexMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)vertexPlan.getProcessorDescriptor()));
                }
            }
            ArrayList<Object> inEdgeIdList = new ArrayList<Object>();
            inEdgeIdList.addAll(vertexPlan.getInEdgeIdList());
            DAGUtils.putInto(vertexMap, IN_EDGE_IDS_KEY, inEdgeIdList);
            ArrayList<Object> outEdgeIdList = new ArrayList<Object>();
            outEdgeIdList.addAll(vertexPlan.getOutEdgeIdList());
            DAGUtils.putInto(vertexMap, OUT_EDGE_IDS_KEY, outEdgeIdList);
            ArrayList<Object> inputsList = new ArrayList<Object>();
            for (DAGProtos.RootInputLeafOutputProto input : vertexPlan.getInputsList()) {
                LinkedHashMap<String, String> inputMap = new LinkedHashMap<String, String>();
                inputMap.put(NAME_KEY, input.getName());
                inputMap.put(CLASS_KEY, input.getIODescriptor().getClassName());
                if (input.hasControllerDescriptor()) {
                    inputMap.put(INITIALIZER_KEY, input.getControllerDescriptor().getClassName());
                }
                if (input.getIODescriptor().hasHistoryText()) {
                    inputMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)input.getIODescriptor()));
                }
                inputsList.add(inputMap);
            }
            DAGUtils.putInto(vertexMap, ADDITIONAL_INPUTS_KEY, inputsList);
            ArrayList<Object> outputsList = new ArrayList<Object>();
            for (DAGProtos.RootInputLeafOutputProto output : vertexPlan.getOutputsList()) {
                LinkedHashMap<String, String> outputMap = new LinkedHashMap<String, String>();
                outputMap.put(NAME_KEY, output.getName());
                outputMap.put(CLASS_KEY, output.getIODescriptor().getClassName());
                if (output.hasControllerDescriptor()) {
                    outputMap.put(INITIALIZER_KEY, output.getControllerDescriptor().getClassName());
                }
                if (output.getIODescriptor().hasHistoryText()) {
                    outputMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)output.getIODescriptor()));
                }
                outputsList.add(outputMap);
            }
            DAGUtils.putInto(vertexMap, ADDITIONAL_OUTPUTS_KEY, outputsList);
            if (vertexPlan.hasVertexManagerPlugin()) {
                vertexMap.put(VERTEX_MANAGER_PLUGIN_CLASS_KEY, vertexPlan.getVertexManagerPlugin().getClassName());
            }
            verticesList.add(vertexMap);
        }
        DAGUtils.putInto(dagMap, VERTICES_KEY, verticesList);
        ArrayList<Object> edgesList = new ArrayList<Object>();
        for (DAGProtos.EdgePlan edgePlan : dagPlan.getEdgeList()) {
            LinkedHashMap<String, String> edgeMap = new LinkedHashMap<String, String>();
            edgeMap.put(EDGE_ID_KEY, edgePlan.getId());
            edgeMap.put(INPUT_VERTEX_NAME_KEY, edgePlan.getInputVertexName());
            edgeMap.put(OUTPUT_VERTEX_NAME_KEY, edgePlan.getOutputVertexName());
            edgeMap.put(DATA_MOVEMENT_TYPE_KEY, edgePlan.getDataMovementType().name());
            edgeMap.put(DATA_SOURCE_TYPE_KEY, edgePlan.getDataSourceType().name());
            edgeMap.put(SCHEDULING_TYPE_KEY, edgePlan.getSchedulingType().name());
            edgeMap.put(EDGE_SOURCE_CLASS_KEY, edgePlan.getEdgeSource().getClassName());
            edgeMap.put(EDGE_DESTINATION_CLASS_KEY, edgePlan.getEdgeDestination().getClassName());
            if (edgePlan.getEdgeSource().hasHistoryText()) {
                edgeMap.put(OUTPUT_USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgePlan.getEdgeSource()));
            }
            if (edgePlan.getEdgeDestination().hasHistoryText()) {
                edgeMap.put(INPUT_USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgePlan.getEdgeDestination()));
            }
            edgesList.add(edgeMap);
        }
        DAGUtils.putInto(dagMap, EDGES_KEY, edgesList);
        ArrayList<Object> vertexGroupsList = new ArrayList<Object>();
        for (DAGProtos.PlanVertexGroupInfo vertexGroupInfo : dagPlan.getVertexGroupsList()) {
            LinkedHashMap<String, Object> groupMap = new LinkedHashMap<String, Object>();
            groupMap.put(VERTEX_GROUP_NAME_KEY, vertexGroupInfo.getGroupName());
            if (vertexGroupInfo.getGroupMembersCount() > 0) {
                groupMap.put(VERTEX_GROUP_MEMBERS_KEY, vertexGroupInfo.getGroupMembersList());
            }
            if (vertexGroupInfo.getOutputsCount() > 0) {
                groupMap.put(VERTEX_GROUP_OUTPUTS_KEY, vertexGroupInfo.getOutputsList());
            }
            if (vertexGroupInfo.getEdgeMergedInputsCount() > 0) {
                ArrayList edgeMergedInputs = new ArrayList();
                for (DAGProtos.PlanGroupInputEdgeInfo edgeMergedInputInfo : vertexGroupInfo.getEdgeMergedInputsList()) {
                    LinkedHashMap<String, String> edgeMergedInput = new LinkedHashMap<String, String>();
                    edgeMergedInput.put(VERTEX_GROUP_DESTINATION_VERTEX_NAME_KEY, edgeMergedInputInfo.getDestVertexName());
                    if (edgeMergedInputInfo.hasMergedInput() && edgeMergedInputInfo.getMergedInput().hasClassName()) {
                        edgeMergedInput.put(PROCESSOR_CLASS_KEY, edgeMergedInputInfo.getMergedInput().getClassName());
                        if (edgeMergedInputInfo.getMergedInput().hasHistoryText()) {
                            edgeMergedInput.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgeMergedInputInfo.getMergedInput()));
                        }
                    }
                    edgeMergedInputs.add(edgeMergedInput);
                }
                groupMap.put(VERTEX_GROUP_EDGE_MERGED_INPUTS_KEY, edgeMergedInputs);
            }
            vertexGroupsList.add(groupMap);
        }
        DAGUtils.putInto(dagMap, VERTEX_GROUPS_KEY, vertexGroupsList);
        return dagMap;
    }

    private static void putInto(Map<String, Object> map, String key, ArrayList<Object> list) {
        if (list.isEmpty()) {
            return;
        }
        map.put(key, list);
    }

    private static ArrayList<String> convertToStringArrayList(Collection<TezTaskID> collection) {
        ArrayList<String> list = new ArrayList<String>(collection.size());
        for (TezTaskID t : collection) {
            list.add(t.toString());
        }
        return list;
    }

    public static Map<String, Object> convertVertexStatsToATSMap(VertexStats vertexStats) {
        LinkedHashMap<String, Object> vertexStatsMap = new LinkedHashMap<String, Object>();
        if (vertexStats == null) {
            return vertexStatsMap;
        }
        String FIRST_TASK_START_TIME_KEY = "firstTaskStartTime";
        String FIRST_TASKS_TO_START_KEY = "firstTasksToStart";
        String LAST_TASK_FINISH_TIME_KEY = "lastTaskFinishTime";
        String LAST_TASKS_TO_FINISH_KEY = "lastTasksToFinish";
        String MIN_TASK_DURATION = "minTaskDuration";
        String MAX_TASK_DURATION = "maxTaskDuration";
        String AVG_TASK_DURATION = "avgTaskDuration";
        String SHORTEST_DURATION_TASKS = "shortestDurationTasks";
        String LONGEST_DURATION_TASKS = "longestDurationTasks";
        vertexStatsMap.put("firstTaskStartTime", vertexStats.getFirstTaskStartTime());
        if (vertexStats.getFirstTasksToStart() != null && !vertexStats.getFirstTasksToStart().isEmpty()) {
            vertexStatsMap.put("firstTasksToStart", DAGUtils.convertToStringArrayList(vertexStats.getFirstTasksToStart()));
        }
        vertexStatsMap.put("lastTaskFinishTime", vertexStats.getLastTaskFinishTime());
        if (vertexStats.getLastTasksToFinish() != null && !vertexStats.getLastTasksToFinish().isEmpty()) {
            vertexStatsMap.put("lastTasksToFinish", DAGUtils.convertToStringArrayList(vertexStats.getLastTasksToFinish()));
        }
        vertexStatsMap.put("minTaskDuration", vertexStats.getMinTaskDuration());
        vertexStatsMap.put("maxTaskDuration", vertexStats.getMaxTaskDuration());
        vertexStatsMap.put("avgTaskDuration", vertexStats.getAvgTaskDuration());
        if (vertexStats.getShortestDurationTasks() != null && !vertexStats.getShortestDurationTasks().isEmpty()) {
            vertexStatsMap.put("shortestDurationTasks", DAGUtils.convertToStringArrayList(vertexStats.getShortestDurationTasks()));
        }
        if (vertexStats.getLongestDurationTasks() != null && !vertexStats.getLongestDurationTasks().isEmpty()) {
            vertexStatsMap.put("longestDurationTasks", DAGUtils.convertToStringArrayList(vertexStats.getLongestDurationTasks()));
        }
        return vertexStatsMap;
    }
}

