/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.log4j.Logger;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.task.ErrorReporter;
import org.apache.tez.runtime.task.TaskReporter;

public class TezTaskRunner
implements TezUmbilical,
ErrorReporter {
    private static final Logger LOG = Logger.getLogger(TezTaskRunner.class);
    private final Configuration tezConf;
    private final LogicalIOProcessorRuntimeTask task;
    private final UserGroupInformation ugi;
    private final TaskReporter taskReporter;
    private final ListeningExecutorService executor;
    private volatile ListenableFuture<Void> taskFuture;
    private volatile Thread waitingThread;
    private volatile Throwable firstException;
    private final AtomicBoolean fatalErrorSent = new AtomicBoolean(false);
    private final AtomicBoolean taskRunning;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);

    TezTaskRunner(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, TezTaskUmbilicalProtocol umbilical, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Multimap<String, String> startedInputsMap, TaskReporter taskReporter, ListeningExecutorService executor, ObjectRegistry objectRegistry) throws IOException {
        this.tezConf = tezConf;
        this.ugi = ugi;
        this.taskReporter = taskReporter;
        this.executor = executor;
        this.task = new LogicalIOProcessorRuntimeTask(taskSpec, appAttemptNumber, tezConf, localDirs, (TezUmbilical)this, serviceConsumerMetadata, startedInputsMap, objectRegistry);
        taskReporter.registerTask(this.task, this);
        this.taskRunning = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() throws InterruptedException, IOException, TezException {
        this.waitingThread = Thread.currentThread();
        TaskRunnerCallable callable = new TaskRunnerCallable();
        Throwable failureCause = null;
        this.taskFuture = this.executor.submit((Callable)callable);
        try {
            this.taskFuture.get();
            failureCause = this.firstException;
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted while waiting for task to complete. Interrupting task");
            this.taskFuture.cancel(true);
            if (this.shutdownRequested.get()) {
                LOG.info((Object)"Shutdown requested... returning");
                boolean bl = false;
                return bl;
            }
            failureCause = this.firstException != null ? this.firstException : e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FSError) {
                failureCause = cause;
            } else {
                if (cause instanceof Error) {
                    LOG.error((Object)"Exception of type Error. Exiting now", cause);
                    ExitUtil.terminate((int)-1, (Throwable)cause);
                    assert (false);
                    boolean bl = false;
                    return bl;
                }
                failureCause = cause;
            }
        }
        finally {
            this.taskReporter.unregisterTask(this.task.getTaskAttemptID());
            Thread.interrupted();
        }
        if (failureCause != null) {
            if (failureCause instanceof FSError) {
                LOG.info((Object)("Encountered an FSError while executing task: " + this.task.getTaskAttemptID()), failureCause);
                throw (FSError)failureCause;
            }
            if (failureCause instanceof Error) {
                LOG.error((Object)"Exception of type Error. Exiting now", failureCause);
                ExitUtil.terminate((int)-1, (Throwable)failureCause);
                assert (false);
                return false;
            }
            if (failureCause instanceof IOException) {
                throw (IOException)failureCause;
            }
            if (failureCause instanceof TezException) {
                throw (TezException)failureCause;
            }
            if (failureCause instanceof InterruptedException) {
                throw (InterruptedException)failureCause;
            }
            throw new TezException(failureCause);
        }
        if (this.shutdownRequested.get()) {
            LOG.info((Object)"Shutdown requested... returning");
            return false;
        }
        return true;
    }

    private void sendFailure(Throwable t, String message) throws IOException, TezException {
        if (!this.fatalErrorSent.getAndSet(true)) {
            this.task.setFatalError(t, message);
            this.task.setFrameworkCounters();
            try {
                this.taskReporter.taskFailed(this.task.getTaskAttemptID(), t, message, null);
            }
            catch (IOException e) {
                LOG.warn((Object)"Heartbeat failure caused by communication failure", (Throwable)e);
                throw e;
            }
            catch (TezException e) {
                LOG.warn((Object)"Heartbeat failure reported by AM", (Throwable)e);
                throw e;
            }
        } else {
            LOG.warn((Object)"Ignoring fatal error since another error has already been reported", t);
        }
    }

    public void addEvents(Collection<TezEvent> events) {
        if (this.taskRunning.get()) {
            this.taskReporter.addEvents(this.task.getTaskAttemptID(), events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalFatalError(TezTaskAttemptID taskAttemptID, Throwable t, String message, EventMetaData sourceInfo) {
        if (!this.fatalErrorSent.getAndSet(true)) {
            this.maybeRegisterFirstException(t);
            try {
                this.taskReporter.taskFailed(taskAttemptID, t, this.getTaskDiagnosticsString(t, message), sourceInfo);
            }
            catch (IOException e) {
                LOG.warn((Object)"Heartbeat failure caused by communication failure", (Throwable)e);
            }
            catch (TezException e) {
                LOG.warn((Object)"Heartbeat failure reported by AM", (Throwable)e);
            }
            finally {
                this.waitingThread.interrupt();
            }
        }
    }

    public boolean canCommit(TezTaskAttemptID taskAttemptID) {
        if (this.taskRunning.get()) {
            try {
                return this.taskReporter.canCommit(taskAttemptID);
            }
            catch (IOException e) {
                LOG.warn((Object)"Communication failure while trying to commit", (Throwable)e);
                this.maybeRegisterFirstException(e);
                this.waitingThread.interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized void reportError(Throwable t) {
        if (t instanceof Error) {
            LOG.error((Object)"Exception of type Error during heartbeat, Exiting Now");
            ExitUtil.terminate((int)-1, (Throwable)t);
        } else if (this.taskRunning.get()) {
            LOG.error((Object)"TaskReporter reported error", t);
            this.maybeRegisterFirstException(t);
            this.waitingThread.interrupt();
        } else {
            LOG.info((Object)("Ignoring Communication failure since task with id=" + this.task.getTaskAttemptID() + " is already complete"));
        }
    }

    @Override
    public void shutdownRequested() {
        this.shutdownRequested.set(true);
        this.waitingThread.interrupt();
    }

    private String getTaskDiagnosticsString(Throwable t, String message) {
        String diagnostics = t != null && message != null ? "exceptionThrown=" + ExceptionUtils.getStackTrace((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "exceptionThrown=" + ExceptionUtils.getStackTrace((Throwable)t) : " errorMessage=" + message));
        return diagnostics;
    }

    private synchronized void maybeRegisterFirstException(Throwable t) {
        if (this.firstException == null) {
            this.firstException = t;
        }
    }

    private class TaskRunnerCallable
    implements Callable<Void> {
        private TaskRunnerCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                Void void_ = (Void)TezTaskRunner.this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void run() throws Exception {
                        block19: {
                            try {
                                LOG.info((Object)("Initializing task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID()));
                                TezTaskRunner.this.task.initialize();
                                if (!Thread.currentThread().isInterrupted() && TezTaskRunner.this.firstException == null) {
                                    LOG.info((Object)("Running task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID()));
                                    TezTaskRunner.this.task.run();
                                    LOG.info((Object)("Closing task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID()));
                                    TezTaskRunner.this.task.close();
                                    TezTaskRunner.this.task.setFrameworkCounters();
                                }
                                LOG.info((Object)("Task completed, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID() + ", fatalErrorOccurred=" + (TezTaskRunner.this.firstException != null)));
                                if (TezTaskRunner.this.firstException == null) {
                                    try {
                                        TezTaskRunner.this.taskReporter.taskSucceeded(TezTaskRunner.this.task.getTaskAttemptID());
                                    }
                                    catch (IOException e) {
                                        LOG.warn((Object)"Heartbeat failure caused by communication failure", (Throwable)e);
                                        TezTaskRunner.this.maybeRegisterFirstException(e);
                                    }
                                    catch (TezException e) {
                                        LOG.warn((Object)"Heartbeat failure reported by AM", (Throwable)e);
                                        TezTaskRunner.this.maybeRegisterFirstException(e);
                                    }
                                }
                                Void e = null;
                                return e;
                            }
                            catch (Throwable cause) {
                                if (cause instanceof FSError) {
                                    TezTaskRunner.this.maybeRegisterFirstException(cause);
                                    LOG.info((Object)("Encountered an FSError while executing task: " + TezTaskRunner.this.task.getTaskAttemptID()), cause);
                                    try {
                                        TezTaskRunner.this.sendFailure(cause, "FS Error in Child JVM");
                                    }
                                    catch (Exception ignored) {
                                        LOG.info((Object)"Ignoring the following exception since a previous exception is already registered", (Throwable)ignored);
                                    }
                                    throw (FSError)cause;
                                }
                                if (cause instanceof Error) {
                                    LOG.error((Object)"Exception of type Error. Exiting now", cause);
                                    ExitUtil.terminate((int)-1, (Throwable)cause);
                                    break block19;
                                }
                                if (cause instanceof UndeclaredThrowableException) {
                                    cause = ((UndeclaredThrowableException)cause).getCause();
                                }
                                TezTaskRunner.this.maybeRegisterFirstException(cause);
                                LOG.info((Object)("Encounted an error while executing task: " + TezTaskRunner.this.task.getTaskAttemptID()), cause);
                                try {
                                    TezTaskRunner.this.sendFailure(cause, "Failure while running task");
                                }
                                catch (Exception ignored) {
                                    LOG.info((Object)"Ignoring the following exception since a previous exception is already registered", (Throwable)ignored);
                                }
                                if (cause instanceof IOException) {
                                    throw (IOException)cause;
                                }
                                if (cause instanceof TezException) {
                                    throw (TezException)cause;
                                }
                                throw new TezException(cause);
                            }
                            finally {
                                TezTaskRunner.this.task.cleanup();
                            }
                        }
                        return null;
                    }
                });
                return void_;
            }
            finally {
                TezTaskRunner.this.taskRunning.set(false);
            }
        }
    }
}

