/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexInitializedEvent
implements HistoryEvent {
    private static final Log LOG = LogFactory.getLog(VertexInitializedEvent.class);
    private TezVertexID vertexID;
    private String vertexName;
    private long initRequestedTime;
    private long initedTime;
    private int numTasks;
    private String processorName;
    private Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> additionalInputs;

    public VertexInitializedEvent() {
    }

    public VertexInitializedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, int numTasks, String processorName, Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> additionalInputs) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.numTasks = numTasks;
        this.processorName = processorName;
        this.additionalInputs = additionalInputs;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_INITIALIZED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.vertexID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)this.vertexID.getDAGId().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", this.initedTime);
        initEvent.put("eventtype", (Object)HistoryEventType.VERTEX_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("vertexName", (Object)this.vertexName);
        otherInfo.put("initRequestedTime", this.initRequestedTime);
        otherInfo.put("initTime", this.initedTime);
        otherInfo.put("numTasks", this.numTasks);
        otherInfo.put("processorClassName", (Object)this.processorName);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexInitializedProto toProto() {
        RecoveryProtos.VertexInitializedProto.Builder builder = RecoveryProtos.VertexInitializedProto.newBuilder();
        if (this.additionalInputs != null && !this.additionalInputs.isEmpty()) {
            for (RootInputLeafOutputDescriptor<InputDescriptor> input : this.additionalInputs.values()) {
                DAGProtos.RootInputLeafOutputProto.Builder inputBuilder = DAGProtos.RootInputLeafOutputProto.newBuilder();
                inputBuilder.setName(input.getEntityName());
                if (input.getInitializerClassName() != null) {
                    inputBuilder.setInitializerClassName(input.getInitializerClassName());
                }
                inputBuilder.setEntityDescriptor(DagTypeConverters.convertToDAGPlan((TezEntityDescriptor)input.getDescriptor()));
                builder.addInputs(inputBuilder.build());
            }
        }
        return builder.setVertexId(this.vertexID.toString()).setVertexName(this.vertexName).setInitRequestedTime(this.initRequestedTime).setInitTime(this.initedTime).setNumTasks(this.numTasks).build();
    }

    public void fromProto(RecoveryProtos.VertexInitializedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.vertexName = proto.getVertexName();
        this.initRequestedTime = proto.getInitRequestedTime();
        this.initedTime = proto.getInitTime();
        this.numTasks = proto.getNumTasks();
        if (proto.getInputsCount() > 0) {
            this.additionalInputs = new LinkedHashMap<String, RootInputLeafOutputDescriptor<InputDescriptor>>();
            for (DAGProtos.RootInputLeafOutputProto inputProto : proto.getInputsList()) {
                RootInputLeafOutputDescriptor<InputDescriptor> input = new RootInputLeafOutputDescriptor<InputDescriptor>(inputProto.getName(), DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)inputProto.getEntityDescriptor()), inputProto.hasInitializerClassName() ? inputProto.getInitializerClassName() : null);
                this.additionalInputs.put(input.getEntityName(), input);
            }
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexInitializedProto proto = RecoveryProtos.VertexInitializedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", numTasks=" + this.numTasks + ", processorName=" + this.processorName + ", additionalInputsCount=" + (this.additionalInputs != null ? this.additionalInputs.size() : 0);
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public long getInitRequestedTime() {
        return this.initRequestedTime;
    }

    public long getInitedTime() {
        return this.initedTime;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> getAdditionalInputs() {
        return this.additionalInputs;
    }

    public String getProcessorName() {
        return this.processorName;
    }
}

