/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AMLaunchedEvent
implements HistoryEvent {
    private ApplicationAttemptId applicationAttemptId;
    private long launchTime;
    private long appSubmitTime;

    public AMLaunchedEvent() {
    }

    public AMLaunchedEvent(ApplicationAttemptId appAttemptId, long launchTime, long appSubmitTime) {
        this.applicationAttemptId = appAttemptId;
        this.launchTime = launchTime;
        this.appSubmitTime = appSubmitTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.AM_LAUNCHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + this.applicationAttemptId.toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)this.applicationAttemptId.getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)this.applicationAttemptId.toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", this.launchTime);
        initEvent.put("eventtype", (Object)HistoryEventType.AM_LAUNCHED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("appSubmitTime", this.appSubmitTime);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "appAttemptId=" + this.applicationAttemptId + ", appSubmitTime=" + this.appSubmitTime + ", launchTime=" + this.launchTime;
    }

    public RecoveryProtos.AMLaunchedProto toProto() {
        return RecoveryProtos.AMLaunchedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setAppSubmitTime(this.appSubmitTime).setLaunchTime(this.launchTime).build();
    }

    public void fromProto(RecoveryProtos.AMLaunchedProto proto) {
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
        this.launchTime = proto.getLaunchTime();
        this.appSubmitTime = proto.getAppSubmitTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.AMLaunchedProto proto = RecoveryProtos.AMLaunchedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public long getAppSubmitTime() {
        return this.appSubmitTime;
    }
}

