/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.history.avro.TaskAttemptStarted;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TaskAttemptStarted datum = new TaskAttemptStarted();
    private final String inProgressLogsUrl;
    private final String completedLogsUrl;

    public TaskAttemptStartedEvent(TezTaskAttemptID taId, String vertexName, long startTime, ContainerId containerId, NodeId nodeId, String inProgressLogsUrl, String completedLogsUrl) {
        this.datum.taskAttemptId = taId.toString();
        this.datum.vertexName = vertexName;
        this.datum.startTime = startTime;
        this.datum.containerId = containerId.toString();
        this.datum.nodeId = nodeId.toString();
        this.inProgressLogsUrl = inProgressLogsUrl;
        this.completedLogsUrl = completedLogsUrl;
    }

    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_STARTED;
    }

    public Object getBlob() {
        return this.toString();
    }

    public void setBlob(Object blob) {
        this.datum = (TaskAttemptStarted)((Object)blob);
    }

    public String toString() {
        return "vertexName=" + this.datum.vertexName + ", taskAttemptId=" + this.datum.taskAttemptId + ", startTime=" + this.datum.startTime + ", containerId=" + this.datum.containerId + ", nodeId=" + this.datum.nodeId + ", inProgressLogs=" + this.inProgressLogsUrl + ", completedLogs=" + this.completedLogsUrl;
    }
}

