/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.speculate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.speculate.StartEndTimesBase;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class ExponentiallySmoothedTaskRuntimeEstimator
extends StartEndTimesBase {
    private final ConcurrentMap<TezTaskAttemptID, AtomicReference<EstimateVector>> estimates = new ConcurrentHashMap<TezTaskAttemptID, AtomicReference<EstimateVector>>();
    private SmoothedValue smoothedValue;
    private long lambda;

    ExponentiallySmoothedTaskRuntimeEstimator(long lambda, SmoothedValue smoothedValue) {
        this.smoothedValue = smoothedValue;
        this.lambda = lambda;
    }

    public ExponentiallySmoothedTaskRuntimeEstimator() {
    }

    private void incorporateReading(TezTaskAttemptID attemptID, float newProgress, long newTime) {
        AtomicReference vectorRef = (AtomicReference)this.estimates.get(attemptID);
        if (vectorRef == null) {
            this.estimates.putIfAbsent(attemptID, new AtomicReference<Object>(null));
            this.incorporateReading(attemptID, newProgress, newTime);
            return;
        }
        EstimateVector oldVector = (EstimateVector)vectorRef.get();
        if (oldVector == null) {
            if (vectorRef.compareAndSet(null, new EstimateVector(-1.0, 0.0f, Long.MIN_VALUE))) {
                return;
            }
            this.incorporateReading(attemptID, newProgress, newTime);
            return;
        }
        while (!vectorRef.compareAndSet(oldVector, oldVector.incorporate(newProgress, newTime))) {
            oldVector = (EstimateVector)vectorRef.get();
        }
    }

    private EstimateVector getEstimateVector(TezTaskAttemptID attemptID) {
        AtomicReference vectorRef = (AtomicReference)this.estimates.get(attemptID);
        if (vectorRef == null) {
            return null;
        }
        return (EstimateVector)vectorRef.get();
    }

    public void contextualize(Configuration conf, AppContext context) {
        super.contextualize(conf, context);
        this.lambda = conf.getLong("yarn.app.mapreduce.am.job.task.estimator.exponential.smooth.lambda-ms", 60000L);
        this.smoothedValue = conf.getBoolean("yarn.app.mapreduce.am.job.task.estimator.exponential.smooth.rate", true) ? SmoothedValue.RATE : SmoothedValue.TIME_PER_UNIT_PROGRESS;
    }

    public long estimatedRuntime(TezTaskAttemptID id) {
        double rate;
        Long startTime = (Long)this.startTimes.get(id);
        if (startTime == null) {
            return -1L;
        }
        EstimateVector vector = this.getEstimateVector(id);
        if (vector == null) {
            return -1L;
        }
        long sunkTime = vector.atTime - startTime;
        double value = vector.value;
        float progress = vector.basedOnProgress;
        if (value == 0.0) {
            return -1L;
        }
        double d = rate = this.smoothedValue == SmoothedValue.RATE ? value : 1.0 / value;
        if (rate == 0.0) {
            return -1L;
        }
        double remainingTime = (1.0 - (double)progress) / rate;
        return sunkTime + (long)remainingTime;
    }

    public long runtimeEstimateVariance(TezTaskAttemptID id) {
        return -1L;
    }

    public void updateAttempt(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld status, long timestamp) {
        super.updateAttempt(status, timestamp);
        TezTaskAttemptID attemptID = status.id;
        float progress = status.progress;
        this.incorporateReading(attemptID, progress, timestamp);
    }

    private class EstimateVector {
        final double value;
        final float basedOnProgress;
        final long atTime;

        EstimateVector(double value, float basedOnProgress, long atTime) {
            this.value = value;
            this.basedOnProgress = basedOnProgress;
            this.atTime = atTime;
        }

        EstimateVector incorporate(float newProgress, long newAtTime) {
            if (newAtTime <= this.atTime || newProgress < this.basedOnProgress) {
                return this;
            }
            double oldWeighting = this.value < 0.0 ? 0.0 : Math.exp((double)(newAtTime - this.atTime) / (double)ExponentiallySmoothedTaskRuntimeEstimator.this.lambda);
            double newRead = (newProgress - this.basedOnProgress) / (float)(newAtTime - this.atTime);
            if (ExponentiallySmoothedTaskRuntimeEstimator.this.smoothedValue == SmoothedValue.TIME_PER_UNIT_PROGRESS) {
                newRead = 1.0 / newRead;
            }
            return new EstimateVector(this.value * oldWeighting + newRead * (1.0 - oldWeighting), newProgress, newAtTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SmoothedValue {
        RATE,
        TIME_PER_UNIT_PROGRESS;

    }
}

