/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.dag.event.DiagnosableEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.rm.AMSchedulerEventContainerCompleted;
import org.apache.tez.dag.app.rm.AMSchedulerEventDeallocateContainer;
import org.apache.tez.dag.app.rm.NMCommunicatorLaunchRequestEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorStopRequestEvent;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerHelpers;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TaskSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMContainerImpl
implements AMContainer {
    private static final Log LOG = LogFactory.getLog(AMContainerImpl.class);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final Container container;
    private final AppContext appContext;
    private final ContainerHeartbeatHandler containerHeartbeatHandler;
    private final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final List<TezTaskAttemptID> completedAttempts = new LinkedList<TezTaskAttemptID>();
    private final Map<TezTaskAttemptID, TaskSpec> remoteTaskMap = new HashMap<TezTaskAttemptID, TaskSpec>();
    private long idleTimeBetweenTasks = 0L;
    private long lastTaskFinishTime;
    private boolean nodeFailed = false;
    private String nodeFailedMessage;
    private TezTaskAttemptID pendingAttempt;
    private TezTaskAttemptID runningAttempt;
    private List<TezTaskAttemptID> failedAssignments;
    private TezTaskAttemptID pullAttempt;
    private AMContainerTask noAllocationContainerTask;
    private static final AMContainerTask NO_MORE_TASKS = new AMContainerTask(true, null);
    private static final AMContainerTask WAIT_TASK = new AMContainerTask(false, null);
    private boolean inError = false;
    private ContainerLaunchContext clc;
    private final StateMachine<AMContainerState, AMContainerEventType, AMContainerEvent> stateMachine;
    private static final StateMachineFactory<AMContainerImpl, AMContainerState, AMContainerEventType, AMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)AMContainerState.ALLOCATED).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.LAUNCHING, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new LaunchRequestTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTaskAttemptAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, EnumSet.of(AMContainerEventType.C_LAUNCHED, new AMContainerEventType[]{AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_PULL_TA, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT}), (SingleArcTransition)new ErrorTransition()).addTransition((Enum)AMContainerState.LAUNCHING, EnumSet.of(AMContainerState.LAUNCHING, AMContainerState.STOP_REQUESTED), (Enum)AMContainerEventType.C_ASSIGN_TA, (MultipleArcTransition)new AssignTaskAttemptTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.IDLE, (Enum)AMContainerEventType.C_LAUNCHED, (SingleArcTransition)new LaunchedTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_LAUNCH_FAILED, (SingleArcTransition)new LaunchFailedTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.LAUNCHING, (Enum)AMContainerEventType.C_PULL_TA).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT), (SingleArcTransition)new ErrorAtLaunchingTransition()).addTransition((Enum)AMContainerState.IDLE, EnumSet.of(AMContainerState.IDLE, AMContainerState.STOP_REQUESTED), (Enum)AMContainerEventType.C_ASSIGN_TA, (MultipleArcTransition)new AssignTaskAttemptAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, EnumSet.of(AMContainerState.RUNNING, AMContainerState.IDLE), (Enum)AMContainerEventType.C_PULL_TA, (MultipleArcTransition)new PullTAAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_TIMED_OUT, (SingleArcTransition)new TimedOutAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, new AMContainerEventType[]{AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED}), (SingleArcTransition)new ErrorAtIdleTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTaskAttemptAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.RUNNING, (Enum)AMContainerEventType.C_PULL_TA).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.IDLE, (Enum)AMContainerEventType.C_TA_SUCCEEDED, (SingleArcTransition)new TASucceededAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_TIMED_OUT, (SingleArcTransition)new TimedOutAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED), (SingleArcTransition)new ErrorAtRunningTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtWindDownTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_PULL_TA, (SingleArcTransition)new PullTAAfterStopTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtWindDownTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NM_STOP_SENT).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NM_STOP_FAILED, (SingleArcTransition)new NMStopRequestFailedTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtNMStopRequestedTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_TIMED_OUT)).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new ErrorAtNMStopRequestedTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtWindDownTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_PULL_TA, (SingleArcTransition)new PullTAAfterStopTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtWindDownTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedBaseTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, EnumSet.of(AMContainerEventType.C_LAUNCHED, new AMContainerEventType[]{AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT})).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new ErrorAtStoppingTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtCompletedTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_PULL_TA, (SingleArcTransition)new PullTAAfterStopTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedBaseTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, new AMContainerEventType[]{AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_COMPLETED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT})).installTopology();

    public AMContainerImpl(Container container, ContainerHeartbeatHandler chh, TaskAttemptListener tal, AppContext appContext) {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.container = container;
        this.containerId = container.getId();
        this.eventHandler = appContext.getEventHandler();
        this.appContext = appContext;
        this.containerHeartbeatHandler = chh;
        this.taskAttemptListener = tal;
        this.failedAssignments = new LinkedList<TezTaskAttemptID>();
        this.noAllocationContainerTask = WAIT_TASK;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMContainerState getState() {
        this.readLock.lock();
        try {
            AMContainerState aMContainerState = (AMContainerState)this.stateMachine.getCurrentState();
            return aMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TezTaskAttemptID> getAllTaskAttempts() {
        this.readLock.lock();
        try {
            LinkedList<TezTaskAttemptID> allAttempts = new LinkedList<TezTaskAttemptID>();
            allAttempts.addAll(this.completedAttempts);
            allAttempts.addAll(this.failedAssignments);
            if (this.pendingAttempt != null) {
                allAttempts.add(this.pendingAttempt);
            }
            if (this.runningAttempt != null) {
                allAttempts.add(this.runningAttempt);
            }
            LinkedList<TezTaskAttemptID> linkedList = allAttempts;
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TezTaskAttemptID> getQueuedTaskAttempts() {
        this.readLock.lock();
        try {
            if (this.pendingAttempt != null) {
                List<TezTaskAttemptID> list = Collections.singletonList(this.pendingAttempt);
                return list;
            }
            List<TezTaskAttemptID> list = Collections.emptyList();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezTaskAttemptID getRunningTaskAttempt() {
        this.readLock.lock();
        try {
            TezTaskAttemptID tezTaskAttemptID = this.runningAttempt;
            return tezTaskAttemptID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isInErrorState() {
        return this.inError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(AMContainerEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing AMContainerEvent " + event.getContainerId() + " of type " + event.getType() + " while in state: " + (Object)((Object)this.getState()) + ". Event: " + (Object)((Object)event)));
        }
        this.writeLock.lock();
        try {
            AMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle event " + event.getType() + " at current state " + (Object)((Object)oldState) + " for ContainerId " + this.containerId), (Throwable)e);
                this.inError = true;
            }
            if (oldState != this.getState()) {
                LOG.info((Object)("AMContainer " + this.containerId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()) + " via event " + event.getType()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMContainerTask pullTaskContext() {
        this.writeLock.lock();
        try {
            this.handle(new AMContainerEvent(this.containerId, AMContainerEventType.C_PULL_TA));
            if (this.pullAttempt == null) {
                AMContainerTask aMContainerTask = this.noAllocationContainerTask;
                return aMContainerTask;
            }
            AMContainerTask aMContainerTask = new AMContainerTask(false, this.remoteTaskMap.remove(this.pullAttempt));
            return aMContainerTask;
        }
        finally {
            this.pullAttempt = null;
            this.writeLock.unlock();
        }
    }

    private void handleExtraTAAssign(AMContainerEventAssignTA event, TezTaskAttemptID currentTaId) {
        this.inError = true;
        String errorMessage = "AMScheduler Error: Multiple simultaneous taskAttempt allocations to: " + this.getContainerId() + ". Attempts: " + currentTaId + ", " + event.getTaskAttemptId() + ". Current state: " + (Object)((Object)this.getState());
        this.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
        this.sendTerminatingToTaskAttempt(event.getTaskAttemptId(), errorMessage);
        this.sendTerminatingToTaskAttempt(currentTaId, errorMessage);
        this.registerFailedAttempt(event.getTaskAttemptId());
        LOG.warn((Object)errorMessage);
        this.sendStopRequestToNM();
        this.unregisterFromTAListener();
        this.unregisterFromContainerListener();
    }

    protected void registerFailedAttempt(TezTaskAttemptID taId) {
        this.failedAssignments.add(taId);
    }

    protected void deAllocate() {
        this.sendEvent((Event<?>)new AMSchedulerEventDeallocateContainer(this.containerId));
    }

    protected void sendCompletedToScheduler() {
        this.sendEvent((Event<?>)new AMSchedulerEventContainerCompleted(this.containerId));
    }

    protected void sendTerminatedToTaskAttempt(TezTaskAttemptID taId, String message) {
        this.sendEvent((Event<?>)new TaskAttemptEventContainerTerminated(taId, message));
    }

    protected void sendTerminatingToTaskAttempt(TezTaskAttemptID taId, String message) {
        this.sendEvent((Event<?>)new TaskAttemptEventContainerTerminating(taId, message));
    }

    protected void maybeSendNodeFailureForFailedAssignment(TezTaskAttemptID taId) {
        if (this.nodeFailed) {
            this.sendNodeFailureToTA(taId, this.nodeFailedMessage);
        }
    }

    protected void sendNodeFailureToTA(TezTaskAttemptID taId, String message) {
        this.sendEvent((Event<?>)new TaskAttemptEventNodeFailed(taId, message));
    }

    protected void sendStartRequestToNM() {
        this.sendEvent((Event<?>)new NMCommunicatorLaunchRequestEvent(this.clc, this.container));
    }

    protected void sendStopRequestToNM() {
        this.sendEvent((Event<?>)new NMCommunicatorStopRequestEvent(this.containerId, this.container.getNodeId(), this.container.getContainerToken()));
    }

    protected void unregisterAttemptFromListener(TezTaskAttemptID attemptId) {
        this.taskAttemptListener.unregisterTaskAttempt(attemptId);
    }

    protected void registerWithTAListener() {
        this.taskAttemptListener.registerRunningContainer(this.containerId);
    }

    protected void unregisterFromTAListener() {
        this.taskAttemptListener.unregisterRunningContainer(this.containerId);
    }

    protected void registerWithContainerListener() {
        this.containerHeartbeatHandler.register(this.containerId);
    }

    protected void unregisterFromContainerListener() {
        this.containerHeartbeatHandler.unregister(this.containerId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignTAAtCompletedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTAAtCompletedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.inError = true;
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            String errorMessage = "AttemptId: " + event.getTaskAttemptId() + " cannot be allocated to container: " + container.getContainerId() + " in COMPLETED state";
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatedToTaskAttempt(event.getTaskAttemptId(), errorMessage);
            container.registerFailedAttempt(event.getTaskAttemptId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ErrorBaseTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected ErrorBaseTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.inError = true;
        }
    }

    protected static class ErrorAtStoppingTransition
    extends ErrorBaseTransition {
        protected ErrorAtStoppingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.sendCompletedToScheduler();
        }
    }

    protected static class ErrorAtNMStopRequestedTransition
    extends ErrorBaseTransition {
        protected ErrorAtNMStopRequestedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
        }
    }

    protected static class NodeFailedAtNMStopRequestedTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtNMStopRequestedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NMStopRequestFailedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected NMStopRequestFailedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompletedAtWindDownTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtWindDownTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            String diag = event.getContainerStatus().getDiagnostics();
            for (TezTaskAttemptID taId : container.failedAssignments) {
                container.sendTerminatedToTaskAttempt(taId, diag);
            }
            if (container.pendingAttempt != null) {
                container.sendTerminatedToTaskAttempt(container.pendingAttempt, diag);
                container.registerFailedAttempt(container.pendingAttempt);
                container.pendingAttempt = null;
            }
            if (container.runningAttempt != null) {
                container.sendTerminatedToTaskAttempt(container.runningAttempt, diag);
                container.registerFailedAttempt(container.runningAttempt);
                container.runningAttempt = null;
            }
            if (diag != null && !diag.equals("")) {
                LOG.info((Object)("Container " + container.getContainerId() + " exited with diagnostics set to " + diag));
            }
            container.sendCompletedToScheduler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PullTAAfterStopTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected PullTAAfterStopTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.noAllocationContainerTask = NO_MORE_TASKS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignTAAtWindDownTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTAAtWindDownTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            container.inError = true;
            String errorMessage = "AttemptId: " + event.getTaskAttemptId() + " cannot be allocated to container: " + container.getContainerId() + " in " + (Object)((Object)container.getState()) + " state";
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatingToTaskAttempt(event.getTaskAttemptId(), errorMessage);
            container.registerFailedAttempt(event.getTaskAttemptId());
        }
    }

    protected static class ErrorAtRunningTransition
    extends ErrorAtIdleTransition {
        protected ErrorAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterAttemptFromListener(container.runningAttempt);
            container.sendTerminatingToTaskAttempt(container.runningAttempt, "Container " + container.getContainerId() + " hit an invalid transition - " + cEvent.getType() + " at " + (Object)((Object)container.getState()));
        }
    }

    protected static class NodeFailedAtRunningTransition
    extends NodeFailedAtIdleTransition {
        protected NodeFailedAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterAttemptFromListener(container.runningAttempt);
        }
    }

    protected static class TimedOutAtRunningTransition
    extends StopRequestAtRunningTransition {
        protected TimedOutAtRunningTransition() {
        }

        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " timed out";
        }
    }

    protected static class StopRequestAtRunningTransition
    extends StopRequestAtIdleTransition {
        protected StopRequestAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.unregisterAttemptFromListener(container.runningAttempt);
            container.sendTerminatingToTaskAttempt(container.runningAttempt, " Container" + container.getContainerId() + " received a STOP_REQUEST");
            super.transition(container, cEvent);
        }
    }

    protected static class CompletedAtRunningTransition
    extends CompletedAtIdleTransition {
        protected CompletedAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            container.sendTerminatedToTaskAttempt(container.runningAttempt, this.getMessage(container, event));
            container.unregisterAttemptFromListener(container.runningAttempt);
            container.registerFailedAttempt(container.runningAttempt);
            container.runningAttempt = null;
            super.transition(container, cEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TASucceededAtRunningTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected TASucceededAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.lastTaskFinishTime = System.currentTimeMillis();
            container.completedAttempts.add(container.runningAttempt);
            container.unregisterAttemptFromListener(container.runningAttempt);
            container.runningAttempt = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignTaskAttemptAtRunningTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTaskAttemptAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            container.unregisterAttemptFromListener(container.runningAttempt);
            container.handleExtraTAAssign(event, container.runningAttempt);
        }
    }

    protected static class ErrorAtIdleTransition
    extends ErrorAtLaunchingTransition {
        protected ErrorAtIdleTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class NodeFailedAtIdleTransition
    extends NodeFailedAtLaunchingTransition {
        protected NodeFailedAtIdleTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class TimedOutAtIdleTransition
    extends StopRequestAtIdleTransition {
        protected TimedOutAtIdleTransition() {
        }

        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " timed out";
        }
    }

    protected static class StopRequestAtIdleTransition
    extends StopRequestAtLaunchingTransition {
        protected StopRequestAtIdleTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class CompletedAtIdleTransition
    extends CompletedAtLaunchingTransition {
        protected CompletedAtIdleTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("TotalIdleTimeBetweenTasks for container: " + container.getContainerId() + " = " + container.idleTimeBetweenTasks));
            }
        }

        public String getMessage(AMContainerImpl container, AMContainerEventCompleted event) {
            return "Container " + container.getContainerId() + " COMPLETED" + " with diagnostics set to [" + event.getContainerStatus().getDiagnostics() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PullTAAtIdleTransition
    implements MultipleArcTransition<AMContainerImpl, AMContainerEvent, AMContainerState> {
        protected PullTAAtIdleTransition() {
        }

        public AMContainerState transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (container.pendingAttempt != null) {
                container.pullAttempt = container.pendingAttempt;
                container.runningAttempt = container.pendingAttempt;
                container.pendingAttempt = null;
                if (container.lastTaskFinishTime != 0L) {
                    long idleTimeDiff = System.currentTimeMillis() - container.lastTaskFinishTime;
                    container.idleTimeBetweenTasks += idleTimeDiff;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Computing idle time for container: " + container.getContainerId() + ", lastFinishTime: " + container.lastTaskFinishTime + ", Incremented by: " + idleTimeDiff));
                    }
                }
                LOG.info((Object)("Assigned taskAttempt + [" + container.runningAttempt + "] to container: [" + container.getContainerId() + "]"));
                return AMContainerState.RUNNING;
            }
            return AMContainerState.IDLE;
        }
    }

    protected static class AssignTaskAttemptAtIdleTransition
    extends AssignTaskAttemptTransition {
        protected AssignTaskAttemptAtIdleTransition() {
        }

        public AMContainerState transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AssignTAAtIdle: attempt: " + ((AMContainerEventAssignTA)cEvent).getRemoteTaskSpec()));
            }
            return super.transition(container, cEvent);
        }
    }

    protected static class ErrorAtLaunchingTransition
    extends ErrorBaseTransition {
        protected ErrorAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            if (container.pendingAttempt != null) {
                container.sendTerminatingToTaskAttempt(container.pendingAttempt, "Container " + container.getContainerId() + " hit an invalid transition - " + cEvent.getType() + " at " + (Object)((Object)container.getState()));
            }
            container.sendStopRequestToNM();
            container.unregisterFromTAListener();
        }
    }

    protected static class NodeFailedAtLaunchingTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromTAListener();
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NodeFailedBaseTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected NodeFailedBaseTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.nodeFailed = true;
            String errorMessage = null;
            if (cEvent instanceof DiagnosableEvent) {
                errorMessage = ((DiagnosableEvent)((Object)cEvent)).getDiagnosticInfo();
            }
            for (TezTaskAttemptID taId : container.failedAssignments) {
                container.sendNodeFailureToTA(taId, errorMessage);
            }
            for (TezTaskAttemptID taId : container.completedAttempts) {
                container.sendNodeFailureToTA(taId, errorMessage);
            }
            if (container.pendingAttempt != null) {
                container.sendNodeFailureToTA(container.pendingAttempt, errorMessage);
                container.sendTerminatingToTaskAttempt(container.pendingAttempt, "Node failure");
            }
            if (container.runningAttempt != null) {
                container.sendNodeFailureToTA(container.runningAttempt, errorMessage);
                container.sendTerminatingToTaskAttempt(container.runningAttempt, "Node failure");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StopRequestAtLaunchingTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected StopRequestAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (container.pendingAttempt != null) {
                container.sendTerminatingToTaskAttempt(container.pendingAttempt, this.getMessage(container, cEvent));
            }
            container.unregisterFromTAListener();
            container.sendStopRequestToNM();
        }

        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " received a STOP_REQUEST";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompletedAtLaunchingTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            if (container.pendingAttempt != null) {
                String errorMessage = this.getMessage(container, event);
                container.sendTerminatedToTaskAttempt(container.pendingAttempt, errorMessage);
                container.registerFailedAttempt(container.pendingAttempt);
                container.pendingAttempt = null;
                LOG.warn((Object)errorMessage);
            }
            container.unregisterFromTAListener();
            container.sendCompletedToScheduler();
            String diag = event.getContainerStatus().getDiagnostics();
            if (diag != null && !diag.equals("")) {
                LOG.info((Object)("Container " + container.getContainerId() + " exited with diagnostics set to " + diag));
            }
        }

        public String getMessage(AMContainerImpl container, AMContainerEventCompleted event) {
            return "Container" + container.getContainerId() + " COMPLETED while trying to launch. Diagnostics: [" + event.getContainerStatus().getDiagnostics() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LaunchFailedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected LaunchFailedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (container.pendingAttempt != null) {
                AMContainerEventLaunchFailed event = (AMContainerEventLaunchFailed)cEvent;
                container.sendTerminatingToTaskAttempt(container.pendingAttempt, event.getMessage());
            }
            container.unregisterFromTAListener();
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LaunchedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected LaunchedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.registerWithContainerListener();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignTaskAttemptTransition
    implements MultipleArcTransition<AMContainerImpl, AMContainerEvent, AMContainerState> {
        protected AssignTaskAttemptTransition() {
        }

        public AMContainerState transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            if (container.pendingAttempt != null) {
                container.handleExtraTAAssign(event, container.pendingAttempt);
                return AMContainerState.STOP_REQUESTED;
            }
            container.pendingAttempt = event.getTaskAttemptId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AssignTA: attempt: " + event.getRemoteTaskSpec()));
            }
            container.remoteTaskMap.put(event.getTaskAttemptId(), event.getRemoteTaskSpec());
            return container.getState();
        }
    }

    protected static class ErrorTransition
    extends ErrorBaseTransition {
        protected ErrorTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.sendCompletedToScheduler();
            container.deAllocate();
            LOG.info((Object)("Unexpected event type: " + cEvent.getType() + " while in state: " + (Object)((Object)container.getState()) + ". Event: " + (Object)((Object)cEvent)));
        }
    }

    protected static class NodeFailedAtAllocatedTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.sendCompletedToScheduler();
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StopRequestAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected StopRequestAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.nodeFailed = true;
            if (cEvent instanceof DiagnosableEvent) {
                container.nodeFailedMessage = ((DiagnosableEvent)((Object)cEvent)).getDiagnosticInfo();
            }
            container.sendCompletedToScheduler();
            container.deAllocate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompletedAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            container.sendCompletedToScheduler();
            String diag = event.getContainerStatus().getDiagnostics();
            if (diag != null && !diag.equals("")) {
                LOG.info((Object)("Container " + container.getContainerId() + " exited with diagnostics set to " + diag));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignTaskAttemptAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTaskAttemptAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            container.inError = true;
            container.registerFailedAttempt(event.getTaskAttemptId());
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatedToTaskAttempt(event.getTaskAttemptId(), "AMScheduler Error: TaskAttempt allocated to unlaunched container: " + container.getContainerId());
            container.sendCompletedToScheduler();
            container.deAllocate();
            LOG.warn((Object)("Unexpected TA Assignment: TAId: " + event.getTaskAttemptId() + "  for ContainerId: " + container.getContainerId() + " while in state: " + (Object)((Object)container.getState())));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LaunchRequestTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected LaunchRequestTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventLaunchRequest event = (AMContainerEventLaunchRequest)cEvent;
            ContainerContext containerContext = event.getContainerContext();
            container.clc = AMContainerHelpers.createContainerLaunchContext(container.appContext.getCurrentDAGID(), container.appContext.getApplicationACLs(), container.getContainerId(), containerContext.getLocalResources(), containerContext.getEnvironment(), containerContext.getJavaOpts(), container.taskAttemptListener, containerContext.getCredentials(), event.shouldProfile(), container.appContext);
            container.registerWithTAListener();
            container.sendStartRequestToNM();
            LOG.info((Object)("Sending Launch Request for Container with id: " + container.container.getId()));
            container.clc = null;
        }
    }
}

