/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.resources;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class InitialMemoryRequestContext {
    private long requestedSize;
    private String componentClassName;
    private ComponentType componentType;
    private String componentVertexName;

    public InitialMemoryRequestContext(long requestedSize, String componentClassName, ComponentType componentType, String componentVertexName) {
        Preconditions.checkNotNull((Object)componentClassName, (Object)"componentClassName is null");
        Preconditions.checkNotNull((Object)((Object)componentType), (Object)"componentType is null");
        Preconditions.checkNotNull((Object)componentVertexName, (Object)"componentVertexName is null");
        this.requestedSize = requestedSize;
        this.componentClassName = componentClassName;
        this.componentType = componentType;
        this.componentVertexName = componentVertexName;
    }

    public long getRequestedSize() {
        return this.requestedSize;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String getComponentVertexName() {
        return this.componentVertexName;
    }

    public static enum ComponentType {
        INPUT,
        OUTPUT,
        PROCESSOR;

    }
}

