/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.security;

import java.io.IOException;
import java.net.URL;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparator;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.shaded.com.google.common.base.Charsets;
import org.apache.tez.shaded.org.apache.commons.codec.binary.Base64;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SecureShuffleUtils {
    public static final String HTTP_HEADER_URL_HASH = "UrlHash";
    public static final String HTTP_HEADER_REPLY_URL_HASH = "ReplyHash";

    private SecureShuffleUtils() {
    }

    public static String generateHash(byte[] msg, SecretKey key) {
        return new String(Base64.encodeBase64(SecureShuffleUtils.generateByteHash(msg, key)), Charsets.UTF_8);
    }

    private static byte[] generateByteHash(byte[] msg, SecretKey key) {
        return JobTokenSecretManager.computeHash(msg, key);
    }

    private static boolean verifyHash(byte[] hash, byte[] msg, SecretKey key) {
        byte[] msg_hash = SecureShuffleUtils.generateByteHash(msg, key);
        return WritableComparator.compareBytes((byte[])msg_hash, (int)0, (int)msg_hash.length, (byte[])hash, (int)0, (int)hash.length) == 0;
    }

    private static boolean verifyHash(byte[] hash, byte[] msg, JobTokenSecretManager mgr) {
        byte[] msg_hash = mgr.computeHash(msg);
        return WritableComparator.compareBytes((byte[])msg_hash, (int)0, (int)msg_hash.length, (byte[])hash, (int)0, (int)hash.length) == 0;
    }

    public static String hashFromString(String encStr, JobTokenSecretManager mgr) {
        return new String(Base64.encodeBase64(mgr.computeHash(encStr.getBytes(Charsets.UTF_8))), Charsets.UTF_8);
    }

    public static void verifyReply(String base64Hash, String msg, SecretKey key) throws IOException {
        byte[] hash = Base64.decodeBase64(base64Hash.getBytes(Charsets.UTF_8));
        boolean res = SecureShuffleUtils.verifyHash(hash, msg.getBytes(Charsets.UTF_8), key);
        if (!res) {
            throw new IOException("Verification of the hashReply failed");
        }
    }

    public static void verifyReply(String base64Hash, String msg, JobTokenSecretManager mgr) throws IOException {
        byte[] hash = Base64.decodeBase64(base64Hash.getBytes(Charsets.UTF_8));
        boolean res = SecureShuffleUtils.verifyHash(hash, msg.getBytes(Charsets.UTF_8), mgr);
        if (!res) {
            throw new IOException("Verification of the hashReply failed");
        }
    }

    public static String buildMsgFrom(URL url) {
        return SecureShuffleUtils.buildMsgFrom(url.getPath(), url.getQuery(), url.getPort());
    }

    private static String buildMsgFrom(String uri_path, String uri_query, int port) {
        return port + uri_path + "?" + uri_query;
    }
}

