/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.records.DAGProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TezUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TezUtils.class);

    public static void addLog4jSystemProperties(String logLevel, List<String> vargs) {
        TezClientUtils.addLog4jSystemProperties(logLevel, vargs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteString createByteStringFromConf(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration must be specified");
        ByteString.Output os = ByteString.newOutput();
        try (DeflaterOutputStream compressOs = new DeflaterOutputStream((OutputStream)os, new Deflater(1));){
            TezUtils.writeConfInPB(compressOs, conf);
        }
        return os.toByteString();
    }

    public static UserPayload createUserPayloadFromConf(Configuration conf) throws IOException {
        return UserPayload.create(TezUtils.createByteStringFromConf(conf).asReadOnlyByteBuffer());
    }

    public static Configuration createConfFromByteString(ByteString byteString) throws IOException {
        Preconditions.checkNotNull((Object)byteString, (Object)"ByteString must be specified");
        InflaterInputStream uncompressIs = new InflaterInputStream(byteString.newInput());
        DAGProtos.ConfigurationProto confProto = DAGProtos.ConfigurationProto.parseFrom(uncompressIs);
        Configuration conf = new Configuration(false);
        TezUtils.readConfFromPB(confProto, conf);
        return conf;
    }

    public static Configuration createConfFromUserPayload(UserPayload payload) throws IOException {
        return TezUtils.createConfFromByteString(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
    }

    private static void writeConfInPB(OutputStream dos, Configuration conf) throws IOException {
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        for (Map.Entry entry : conf) {
            DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
            kvp.setKey((String)entry.getKey());
            kvp.setValue((String)entry.getValue());
            confProtoBuilder.addConfKeyValues(kvp);
        }
        DAGProtos.ConfigurationProto confProto = confProtoBuilder.build();
        confProto.writeTo(dos);
    }

    private static void readConfFromPB(DAGProtos.ConfigurationProto confProto, Configuration conf) {
        List<DAGProtos.PlanKeyValuePair> settingList = confProto.getConfKeyValuesList();
        for (DAGProtos.PlanKeyValuePair setting : settingList) {
            conf.set(setting.getKey(), setting.getValue());
        }
    }

    public static String convertToHistoryText(String description, Configuration conf) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (description != null && !description.isEmpty()) {
                jsonObject.put("desc", (Object)description);
            }
            if (conf != null) {
                JSONObject confJson = new JSONObject();
                for (Map.Entry entry : conf) {
                    confJson.put((String)entry.getKey(), (Object)conf.get((String)entry.getKey()));
                }
                jsonObject.put("config", (Object)confJson);
            }
        }
        catch (JSONException e) {
            throw new TezUncheckedException("Error when trying to convert description/conf to JSON", e);
        }
        return jsonObject.toString();
    }

    public static String convertToHistoryText(Configuration conf) {
        return TezUtils.convertToHistoryText(null, conf);
    }
}

