/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezYARNUtils;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Public
public class DAG {
    private static final Log LOG = LogFactory.getLog(DAG.class);
    final BidiMap<String, Vertex> vertices = new DualLinkedHashBidiMap();
    final Set<Edge> edges = Sets.newHashSet();
    final String name;
    final Collection<URI> urisForCredentials = new HashSet<URI>();
    Credentials credentials = new Credentials();
    Set<VertexGroup> vertexGroups = Sets.newHashSet();
    Set<GroupInputEdge> groupInputEdges = Sets.newHashSet();
    private DAGAccessControls dagAccessControls;
    Map<String, LocalResource> commonTaskLocalFiles = Maps.newHashMap();
    String dagInfo;
    private Stack<String> topologicalVertexStack = new Stack();

    private DAG(String name) {
        this.name = name;
    }

    public static DAG create(String name) {
        return new DAG(name);
    }

    public synchronized DAG addTaskLocalFiles(Map<String, LocalResource> localFiles) {
        Preconditions.checkNotNull(localFiles);
        TezCommonUtils.addAdditionalLocalResources(localFiles, this.commonTaskLocalFiles);
        return this;
    }

    public synchronized DAG addVertex(Vertex vertex) {
        if (this.vertices.containsKey((Object)vertex.getName())) {
            throw new IllegalStateException("Vertex " + vertex.getName() + " already defined!");
        }
        this.vertices.put((Object)vertex.getName(), (Object)vertex);
        return this;
    }

    public synchronized Vertex getVertex(String vertexName) {
        return (Vertex)this.vertices.get((Object)vertexName);
    }

    public synchronized DAG setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public synchronized DAG setDAGInfo(String dagInfo) {
        Preconditions.checkNotNull((Object)dagInfo);
        this.dagInfo = dagInfo;
        return this;
    }

    public synchronized VertexGroup createVertexGroup(String name, Vertex ... members) {
        VertexGroup uv = new VertexGroup(name, members);
        this.vertexGroups.add(uv);
        return uv;
    }

    @InterfaceAudience.Private
    public synchronized Credentials getCredentials() {
        return this.credentials;
    }

    public synchronized DAG setAccessControls(DAGAccessControls accessControls) {
        this.dagAccessControls = accessControls;
        return this;
    }

    public synchronized DAG addURIsForCredentials(Collection<URI> uris) {
        Preconditions.checkNotNull(uris, (Object)"URIs cannot be null");
        this.urisForCredentials.addAll(uris);
        return this;
    }

    @InterfaceAudience.Private
    public synchronized Collection<URI> getURIsForCredentials() {
        return Collections.unmodifiableCollection(this.urisForCredentials);
    }

    @InterfaceAudience.Private
    public synchronized Set<Vertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices.values());
    }

    public synchronized DAG addEdge(Edge edge) {
        if (!this.vertices.containsValue((Object)edge.getInputVertex())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertex() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        edge.getInputVertex().addOutputVertex(edge.getOutputVertex(), edge);
        edge.getOutputVertex().addInputVertex(edge.getInputVertex(), edge);
        this.edges.add(edge);
        return this;
    }

    public synchronized DAG addEdge(GroupInputEdge edge) {
        if (!this.vertexGroups.contains(edge.getInputVertexGroup())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertexGroup() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.groupInputEdges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        VertexGroup av = edge.getInputVertexGroup();
        av.addOutputVertex(edge.getOutputVertex(), edge);
        this.groupInputEdges.add(edge);
        LinkedList newEdges = Lists.newLinkedList();
        Vertex dstVertex = edge.getOutputVertex();
        VertexGroup uv = edge.getInputVertexGroup();
        for (Vertex member : uv.getMembers()) {
            newEdges.add(Edge.create(member, dstVertex, edge.getEdgeProperty()));
        }
        dstVertex.addGroupInput(uv.getGroupName(), uv.getGroupInfo());
        for (Edge e : newEdges) {
            this.addEdge(e);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Private
    public Map<String, LocalResource> getTaskLocalFiles() {
        return this.commonTaskLocalFiles;
    }

    void checkAndInferOneToOneParallelism() {
        HashSet newKnownTasksVertices = Sets.newHashSet();
        for (Vertex vertex : this.vertices.values()) {
            if (vertex.getParallelism() <= -1) continue;
            newKnownTasksVertices.add(vertex);
        }
        while (!newKnownTasksVertices.isEmpty()) {
            HashSet knownTasksVertices = Sets.newHashSet((Iterable)newKnownTasksVertices);
            newKnownTasksVertices.clear();
            for (Vertex v : knownTasksVertices) {
                for (Edge e : v.getOutputEdges()) {
                    Vertex outVertex;
                    if (e.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE || (outVertex = e.getOutputVertex()).getParallelism() != -1) continue;
                    LOG.info((Object)("Inferring parallelism for vertex: " + outVertex.getName() + " to be " + v.getParallelism() + " from 1-1 connection with vertex " + v.getName()));
                    outVertex.setParallelism(v.getParallelism());
                    newKnownTasksVertices.add(outVertex);
                }
            }
        }
        for (Edge e : this.edges) {
            Vertex inputVertex = e.getInputVertex();
            Vertex outputVertex = e.getOutputVertex();
            if (e.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE || inputVertex.getParallelism() == outputVertex.getParallelism() || outputVertex.getParallelism() == -1) continue;
            throw new TezUncheckedException("1-1 Edge. Destination vertex parallelism must match source vertex. Vertex: " + inputVertex.getName() + " does not match vertex: " + outputVertex.getName());
        }
    }

    @VisibleForTesting
    void verify() throws IllegalStateException {
        this.verify(true);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void verify(boolean restricted) throws IllegalStateException {
        Vertex vertex;
        if (this.vertices.isEmpty()) {
            throw new IllegalStateException("Invalid dag containing 0 vertices");
        }
        HashMap<String, AnnotatedVertex> vertexMap = new HashMap<String, AnnotatedVertex>();
        HashMap<Vertex, HashSet<String>> inboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        HashMap<Vertex, HashSet<String>> outboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        for (Vertex v : this.vertices.values()) {
            if (vertexMap.containsKey(v.getName())) {
                throw new IllegalStateException("DAG contains multiple vertices with name: " + v.getName());
            }
            vertexMap.put(v.getName(), new AnnotatedVertex(v));
        }
        HashMap<Vertex, List<Edge>> edgeMap = new HashMap<Vertex, List<Edge>>();
        for (Edge edge : this.edges) {
            void var10_25;
            Vertex inputVertex = edge.getInputVertex();
            Vertex vertex2 = edge.getOutputVertex();
            List list = (List)edgeMap.get(inputVertex);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                edgeMap.put(inputVertex, arrayList);
            }
            var10_25.add(edge);
            HashSet<String> inboundSet = (HashSet<String>)inboundVertexMap.get(vertex2);
            if (inboundSet == null) {
                inboundSet = new HashSet<String>();
                inboundVertexMap.put(vertex2, inboundSet);
            }
            inboundSet.add(inputVertex.getName());
            HashSet<String> outboundSet = (HashSet<String>)outboundVertexMap.get(inputVertex);
            if (outboundSet == null) {
                outboundSet = new HashSet<String>();
                outboundVertexMap.put(inputVertex, outboundSet);
            }
            outboundSet.add(vertex2.getName());
        }
        for (Vertex vertex3 : this.vertices.values()) {
            for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> rootInputLeafOutput : vertex3.getInputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getName() + " contains an Input with the same name as vertex: " + rootInputLeafOutput.getName());
            }
            for (RootInputLeafOutput<EntityDescriptor, EntityDescriptor> rootInputLeafOutput : vertex3.getOutputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getName() + " contains an Output with the same name as vertex: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : inboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getName() + " contains an incoming vertex and Input with the same name: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : outboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getName() + " contains an outgoing vertex and Output with the same name: " + rootInputLeafOutput.getName());
            }
        }
        this.detectCycles(edgeMap, vertexMap);
        this.checkAndInferOneToOneParallelism();
        if (restricted) {
            for (Edge edge : this.edges) {
                if (edge.getEdgeProperty().getDataSourceType() != EdgeProperty.DataSourceType.PERSISTED) {
                    throw new IllegalStateException("Unsupported source type on edge. " + edge);
                }
                if (edge.getEdgeProperty().getSchedulingType() == EdgeProperty.SchedulingType.SEQUENTIAL) continue;
                throw new IllegalStateException("Unsupported scheduling type on edge. " + edge);
            }
        }
    }

    private void detectCycles(Map<Vertex, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalStateException {
        Integer nextIndex = 0;
        Stack<AnnotatedVertex> stack = new Stack<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.empty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex);
        }
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<Vertex, List<Edge>> edgeMap, Stack<AnnotatedVertex> stack, Integer nextIndex) throws IllegalStateException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        Integer n2 = nextIndex = Integer.valueOf(nextIndex + 1);
        stack.push(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v);
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v)) {
                AnnotatedVertex outVertex = vertexMap.get(e.getOutputVertex().getName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.pop();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getName()).append(" <- ");
                while (pop != av) {
                    message.append(pop.v.getName()).append(" <- ");
                    pop.onstack = false;
                    pop = stack.pop();
                }
                message.append(av.v.getName());
                throw new IllegalStateException("DAG contains a cycle: " + message);
            }
            this.topologicalVertexStack.push(av.v.getName());
        }
    }

    @InterfaceAudience.Private
    public DAGProtos.DAGPlan createDag(Configuration dagConf, Credentials extraCredentials, Map<String, LocalResource> tezJarResources, LocalResource binaryConfig, boolean tezLrsAsArchive) {
        this.verify(true);
        DAGProtos.DAGPlan.Builder dagBuilder = DAGProtos.DAGPlan.newBuilder();
        dagBuilder.setName(this.name);
        if (this.dagInfo != null && !this.dagInfo.isEmpty()) {
            dagBuilder.setDagInfo(this.dagInfo);
        }
        if (!this.vertexGroups.isEmpty()) {
            for (VertexGroup av : this.vertexGroups) {
                VertexGroup.GroupInfo groupInfo = av.getGroupInfo();
                DAGProtos.PlanVertexGroupInfo.Builder groupBuilder = DAGProtos.PlanVertexGroupInfo.newBuilder();
                groupBuilder.setGroupName(groupInfo.getGroupName());
                for (Vertex vertex : groupInfo.getMembers()) {
                    groupBuilder.addGroupMembers(vertex.getName());
                }
                groupBuilder.addAllOutputs(groupInfo.outputs);
                for (Map.Entry entry : groupInfo.edgeMergedInputs.entrySet()) {
                    groupBuilder.addEdgeMergedInputs(DAGProtos.PlanGroupInputEdgeInfo.newBuilder().setDestVertexName((String)entry.getKey()).setMergedInput(DagTypeConverters.convertToDAGPlan((EntityDescriptor)entry.getValue())));
                }
                dagBuilder.addVertexGroups(groupBuilder);
            }
        }
        Credentials dagCredentials = new Credentials();
        if (extraCredentials != null) {
            dagCredentials.mergeAll(extraCredentials);
        }
        dagCredentials.mergeAll(this.credentials);
        if (!this.commonTaskLocalFiles.isEmpty()) {
            dagBuilder.addAllLocalResource(DagTypeConverters.convertToDAGPlan(this.commonTaskLocalFiles));
        }
        Preconditions.checkArgument((this.topologicalVertexStack.size() == this.vertices.size() ? 1 : 0) != 0, (Object)("size of topologicalVertexStack is:" + this.topologicalVertexStack.size() + " while size of vertices is:" + this.vertices.size() + ", make sure they are the same in order to sort the vertices"));
        while (!this.topologicalVertexStack.isEmpty()) {
            int n;
            Vertex vertex = (Vertex)this.vertices.get((Object)this.topologicalVertexStack.pop());
            Resource vertexTaskResource = vertex.getTaskResource();
            if (vertexTaskResource == null) {
                vertexTaskResource = Resource.newInstance((int)dagConf.getInt("tez.task.resource.memory.mb", 1024), (int)dagConf.getInt("tez.task.resource.cpu.vcores", 1));
            }
            HashMap vertexLRs = Maps.newHashMap();
            vertexLRs.putAll(vertex.getTaskLocalFiles());
            List<DataSourceDescriptor> dataSources = vertex.getDataSources();
            for (DataSourceDescriptor dataSource : dataSources) {
                if (dataSource.getCredentials() != null) {
                    dagCredentials.addAll(dataSource.getCredentials());
                }
                if (dataSource.getAdditionalLocalFiles() == null) continue;
                TezCommonUtils.addAdditionalLocalResources(dataSource.getAdditionalLocalFiles(), vertexLRs);
            }
            if (tezJarResources != null) {
                TezCommonUtils.addAdditionalLocalResources(tezJarResources, vertexLRs);
            }
            if (binaryConfig != null) {
                vertexLRs.put("tez-conf.pb", binaryConfig);
            }
            int n2 = vertex.getParallelism();
            VertexLocationHint vertexLocationHint = vertex.getLocationHint();
            if (dataSources.size() == 1) {
                DataSourceDescriptor dataSource = dataSources.get(0);
                if (n2 == -1 && dataSource.getNumberOfShards() > -1) {
                    n = dataSource.getNumberOfShards();
                }
                if (vertexLocationHint == null && dataSource.getLocationHint() != null) {
                    vertexLocationHint = dataSource.getLocationHint();
                }
            }
            if (n == -1) {
                Preconditions.checkState((vertexLocationHint == null ? 1 : 0) != 0, (Object)("Cannot specify vertex location hint without specifying vertex parallelism. Vertex: " + vertex.getName()));
            } else if (vertexLocationHint != null) {
                Preconditions.checkState((n == vertexLocationHint.getTaskLocationHints().size() ? 1 : 0) != 0, (Object)("vertex task location hint must equal vertex parallelism. Vertex: " + vertex.getName()));
            }
            for (DataSinkDescriptor dataSink : vertex.getDataSinks()) {
                if (dataSink.getCredentials() == null) continue;
                dagCredentials.addAll(dataSink.getCredentials());
            }
            DAGProtos.VertexPlan.Builder vertexBuilder = DAGProtos.VertexPlan.newBuilder();
            vertexBuilder.setName(vertex.getName());
            vertexBuilder.setType(DAGProtos.PlanVertexType.NORMAL);
            vertexBuilder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan(vertex.getProcessorDescriptor()));
            if (vertex.getInputs().size() > 0) {
                for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                    vertexBuilder.addInputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            if (vertex.getOutputs().size() > 0) {
                for (RootInputLeafOutput<EntityDescriptor, EntityDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                    vertexBuilder.addOutputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            DAGProtos.PlanTaskConfiguration.Builder taskConfigBuilder = DAGProtos.PlanTaskConfiguration.newBuilder();
            taskConfigBuilder.setNumTasks(n);
            taskConfigBuilder.setMemoryMb(vertexTaskResource.getMemory());
            taskConfigBuilder.setVirtualCores(vertexTaskResource.getVirtualCores());
            taskConfigBuilder.setJavaOpts(TezClientUtils.addDefaultsToTaskLaunchCmdOpts(vertex.getTaskLaunchCmdOpts(), dagConf));
            taskConfigBuilder.setTaskModule(vertex.getName());
            if (!vertexLRs.isEmpty()) {
                taskConfigBuilder.addAllLocalResource(DagTypeConverters.convertToDAGPlan(vertexLRs));
            }
            HashMap hashMap = Maps.newHashMap(vertex.getTaskEnvironment());
            TezYARNUtils.setupDefaultEnv(hashMap, dagConf, "tez.task.launch.env", TezConfiguration.TEZ_TASK_LAUNCH_ENV_DEFAULT, tezLrsAsArchive);
            for (Map.Entry entry : hashMap.entrySet()) {
                DAGProtos.PlanKeyValuePair.Builder envSettingBuilder = DAGProtos.PlanKeyValuePair.newBuilder();
                envSettingBuilder.setKey((String)entry.getKey());
                envSettingBuilder.setValue((String)entry.getValue());
                taskConfigBuilder.addEnvironmentSetting(envSettingBuilder);
            }
            if (vertexLocationHint != null && vertexLocationHint.getTaskLocationHints() != null) {
                for (TaskLocationHint hint : vertexLocationHint.getTaskLocationHints()) {
                    DAGProtos.PlanTaskLocationHint.Builder taskLocationHintBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                    if (hint.getAffinitizedTask() != null) {
                        throw new TezUncheckedException("Task based affinity may not be specified via the DAG API");
                    }
                    if (hint.getHosts() != null) {
                        taskLocationHintBuilder.addAllHost(hint.getHosts());
                    }
                    if (hint.getRacks() != null) {
                        taskLocationHintBuilder.addAllRack(hint.getRacks());
                    }
                    vertexBuilder.addTaskLocationHint(taskLocationHintBuilder);
                }
            }
            if (vertex.getVertexManagerPlugin() != null) {
                vertexBuilder.setVertexManagerPlugin(DagTypeConverters.convertToDAGPlan(vertex.getVertexManagerPlugin()));
            }
            for (Edge inEdge : vertex.getInputEdges()) {
                vertexBuilder.addInEdgeId(inEdge.getId());
            }
            for (Edge outEdge : vertex.getOutputEdges()) {
                vertexBuilder.addOutEdgeId(outEdge.getId());
            }
            vertexBuilder.setTaskConfig(taskConfigBuilder);
            dagBuilder.addVertex(vertexBuilder);
        }
        for (Edge edge : this.edges) {
            DAGProtos.EdgePlan.Builder edgeBuilder = DAGProtos.EdgePlan.newBuilder();
            edgeBuilder.setId(edge.getId());
            edgeBuilder.setInputVertexName(edge.getInputVertex().getName());
            edgeBuilder.setOutputVertexName(edge.getOutputVertex().getName());
            edgeBuilder.setDataMovementType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataMovementType()));
            edgeBuilder.setDataSourceType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataSourceType()));
            edgeBuilder.setSchedulingType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getSchedulingType()));
            edgeBuilder.setEdgeSource(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeSource()));
            edgeBuilder.setEdgeDestination(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeDestination()));
            if (edge.getEdgeProperty().getDataMovementType() == EdgeProperty.DataMovementType.CUSTOM && edge.getEdgeProperty().getEdgeManagerDescriptor() != null) {
                edgeBuilder.setEdgeManager(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeManagerDescriptor()));
            }
            dagBuilder.addEdge(edgeBuilder);
        }
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        if (dagConf != null) {
            for (Map.Entry entry : dagConf) {
                DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey((String)entry.getKey());
                kvp.setValue((String)entry.getValue());
                confProtoBuilder.addConfKeyValues(kvp);
            }
        }
        if (this.dagAccessControls != null) {
            Configuration aclConf = new Configuration(false);
            this.dagAccessControls.serializeToConfiguration(aclConf);
            for (Map.Entry entry : aclConf) {
                DAGProtos.PlanKeyValuePair.Builder builder = DAGProtos.PlanKeyValuePair.newBuilder();
                builder.setKey((String)entry.getKey());
                builder.setValue((String)entry.getValue());
                confProtoBuilder.addConfKeyValues(builder);
            }
        }
        dagBuilder.setDagKeyValues(confProtoBuilder);
        if (dagCredentials != null) {
            dagBuilder.setCredentialsBinary(DagTypeConverters.convertCredentialsToProto(dagCredentials));
            TezCommonUtils.logCredentials(LOG, dagCredentials, "dag");
        }
        return dagBuilder.build();
    }

    private static class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
        }
    }
}

