/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.InputReadyCallback;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.TezInputContext;

public abstract class MergedLogicalInput
implements LogicalInput {
    private volatile InputReadyCallback inputReadyCallback;
    private AtomicBoolean notifiedInputReady = new AtomicBoolean(false);
    private List<Input> inputs;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public final void initialize(List<Input> inputs) {
        this.inputs = Collections.unmodifiableList(inputs);
    }

    public final List<Input> getInputs() {
        return this.inputs;
    }

    @Override
    public final List<Event> initialize(TezInputContext inputContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void start() throws Exception {
        if (!this.isStarted.getAndSet(true)) {
            for (Input input : this.inputs) {
                input.start();
            }
        }
    }

    @Override
    public final void handleEvents(List<Event> inputEvents) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public final List<Event> close() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setNumPhysicalInputs(int numInputs) {
        throw new UnsupportedOperationException();
    }

    public void setInputReadyCallback(InputReadyCallback callback) {
        this.inputReadyCallback = callback;
    }

    protected final void informInputReady() {
        if (!this.notifiedInputReady.getAndSet(true)) {
            this.inputReadyCallback.setInputReady(this);
        }
    }

    public abstract void setConstituentInputIsReady(Input var1);
}

