/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.counters.AbstractCounterGroup;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.CounterGroupBase;
import org.apache.tez.common.counters.CounterGroupFactory;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.FileSystemCounterGroup;
import org.apache.tez.common.counters.FrameworkCounterGroup;
import org.apache.tez.common.counters.GenericCounter;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.counters.TezCounter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezCounters
extends AbstractCounters<TezCounter, CounterGroup> {
    private static final GroupFactory groupFactory = new GroupFactory();

    public TezCounters() {
        super(groupFactory);
    }

    public <C extends TezCounter, G extends CounterGroupBase<C>> TezCounters(AbstractCounters<C, G> counters) {
        super(counters, groupFactory);
    }

    private static class GroupFactory
    extends CounterGroupFactory<TezCounter, CounterGroup> {
        private GroupFactory() {
        }

        @Override
        protected <T extends Enum<T>> CounterGroupFactory.FrameworkGroupFactory<CounterGroup> newFrameworkGroupFactory(final Class<T> cls) {
            return new CounterGroupFactory.FrameworkGroupFactory<CounterGroup>(){

                @Override
                public CounterGroup newGroup(String name) {
                    return new FrameworkGroupImpl(cls);
                }
            };
        }

        @Override
        protected CounterGroup newGenericGroup(String name, String displayName, Limits limits) {
            return new GenericGroup(name, displayName, limits);
        }

        @Override
        protected CounterGroup newFileSystemGroup() {
            return new FileSystemGroup();
        }
    }

    private static class FileSystemGroup
    extends FileSystemCounterGroup<TezCounter>
    implements CounterGroup {
        private FileSystemGroup() {
        }

        @Override
        protected TezCounter newCounter(String scheme, FileSystemCounter key) {
            return new FileSystemCounterGroup.FSCounter(scheme, key);
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class GenericGroup
    extends AbstractCounterGroup<TezCounter>
    implements CounterGroup {
        GenericGroup(String name, String displayName, Limits limits) {
            super(name, displayName, limits);
        }

        @Override
        protected TezCounter newCounter(String name, String displayName, long value) {
            return new GenericCounter(name, displayName, value);
        }

        @Override
        protected TezCounter newCounter() {
            return new GenericCounter();
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class FrameworkGroupImpl<T extends Enum<T>>
    extends FrameworkCounterGroup<T, TezCounter>
    implements CounterGroup {
        FrameworkGroupImpl(Class<T> cls) {
            super(cls);
        }

        @Override
        protected FrameworkCounterGroup.FrameworkCounter<T> newCounter(T key) {
            return new FrameworkCounterGroup.FrameworkCounter<T>(key, this.getName());
        }

        @Override
        public CounterGroupBase<TezCounter> getUnderlyingGroup() {
            return this;
        }
    }
}

