/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundles {
    public static ResourceBundle getBundle(String bundleName) {
        return ResourceBundle.getBundle(bundleName.replace('$', '_'), Locale.getDefault(), Thread.currentThread().getContextClassLoader());
    }

    public static synchronized <T> T getValue(String bundleName, String key, String suffix, T defaultValue) {
        try {
            ResourceBundle bundle = ResourceBundles.getBundle(bundleName);
            Object value = bundle.getObject(ResourceBundles.getLookupKey(key, suffix));
            if (value != null) {
                return (T)value;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return defaultValue;
    }

    private static String getLookupKey(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        return key + suffix;
    }

    public static String getCounterGroupName(String group, String defaultValue) {
        return ResourceBundles.getValue(group, "CounterGroupName", "", defaultValue);
    }

    public static String getCounterName(String group, String counter, String defaultValue) {
        return ResourceBundles.getValue(group, counter, ".name", defaultValue);
    }
}

