/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.LimitExceededException;

@InterfaceAudience.Private
public class Limits {
    private static Configuration conf = null;
    private static int GROUP_NAME_MAX;
    private static int COUNTER_NAME_MAX;
    private static int GROUPS_MAX;
    private static int COUNTERS_MAX;
    private static boolean initialized;
    private int totalCounters;
    private LimitExceededException firstViolation;

    private static synchronized void ensureInitialized() {
        if (initialized) {
            return;
        }
        if (conf == null) {
            conf = new Configuration();
        }
        GROUP_NAME_MAX = conf.getInt("tez.runtime.job.counters.group.name.max", 128);
        COUNTER_NAME_MAX = conf.getInt("tez.runtime.job.counters.counter.name.max", 64);
        GROUPS_MAX = conf.getInt("tez.runtime.job.counters.groups.max", 50);
        COUNTERS_MAX = conf.getInt("tez.runtime.job.counters.max", 120);
        initialized = true;
    }

    public static String filterName(String name, int maxLen) {
        return name.length() > maxLen ? name.substring(0, maxLen - 1) : name;
    }

    public static String filterCounterName(String name) {
        Limits.ensureInitialized();
        return Limits.filterName(name, COUNTER_NAME_MAX);
    }

    public static String filterGroupName(String name) {
        Limits.ensureInitialized();
        return Limits.filterName(name, GROUP_NAME_MAX);
    }

    public synchronized void checkCounters(int size) {
        Limits.ensureInitialized();
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        if (size > COUNTERS_MAX) {
            this.firstViolation = new LimitExceededException("Too many counters: " + size + " max=" + COUNTERS_MAX);
            throw this.firstViolation;
        }
    }

    public synchronized void incrCounters() {
        this.checkCounters(this.totalCounters + 1);
        ++this.totalCounters;
    }

    public synchronized void checkGroups(int size) {
        Limits.ensureInitialized();
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        if (size > GROUPS_MAX) {
            this.firstViolation = new LimitExceededException("Too many counter groups: " + size + " max=" + GROUPS_MAX);
        }
    }

    public synchronized LimitExceededException violation() {
        return this.firstViolation;
    }

    public static synchronized void setConfiguration(Configuration conf) {
        if (Limits.conf == null && conf != null) {
            Limits.conf = conf;
        }
    }

    static {
        initialized = false;
    }
}

