/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.dag.api.TezConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezSessionConfiguration {
    private final AMConfiguration amConfiguration;
    private final YarnConfiguration yarnConfig;
    private final TezConfiguration tezConfig;
    private final Map<String, LocalResource> sessionResources;

    public TezSessionConfiguration(AMConfiguration amConfiguration, TezConfiguration tezConfig) {
        this(amConfiguration, tezConfig, new YarnConfiguration((Configuration)tezConfig));
    }

    TezSessionConfiguration(AMConfiguration amConfiguration, TezConfiguration tezConfig, YarnConfiguration yarnConf) {
        this(amConfiguration, tezConfig, yarnConf, new TreeMap<String, LocalResource>());
    }

    TezSessionConfiguration(AMConfiguration amConfiguration, TezConfiguration tezConfig, YarnConfiguration yarnConf, Map<String, LocalResource> sessionResources) {
        this.amConfiguration = amConfiguration;
        this.tezConfig = tezConfig;
        this.yarnConfig = yarnConf;
        this.sessionResources = sessionResources;
    }

    public AMConfiguration getAMConfiguration() {
        return this.amConfiguration;
    }

    public YarnConfiguration getYarnConfiguration() {
        return this.yarnConfig;
    }

    public TezConfiguration getTezConfiguration() {
        return this.tezConfig;
    }

    public Map<String, LocalResource> getSessionResources() {
        return Collections.unmodifiableMap(this.sessionResources);
    }
}

