/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.records.DAGProtos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezClientUtils {
    private static Log LOG = LogFactory.getLog(TezClientUtils.class);
    public static final FsPermission TEZ_AM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission TEZ_AM_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    private static final int UTF8_CHUNK_SIZE = 16384;

    static Map<String, LocalResource> setupTezJarsLocalResources(TezConfiguration conf) throws IOException {
        TreeMap<String, LocalResource> tezJarResources = new TreeMap<String, LocalResource>();
        String[] tezJarUris = conf.getStrings("tez.lib.uris");
        if (tezJarUris == null || tezJarUris.length == 0) {
            throw new TezUncheckedException("Invalid configuration of tez jars, tez.lib.uris is not defined in the configurartion");
        }
        for (String tezJarUri : tezJarUris) {
            URI uri;
            try {
                uri = new URI(tezJarUri.trim());
            }
            catch (URISyntaxException e) {
                String message = "Invalid URI defined in configuration for location of TEZ jars. providedURI=" + tezJarUri;
                LOG.error((Object)message);
                throw new TezUncheckedException(message, e);
            }
            if (!uri.isAbsolute()) {
                String message = "Non-absolute URI defined in configuration for location of TEZ jars. providedURI=" + tezJarUri;
                LOG.error((Object)message);
                throw new TezUncheckedException(message);
            }
            Path p = new Path(uri);
            FileSystem pathfs = p.getFileSystem((Configuration)conf);
            RemoteIterator iter = pathfs.listFiles(p, false);
            while (iter.hasNext()) {
                LocatedFileStatus fStatus = (LocatedFileStatus)iter.next();
                String rsrcName = fStatus.getPath().getName();
                if (tezJarResources.containsKey(rsrcName)) {
                    String message = "Duplicate resource found, resourceName=" + rsrcName + ", existingPath=" + ((LocalResource)tezJarResources.get(rsrcName)).getResource().toString() + ", newPath=" + fStatus.getPath();
                    LOG.warn((Object)message);
                }
                tezJarResources.put(rsrcName, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)fStatus.getPath()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)fStatus.getLen(), (long)fStatus.getModificationTime()));
            }
        }
        if (tezJarResources.isEmpty()) {
            LOG.warn((Object)"No tez jars found in configured locations. Ignoring for now. Errors may occur");
        }
        return tezJarResources;
    }

    public static FileSystem ensureStagingDirExists(Configuration conf, Path stagingArea) throws IOException {
        FileSystem fs = stagingArea.getFileSystem(conf);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        String realUser = ugi.getShortUserName();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (fs.exists(stagingArea)) {
            FileStatus fsStatus = fs.getFileStatus(stagingArea);
            String owner = fsStatus.getOwner();
            if (!owner.equals(currentUser) && !owner.equals(realUser)) {
                throw new IOException("The ownership on the staging directory " + stagingArea + " is not as expected. " + "It is owned by " + owner + ". The directory must " + "be owned by the submitter " + currentUser + " or " + "by " + realUser);
            }
            if (!fsStatus.getPermission().equals((Object)TEZ_AM_DIR_PERMISSION)) {
                LOG.info((Object)("Permissions on staging directory " + stagingArea + " are " + "incorrect: " + fsStatus.getPermission() + ". Fixing permissions " + "to correct value " + TEZ_AM_DIR_PERMISSION));
                fs.setPermission(stagingArea, TEZ_AM_DIR_PERMISSION);
            }
        } else {
            fs.mkdirs(stagingArea, new FsPermission(TEZ_AM_DIR_PERMISSION));
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ApplicationSubmissionContext createApplicationSubmissionContext(TezConfiguration conf, ApplicationId appId, DAG dag, String amName, AMConfiguration amConfig, Map<String, LocalResource> tezJarResources) throws IOException, YarnException {
        Path sessionJarsPath;
        LocalResource binaryConfLRsrc;
        TreeMap<String, LocalResource> localResources;
        Map<String, String> environment;
        Vector<String> vargsFinal;
        String amLogLevel;
        ByteBuffer securityTokens;
        Resource capability;
        FileSystem fs;
        block27: {
            Path binaryConfPath;
            block26: {
                fs = TezClientUtils.ensureStagingDirExists(conf, amConfig.getStagingDir());
                capability = (Resource)Records.newRecord(Resource.class);
                capability.setMemory(amConfig.getAMConf().getInt("tez.am.resource.memory.mb", 1536));
                capability.setVirtualCores(amConfig.getAMConf().getInt("tez.am.resource.cpu.vcores", 1));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("AppMaster capability = " + capability));
                }
                securityTokens = null;
                if (amConfig.getCredentials() != null) {
                    DataOutputBuffer dob = new DataOutputBuffer();
                    amConfig.getCredentials().writeTokenStorageToStream((DataOutputStream)dob);
                    securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
                }
                ArrayList<String> vargs = new ArrayList<String>(8);
                vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
                amLogLevel = amConfig.getAMConf().get("tez.am.log.level", "INFO");
                TezClientUtils.addLog4jSystemProperties(amLogLevel, vargs);
                vargs.add(amConfig.getAMConf().get("tez.am.java.opts", " -Xmx1024m "));
                vargs.add("-Dsun.nio.ch.bugLevel=''");
                vargs.add("org.apache.tez.dag.app.DAGAppMaster");
                if (dag == null) {
                    vargs.add("--session");
                }
                vargs.add("1><LOG_DIR>" + File.separator + "stdout");
                vargs.add("2><LOG_DIR>" + File.separator + "stderr");
                vargsFinal = new Vector<String>(8);
                StringBuilder mergedCommand = new StringBuilder();
                for (String str : vargs) {
                    mergedCommand.append((CharSequence)str).append(" ");
                }
                vargsFinal.add(mergedCommand.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Command to launch container for ApplicationMaster is : " + mergedCommand));
                }
                environment = TezClientUtils.createEnvironment(conf);
                if (amConfig.getEnv() != null) {
                    for (Map.Entry<String, String> entry : amConfig.getEnv().entrySet()) {
                        Apps.addToEnvironment(environment, (String)entry.getKey(), (String)entry.getValue());
                    }
                }
                localResources = new TreeMap<String, LocalResource>();
                if (amConfig.getLocalResources() != null) {
                    localResources.putAll(amConfig.getLocalResources());
                }
                localResources.putAll(tezJarResources);
                Configuration finalTezConf = TezClientUtils.createFinalTezConfForApp(conf, amConfig.getAMConf());
                binaryConfPath = new Path(amConfig.getStagingDir(), "tez-conf.pb." + appId.toString());
                FSDataOutputStream amConfPBOutBinaryStream = null;
                try {
                    DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
                    for (Map.Entry entry : finalTezConf) {
                        DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                        kvp.setKey((String)entry.getKey());
                        kvp.setValue((String)entry.getValue());
                        confProtoBuilder.addConfKeyValues(kvp);
                    }
                    amConfPBOutBinaryStream = FileSystem.create((FileSystem)fs, (Path)binaryConfPath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
                    confProtoBuilder.build().writeTo((OutputStream)amConfPBOutBinaryStream);
                    Object var23_22 = null;
                    if (amConfPBOutBinaryStream == null) break block26;
                }
                catch (Throwable throwable) {
                    Object var23_23 = null;
                    if (amConfPBOutBinaryStream != null) {
                        amConfPBOutBinaryStream.close();
                    }
                    throw throwable;
                }
                amConfPBOutBinaryStream.close();
            }
            binaryConfLRsrc = TezClientUtils.createLocalResource(fs, binaryConfPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
            localResources.put("tez-conf.pb", binaryConfLRsrc);
            sessionJarsPath = new Path(amConfig.getStagingDir(), "tez.session.local-resources.pb.file-name." + appId.toString());
            FSDataOutputStream sessionJarsPBOutStream = null;
            try {
                HashMap<String, LocalResource> sessionJars = new HashMap<String, LocalResource>(tezJarResources.size() + 1);
                sessionJars.putAll(tezJarResources);
                sessionJars.put("tez-conf.pb", binaryConfLRsrc);
                DAGProtos.PlanLocalResourcesProto proto = DagTypeConverters.convertFromLocalResources(sessionJars);
                sessionJarsPBOutStream = FileSystem.create((FileSystem)fs, (Path)sessionJarsPath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
                proto.writeTo((OutputStream)sessionJarsPBOutStream);
                Object var25_26 = null;
                if (sessionJarsPBOutStream == null) break block27;
            }
            catch (Throwable throwable) {
                Object var25_27 = null;
                if (sessionJarsPBOutStream != null) {
                    sessionJarsPBOutStream.close();
                }
                throw throwable;
            }
            sessionJarsPBOutStream.close();
        }
        LocalResource sessionJarsPBLRsrc = TezClientUtils.createLocalResource(fs, sessionJarsPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
        localResources.put("tez.session.local-resources.pb.file-name", sessionJarsPBLRsrc);
        if (dag != null) {
            DAGProtos.DAGPlan dagPB;
            Path binaryPath;
            block28: {
                for (Vertex v : dag.getVertices()) {
                    if (v.getTaskLocalResources() == null) {
                        v.setTaskLocalResources(new TreeMap<String, LocalResource>());
                    }
                    if (tezJarResources != null) {
                        v.getTaskLocalResources().putAll(tezJarResources);
                    }
                    v.getTaskLocalResources().put("tez-conf.pb", binaryConfLRsrc);
                    if (v.getTaskEnvironment() == null) {
                        v.setTaskEnvironment(new TreeMap<String, String>());
                    }
                    Map<String, String> taskEnv = v.getTaskEnvironment();
                    for (Map.Entry<String, String> entry : environment.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (taskEnv.containsKey(key)) continue;
                        taskEnv.put(key, value);
                    }
                }
                binaryPath = new Path(amConfig.getStagingDir(), "tez-dag.pb." + appId.toString());
                amConfig.getAMConf().set("tez.am.dag-am-plan.remote.path", binaryPath.toUri().toString());
                dagPB = dag.createDag(null);
                FSDataOutputStream dagPBOutBinaryStream = null;
                try {
                    dagPBOutBinaryStream = FileSystem.create((FileSystem)fs, (Path)binaryPath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
                    dagPB.writeTo((OutputStream)dagPBOutBinaryStream);
                    Object var30_33 = null;
                    if (dagPBOutBinaryStream == null) break block28;
                }
                catch (Throwable throwable) {
                    Object var30_34 = null;
                    if (dagPBOutBinaryStream != null) {
                        dagPBOutBinaryStream.close();
                    }
                    throw throwable;
                }
                dagPBOutBinaryStream.close();
            }
            localResources.put("tez-dag.pb", TezClientUtils.createLocalResource(fs, binaryPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            if (Level.DEBUG.isGreaterOrEqual((Priority)Level.toLevel((String)amLogLevel))) {
                Path textPath = TezClientUtils.localizeDagPlanAsText(dagPB, fs, amConfig.getStagingDir(), appId);
                localResources.put("tez-dag.pb.txt", TezClientUtils.createLocalResource(fs, textPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            }
        }
        HashMap acls = new HashMap();
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(localResources, environment, vargsFinal, null, (ByteBuffer)securityTokens, acls);
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationType("TEZ");
        appContext.setApplicationId(appId);
        appContext.setResource(capability);
        if (amConfig.getQueueName() != null) {
            appContext.setQueue(amConfig.getQueueName());
        }
        appContext.setApplicationName(amName);
        appContext.setCancelTokensWhenComplete(amConfig.getAMConf().getBoolean("tez.am.am.complete.cancel.delegation.tokens", true));
        appContext.setAMContainerSpec(amContainer);
        return appContext;
    }

    static Map<String, String> createEnvironment(Configuration conf) {
        HashMap<String, String> environment = new HashMap<String, String>();
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)(ApplicationConstants.Environment.PWD.$() + File.separator + "*"));
        for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim());
        }
        return environment;
    }

    @VisibleForTesting
    static void addLog4jSystemProperties(String logLevel, List<String> vargs) {
        vargs.add("-Dlog4j.configuration=tez-container-log4j.properties");
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dtez.root.logger=" + logLevel + "," + "CLA");
    }

    static Configuration createFinalTezConfForApp(TezConfiguration tezConf, TezConfiguration amConf) {
        Map.Entry entry;
        Configuration conf = new Configuration(false);
        conf.setQuietMode(true);
        assert (tezConf != null);
        assert (amConf != null);
        Iterator iter = tezConf.iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            if (!((String)entry.getKey()).startsWith("tez.")) continue;
            conf.set((String)entry.getKey(), (String)entry.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Adding tez dag am parameter from conf: " + (String)entry.getKey() + ", with value: " + (String)entry.getValue()));
        }
        iter = amConf.iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            if (!((String)entry.getKey()).startsWith("tez.")) continue;
            conf.set((String)entry.getKey(), (String)entry.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Adding tez dag am parameter from amConf: " + (String)entry.getKey() + ", with value: " + (String)entry.getValue()));
        }
        return conf;
    }

    static LocalResource createLocalResource(FileSystem fs, Path p, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        LocalResource rsrc = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus rsrcStat = fs.getFileStatus(p);
        rsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)fs.resolvePath(rsrcStat.getPath())));
        rsrc.setSize(rsrcStat.getLen());
        rsrc.setTimestamp(rsrcStat.getModificationTime());
        rsrc.setType(type);
        rsrc.setVisibility(visibility);
        return rsrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Path localizeDagPlanAsText(DAGProtos.DAGPlan dagPB, FileSystem fs, Path appStagingDir, ApplicationId appId) throws IOException {
        Path textPath = new Path(appStagingDir, "tez-dag.pb.txt." + appId.toString());
        FSDataOutputStream dagPBOutTextStream = null;
        try {
            dagPBOutTextStream = FileSystem.create((FileSystem)fs, (Path)textPath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
            String dagPBStr = dagPB.toString();
            int dagPBStrLen = dagPBStr.length();
            if (dagPBStrLen <= 16384) {
                dagPBOutTextStream.writeUTF(dagPBStr);
            } else {
                for (int startIndex = 0; startIndex < dagPBStrLen; startIndex += 16384) {
                    int endIndex = startIndex + 16384;
                    if (endIndex > dagPBStrLen) {
                        endIndex = dagPBStrLen;
                    }
                    dagPBOutTextStream.writeUTF(dagPBStr.substring(startIndex, endIndex));
                }
            }
            Object var11_10 = null;
            if (dagPBOutTextStream == null) return textPath;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (dagPBOutTextStream == null) throw throwable;
            dagPBOutTextStream.close();
            throw throwable;
        }
        dagPBOutTextStream.close();
        return textPath;
    }

    static DAGClientAMProtocolBlockingPB getSessionAMProxy(YarnClient yarnClient, Configuration conf, ApplicationId applicationId) throws TezException, IOException {
        ApplicationReport appReport;
        try {
            appReport = yarnClient.getApplicationReport(applicationId);
            if (appReport == null) {
                throw new TezUncheckedException("Could not retrieve application report from YARN, applicationId=" + applicationId);
            }
            YarnApplicationState appState = appReport.getYarnApplicationState();
            if (appState != YarnApplicationState.RUNNING) {
                if (appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.KILLED || appState == YarnApplicationState.FAILED) {
                    throw new SessionNotRunning("Application not running, applicationId=" + applicationId + ", yarnApplicationState=" + appReport.getYarnApplicationState() + ", finalApplicationStatus=" + appReport.getFinalApplicationStatus() + ", trackingUrl=" + appReport.getTrackingUrl());
                }
                return null;
            }
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return TezClientUtils.getAMProxy(conf, appReport.getHost(), appReport.getRpcPort(), appReport.getClientToAMToken());
    }

    @InterfaceAudience.Private
    public static DAGClientAMProtocolBlockingPB getAMProxy(final Configuration conf, String amHost, int amRpcPort, org.apache.hadoop.yarn.api.records.Token clientToAMToken) throws IOException {
        final InetSocketAddress serviceAddr = new InetSocketAddress(amHost, amRpcPort);
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName());
        if (clientToAMToken != null) {
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)clientToAMToken, (InetSocketAddress)serviceAddr);
            userUgi.addToken(token);
        }
        LOG.debug((Object)("Connecting to " + serviceAddr));
        DAGClientAMProtocolBlockingPB proxy = null;
        try {
            proxy = (DAGClientAMProtocolBlockingPB)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DAGClientAMProtocolBlockingPB>(){

                @Override
                public DAGClientAMProtocolBlockingPB run() throws IOException {
                    RPC.setProtocolEngine((Configuration)conf, DAGClientAMProtocolBlockingPB.class, ProtobufRpcEngine.class);
                    return (DAGClientAMProtocolBlockingPB)RPC.getProxy(DAGClientAMProtocolBlockingPB.class, (long)0L, (InetSocketAddress)serviceAddr, (Configuration)conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to connect to AM", e);
        }
        return proxy;
    }
}

