/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class VertexManagerEvent
extends Event {
    private final String targetVertexName;
    private TaskAttemptIdentifier producerAttempt;
    private final ByteBuffer userPayload;

    private VertexManagerEvent(String vertexName, ByteBuffer userPayload) {
        Preconditions.checkArgument(vertexName != null);
        Preconditions.checkArgument(userPayload != null);
        this.targetVertexName = vertexName;
        this.userPayload = userPayload;
    }

    public static VertexManagerEvent create(String vertexName, ByteBuffer userPayload) {
        return new VertexManagerEvent(vertexName, userPayload);
    }

    public String getTargetVertexName() {
        return this.targetVertexName;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public TaskAttemptIdentifier getProducerAttemptIdentifier() {
        return this.producerAttempt;
    }

    @InterfaceAudience.Private
    public void setProducerAttemptIdentifier(TaskAttemptIdentifier producerAttempt) {
        this.producerAttempt = producerAttempt;
    }
}

