/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.sra.filters.CustomGatewayFilterFactory;
import org.apache.syncope.sra.filters.ModifyResponseGatewayFilterFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;

public class LinkRewriteGatewayFilterFactory
extends ModifyResponseGatewayFilterFactory {
    @Override
    protected boolean skipCond(ServerHttpResponseDecorator decorator) {
        return decorator.getHeaders().getContentType() == null || !Strings.CI.contains((CharSequence)decorator.getHeaders().getContentType().toString(), (CharSequence)"html");
    }

    private Charset getCharset(ServerHttpResponseDecorator decorator) {
        return decorator.getHeaders().getContentType() != null && decorator.getHeaders().getContentType().getCharset() != null ? decorator.getHeaders().getContentType().getCharset() : StandardCharsets.UTF_8;
    }

    private void replace(Document doc, String element, String attr, String prefix) {
        doc.select(element).forEach(link -> {
            String attrValue = link.attributes().get(attr);
            if (attrValue.startsWith("/") && !attrValue.startsWith("//")) {
                link.attr(attr, attrValue.replace(attrValue, prefix + attrValue));
            }
        });
    }

    @Override
    protected byte[] modifyResponse(InputStream responseBody, CustomGatewayFilterFactory.Config config, ServerHttpResponseDecorator decorator, ServerWebExchange exchange) throws IOException {
        String[] keyValue = config.getData().split(",");
        String oldBase = Strings.CS.appendIfMissing(keyValue[0], (CharSequence)"/", new CharSequence[0]);
        String newBase = Strings.CS.appendIfMissing(keyValue[1], (CharSequence)"/", new CharSequence[0]);
        String newBaseAsPrefix = Strings.CS.removeEnd(keyValue[1], (CharSequence)"/");
        boolean rewriterRootAttrs = true;
        if (keyValue.length == 3) {
            rewriterRootAttrs = BooleanUtils.toBoolean((String)keyValue[2]);
        }
        Document doc = Jsoup.parse((InputStream)responseBody, (String)this.getCharset(decorator).name(), (String)exchange.getRequest().getURI().toASCIIString());
        if (rewriterRootAttrs) {
            this.replace(doc, "a", "href", newBaseAsPrefix);
            this.replace(doc, "link", "href", newBaseAsPrefix);
            this.replace(doc, "img", "src", newBaseAsPrefix);
            this.replace(doc, "script", "src", newBaseAsPrefix);
            this.replace(doc, "object", "data", newBaseAsPrefix);
        }
        return doc.toString().replace(oldBase, newBase).getBytes();
    }
}

