/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.pac4j;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public class ServerWebExchangeHttpActionAdapter
implements HttpActionAdapter {
    public static final ServerWebExchangeHttpActionAdapter INSTANCE = new ServerWebExchangeHttpActionAdapter();

    public Mono<Void> adapt(HttpAction action, WebContext context) {
        if (action == null) {
            throw new TechnicalException("No action provided");
        }
        ServerHttpResponse response = ((ServerWebExchangeContext)context).getNative().getResponse();
        HttpAction httpAction = action;
        Objects.requireNonNull(httpAction);
        HttpAction httpAction2 = httpAction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WithLocationAction.class, WithContentAction.class}, (Object)httpAction2, n)) {
            case 0: {
                WithLocationAction withLocationAction = (WithLocationAction)httpAction2;
                response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
                response.getHeaders().setLocation(URI.create(withLocationAction.getLocation()));
                return response.setComplete();
            }
            case 1: {
                WithContentAction withContentAction = (WithContentAction)httpAction2;
                String content = Optional.ofNullable(withContentAction.getContent()).orElseThrow(() -> new TechnicalException("No content set for POST AuthnRequest"));
                return Mono.defer(() -> {
                    response.getHeaders().setContentType(MediaType.TEXT_HTML);
                    return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(content.getBytes(StandardCharsets.UTF_8))));
                });
            }
        }
        throw new TechnicalException("Unsupported Action: " + action.getClass().getName());
    }
}

