/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.pac4j;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.ForwardedHeaderUtils;

public class ServerWebExchangeContext
implements WebContext {
    private final ServerWebExchange exchange;
    private MultiValueMap<String, String> form;
    private String body;

    public ServerWebExchangeContext(ServerWebExchange exchange) {
        CommonHelper.assertNotNull((String)"exchange", (Object)exchange);
        this.exchange = exchange;
    }

    public Optional<String> getRequestAttribute(String name) {
        return Optional.ofNullable((String)this.exchange.getAttribute(name));
    }

    public void setRequestAttribute(String name, Object value) {
        this.exchange.getAttributes().put(name, value);
    }

    public Optional<String> getRequestParameter(String name) {
        Object[] values;
        Map<String, String[]> params = this.getRequestParameters();
        if (params.containsKey(name) && !ArrayUtils.isEmpty((Object[])(values = params.get(name)))) {
            return Optional.of(values[0]);
        }
        return Optional.empty();
    }

    public ServerWebExchangeContext setForm(MultiValueMap<String, String> form) {
        this.form = form;
        return this;
    }

    public Optional<String> getQueryString() {
        return Optional.ofNullable(this.exchange.getRequest().getURI().getQuery());
    }

    public Map<String, String[]> getRequestParameters() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        this.exchange.getRequest().getQueryParams().forEach((key, value) -> params.put((String)key, new String[]{value.toString()}));
        if (this.form != null) {
            this.form.forEach((key, values) -> params.put((String)key, (String[])values.toArray(String[]::new)));
        }
        return params;
    }

    public Optional<String> getRequestHeader(String name) {
        return Optional.ofNullable(this.exchange.getRequest().getHeaders().getFirst(name));
    }

    public String getRequestMethod() {
        return this.exchange.getRequest().getMethod().name();
    }

    public String getRemoteAddr() {
        return this.exchange.getRequest().getRemoteAddress().getHostString();
    }

    public ServerWebExchange getNative() {
        return this.exchange;
    }

    public void setResponseHeader(String name, String value) {
    }

    public Optional<String> getResponseHeader(String s) {
        return Optional.ofNullable(this.exchange.getResponse().getHeaders().getFirst(s));
    }

    public void setResponseContentType(String content) {
        this.exchange.getResponse().getHeaders().set("Content-Type", content);
    }

    public String getProtocol() {
        return this.isSecure() ? "https" : "http";
    }

    public String getServerName() {
        return ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)this.exchange.getRequest().getURI(), (HttpHeaders)this.exchange.getRequest().getHeaders()).build().getHost();
    }

    public int getServerPort() {
        return ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)this.exchange.getRequest().getURI(), (HttpHeaders)this.exchange.getRequest().getHeaders()).build().getPort();
    }

    public String getScheme() {
        return ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)this.exchange.getRequest().getURI(), (HttpHeaders)this.exchange.getRequest().getHeaders()).build().getScheme();
    }

    public boolean isSecure() {
        return this.exchange.getRequest().getSslInfo() != null;
    }

    public String getFullRequestURL() {
        return ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)this.exchange.getRequest().getURI(), (HttpHeaders)this.exchange.getRequest().getHeaders()).build().toUriString();
    }

    public Collection<Cookie> getRequestCookies() {
        MultiValueMap cookies = this.exchange.getRequest().getCookies();
        LinkedHashSet<Cookie> pac4jCookies = new LinkedHashSet<Cookie>();
        cookies.toSingleValueMap().values().forEach(c -> {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            pac4jCookies.add(cookie);
        });
        return pac4jCookies;
    }

    public void addResponseCookie(Cookie cookie) {
        ResponseCookie.ResponseCookieBuilder c = ResponseCookie.from((String)cookie.getName(), (String)cookie.getValue());
        c.secure(cookie.isSecure());
        c.path(cookie.getPath());
        c.maxAge((long)cookie.getMaxAge());
        c.httpOnly(cookie.isHttpOnly());
        c.domain(cookie.getDomain());
        this.exchange.getResponse().addCookie(c.build());
    }

    public String getPath() {
        return this.exchange.getRequest().getPath().value();
    }

    public ServerWebExchangeContext setBody(String body) {
        this.body = body;
        return this;
    }

    public String getRequestContent() {
        return this.body;
    }
}

