/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.cas;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.apache.syncope.sra.security.cas.CASUtils;
import org.apache.syncope.sra.security.web.server.DoNothingIfCommittedServerRedirectStrategy;
import org.apache.syncope.sra.session.SessionUtils;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CASAuthenticationRequestWebFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CASAuthenticationRequestWebFilter.class);
    private final ServerWebExchangeMatcher matcher;
    private final Protocol protocol;
    private final String casServerLoginUrl;
    private ServerRedirectStrategy authenticationRedirectStrategy = new DoNothingIfCommittedServerRedirectStrategy();

    public CASAuthenticationRequestWebFilter(PublicRouteMatcher publicRouteMatcher, Protocol protocol, String casServerUrlPrefix) {
        this.matcher = ServerWebExchangeMatchers.matchers((ServerWebExchangeMatcher[])new ServerWebExchangeMatcher[]{publicRouteMatcher, CASUtils.ticketAvailable(protocol), SessionUtils.authInSession()});
        this.protocol = protocol;
        this.casServerLoginUrl = StringUtils.appendIfMissing((String)casServerUrlPrefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "login";
    }

    public void setAuthenticationRedirectStrategy(ServerRedirectStrategy authenticationRedirectStrategy) {
        this.authenticationRedirectStrategy = authenticationRedirectStrategy;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(matchResult -> !matchResult.isMatch()).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(r -> exchange.getSession()).flatMap(session -> {
            session.getAttributes().put("INITIAL_REQUEST_URI", exchange.getRequest().getURI());
            LOG.debug("no ticket and no assertion found");
            String serviceUrl = CASUtils.constructServiceUrl(exchange, this.protocol);
            LOG.debug("Constructed service url: {}", (Object)serviceUrl);
            String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.protocol.getServiceParameterName(), (String)serviceUrl, (boolean)false, (boolean)false, null);
            LOG.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
            return this.authenticationRedirectStrategy.sendRedirect(exchange, URI.create(urlToRedirectTo));
        });
    }
}

