/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.syncope.sra.filters.CustomGatewayFilterFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ModifyResponseGatewayFilterFactory
extends CustomGatewayFilterFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(ModifyResponseGatewayFilterFactory.class);

    @Override
    public GatewayFilter apply(CustomGatewayFilterFactory.Config config) {
        return new InternalModifyResponseGatewayFilter(config);
    }

    protected abstract byte[] modifyResponse(InputStream var1, CustomGatewayFilterFactory.Config var2, ServerHttpResponseDecorator var3, ServerWebExchange var4) throws IOException;

    protected boolean skipCond(ServerHttpResponseDecorator decorator) {
        LOG.debug("Decorator: {}", (Object)decorator);
        return false;
    }

    protected class InternalModifyResponseGatewayFilter
    implements GatewayFilter,
    Ordered {
        private final CustomGatewayFilterFactory.Config config;

        public InternalModifyResponseGatewayFilter(CustomGatewayFilterFactory.Config config) {
            this.config = config;
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            return chain.filter(exchange.mutate().response(this.decorate(exchange)).build());
        }

        private ServerHttpResponse decorate(final ServerWebExchange exchange) {
            return new ServerHttpResponseDecorator(exchange.getResponse()){

                public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                    return ModifyResponseGatewayFilterFactory.this.skipCond(this) ? super.writeWith(body) : super.writeWith((Publisher)Flux.from(body).collectList().filter(list -> !list.isEmpty()).map(list -> ((DataBuffer)list.getFirst()).factory().join(list)).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release).map(dataBuffer -> {
                        byte[] output;
                        if (dataBuffer.readableByteCount() > 0) {
                            LOG.trace("Retaining body in exchange attribute");
                            exchange.getAttributes().put("cachedRequestBody", dataBuffer);
                        }
                        boolean inputCompressed = false;
                        if (dataBuffer.readableByteCount() >= 2) {
                            byte[] first2 = new byte[2];
                            dataBuffer.read(first2, 0, 2);
                            dataBuffer.readPosition(0);
                            inputCompressed = first2[0] == 31 && first2[1] == -117;
                        }
                        boolean outputCompressed = false;
                        try (InputStream is = inputCompressed ? new GZIPInputStream(dataBuffer.asInputStream()) : dataBuffer.asInputStream();){
                            outputCompressed = is instanceof GZIPInputStream;
                            output = ModifyResponseGatewayFilterFactory.this.modifyResponse(is, InternalModifyResponseGatewayFilter.this.config, this, exchange);
                        }
                        catch (IOException e) {
                            LOG.error("While modifying response", (Throwable)e);
                            output = new byte[dataBuffer.readableByteCount()];
                            dataBuffer.read(output);
                        }
                        if (outputCompressed) {
                            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
                                 GZIPOutputStream gzipos = new GZIPOutputStream(baos);){
                                gzipos.write(output);
                                gzipos.finish();
                                output = baos.toByteArray();
                            }
                            catch (IOException e) {
                                LOG.error("While GZIP-encoding output", (Throwable)e);
                            }
                        }
                        return exchange.getResponse().bufferFactory().wrap(output);
                    }));
                }

                public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
                    return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMapSequential(p -> p));
                }
            };
        }

        public int getOrder() {
            return -2;
        }
    }
}

