/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public final class ApplicationContextUtils {
    public static <T> T getOrCreateBean(ConfigurableApplicationContext ctx, String actualClazz, Class<T> type) throws ClassNotFoundException {
        Object bean;
        if (ctx.getBeanFactory().containsSingleton(actualClazz)) {
            bean = type.cast(ctx.getBeanFactory().getSingleton(actualClazz));
        } else if (ApplicationListener.class.isAssignableFrom(type)) {
            RootBeanDefinition bd = new RootBeanDefinition(Class.forName(actualClazz));
            bd.setScope("singleton");
            ((BeanDefinitionRegistry)ctx.getBeanFactory()).registerBeanDefinition(actualClazz, (BeanDefinition)bd);
            bean = ctx.getBean(type);
        } else {
            bean = type.cast(ctx.getBeanFactory().createBean(Class.forName(actualClazz)));
            ctx.getBeanFactory().registerSingleton(actualClazz, bean);
        }
        return bean;
    }

    private ApplicationContextUtils() {
    }
}

